/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDatabaseConnectionPoolXaProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabaseConnectionPoolXaProperties.class);
    @Type(base=Integer.class)
    @XmlBinding(path="debug-level")
    @Label(standard="debug level")
    @DefaultValue(text="0")
    @Documentation(content="Sets the debug level for XA drivers.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_DEBUG_LEVEL = new ValueProperty(TYPE, "DebugLevel");
    @Type(base=Integer.class)
    @XmlBinding(path="prepared-statement-cache-size")
    @Label(standard="prepared statement cache size")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Documentation(content="The maximum number of prepared statements cached by this particular XA connection pool. If the value is 0, caching is disabled.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_PREPARED_STATEMENT_CACHE_SIZE = new ValueProperty(TYPE, "PreparedStatementCacheSize");
    @Type(base=Boolean.class)
    @XmlBinding(path="keep-conn-until-tx-complete-enabled")
    @Label(standard="keep the same XA connection until transaction completes")
    @DefaultValue(text="false")
    @Documentation(content="Enabling this option forces the connection pool to reserve a physical connection and provide the same connection to an application throughout transaction processing until the distributed transaction is complete.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_KEEP_CONNECTION_UNTIL_COMPLETED_ENABLED = new ValueProperty(TYPE, "KeepConnectionUntilCompletedEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="end-only-once-enabled")
    @Label(standard="call end method only once per pending start method")
    @DefaultValue(text="false")
    @Documentation(content="Select this option if the XA driver used to create database connections or the DBMS requires that the XAResource.end() method is called only once for each pending XAResource.start() method. If this option is selected, the XA driver will not call XAResource.end(TMSUSPEND), XAResource.end(TMSUCCESS) successively.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_END_ONLY_ONCE_ENABLED = new ValueProperty(TYPE, "EndOnlyOnceEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="recover-only-once-enabled")
    @Label(standard="call recover method only once per resource")
    @DefaultValue(text="false")
    @Documentation(content="Declares whether JTA TM should call recover on the resource only once.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_RECOVER_ONLY_ONCE_ENABLED = new ValueProperty(TYPE, "RecoverOnlyOnceEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="tx-context-on-close-needed")
    @Label(standard="transaction context required on close of JDBC objects")
    @DefaultValue(text="false")
    @Documentation(content="Select this option if the XA driver used to create database connections requires a distributed transaction context when closing various JDBC objects (result sets, statements, connections, and so on).[pbr/]If selected, SQL exceptions that are thrown while closing JDBC objects without a transaction context will be swallowed.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_TRANSACTION_CONTEXT_ON_CLOSE_NEEDED = new ValueProperty(TYPE, "TransactionContextOnCloseNeeded");
    @Type(base=Boolean.class)
    @XmlBinding(path="new-conn-for-commit-enabled")
    @Label(standard="dedicated connection required for commit or rollback")
    @DefaultValue(text="false")
    @Documentation(content="Select this option if the XA driver used to create database connections or the DBMS requires that a dedicated XA connection be used for commit or rollback processing of distributed transactions.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_DEDICATED_CONNECTION_FOR_COMMIT_NEEDED = new ValueProperty(TYPE, "DedicatedConnectionForCommitNeeded");
    @Type(base=Boolean.class)
    @XmlBinding(path="keep-logical-conn-open-on-release")
    @Label(standard="keep logical connection open on release of physical connection")
    @DefaultValue(text="false")
    @Documentation(content="Select this option if the XA driver used to create database connections or the DBMS requires that a logical JDBC connection be kept open while transaction processing continues (although the physical XA connection can be returned to the XA connection pool).[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_KEEP_LOGICAL_CONNECTION_OPEN_ON_RELEASE_ENABLED = new ValueProperty(TYPE, "KeepLogicalConnectionOpenOnReleaseEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="local-transaction-supported")
    @Label(standard="local transactions are supported")
    @DefaultValue(text="false")
    @Documentation(content="Select this option if the XA driver used to create physical database connections supports SQL without global transactions.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_LOCAL_TRANSACTION_SUPPORTED = new ValueProperty(TYPE, "LocalTransactionSupported");
    @Type(base=Boolean.class)
    @XmlBinding(path="resource-health-monitoring-enabled")
    @Label(standard="enable resource health monitoring")
    @DefaultValue(text="false")
    @Documentation(content="Enable monitoring of the resource health.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_RESOURCE_HEALTH_MONITORING_ENABLED = new ValueProperty(TYPE, "ResourceHealthMonitoringEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="rollback-localtx-upon-connclose")
    @Label(standard="perform local rollback upon connection close")
    @DefaultValue(text="false")
    @Documentation(content="Determines whether the connection pool will call the rollback() method on the connection before putting it back in the pool.[pbr/]Note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_ROLLBACK_LOCAL_TX_UPON_CLOSE_ENABLED = new ValueProperty(TYPE, "RollbackLocalTxUponCloseEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="xa-set-transaction-timeout")
    @Label(standard="enable transaction timeout")
    @DefaultValue(text="false")
    @Documentation(content="Select this option to enable setting a transaction branch timeout using the XA resource manager for the connection (typically, the JDBC driver).[pbr/]When selected, the Oracle WebLogic Server Transaction Manager calls the XAResource.setTransactionTimeout() method before calling the XAResource.start method, and passes either the transaction timeout value specified in this descriptor, or the global transaction timeout.[pbr/]You may want to set a transaction branch timeout if you have long-running transactions that exceed the default timeout value on the XA resource.[pbr/]Note that, to use this feature, the resource manager (typically, the JDBC driver) must support the javax.transaction.xa.XAResource.setTransactionTimeout() method.[pbr/]Also note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_TRANSACTION_TIMEOUT_ENABLED = new ValueProperty(TYPE, "TransactionTimeoutEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="xa-transaction-timeout")
    @Label(standard="transaction timeout period (secs)")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Enablement(expr="${ TransactionTimeoutEnabled }")
    @Documentation(content="The number of seconds to set as the transaction branch timeout. If set, this value is passed as the transaction timeout value in the XAResource.setTransactionTimeout() method on the XA resource manager (typically, the JDBC driver).[pbr/]When this value is set to 0, the Oracle WebLogic Server Transaction Manager uses the global Oracle WebLogic Server transaction timeout.[pbr/]If set, this value should be greater than, or equal to the global Oracle WebLogic Server transaction timeout.[pbr/]Note that, to use this feature, the resource manager (typically, the JDBC driver) must support the javax.transaction.xa.XAResource.setTransactionTimeout() method. [pbr/]Also note that this option is only applicable when an XA JDBC driver is used to create the physical database connections in the connection pool.")
    public static final ValueProperty PROP_TRANSACTION_TIMEOUT = new ValueProperty(TYPE, "TransactionTimeout");

    public Value<Integer> getDebugLevel();

    public void setDebugLevel(String var1);

    public void setDebugLevel(Integer var1);

    public Value<Integer> getPreparedStatementCacheSize();

    public void setPreparedStatementCacheSize(String var1);

    public void setPreparedStatementCacheSize(Integer var1);

    public Value<Boolean> isKeepConnectionUntilCompletedEnabled();

    public void setKeepConnectionUntilCompletedEnabled(String var1);

    public void setKeepConnectionUntilCompletedEnabled(Boolean var1);

    public Value<Boolean> isEndOnlyOnceEnabled();

    public void setEndOnlyOnceEnabled(String var1);

    public void setEndOnlyOnceEnabled(Boolean var1);

    public Value<Boolean> isRecoverOnlyOnceEnabled();

    public void setRecoverOnlyOnceEnabled(String var1);

    public void setRecoverOnlyOnceEnabled(Boolean var1);

    public Value<Boolean> isTransactionContextOnCloseNeeded();

    public void setTransactionContextOnCloseNeeded(String var1);

    public void setTransactionContextOnCloseNeeded(Boolean var1);

    public Value<Boolean> isDedicatedConnectionForCommitNeeded();

    public void setDedicatedConnectionForCommitNeeded(String var1);

    public void setDedicatedConnectionForCommitNeeded(Boolean var1);

    public Value<Boolean> isKeepLogicalConnectionOpenOnReleaseEnabled();

    public void setKeepLogicalConnectionOpenOnReleaseEnabled(String var1);

    public void setKeepLogicalConnectionOpenOnReleaseEnabled(Boolean var1);

    public Value<Boolean> isLocalTransactionSupported();

    public void setLocalTransactionSupported(String var1);

    public void setLocalTransactionSupported(Boolean var1);

    public Value<Boolean> isResourceHealthMonitoringEnabled();

    public void setResourceHealthMonitoringEnabled(String var1);

    public void setResourceHealthMonitoringEnabled(Boolean var1);

    public Value<Boolean> isRollbackLocalTxUponCloseEnabled();

    public void setRollbackLocalTxUponCloseEnabled(String var1);

    public void setRollbackLocalTxUponCloseEnabled(Boolean var1);

    public Value<Boolean> isTransactionTimeoutEnabled();

    public void setTransactionTimeoutEnabled(String var1);

    public void setTransactionTimeoutEnabled(Boolean var1);

    public Value<Integer> getTransactionTimeout();

    public void setTransactionTimeout(String var1);

    public void setTransactionTimeout(Integer var1);
}

