/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDatabaseConnectionPoolSizeProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabaseConnectionPoolSizeProperties.class);
    @Type(base=Integer.class)
    @XmlBinding(path="initial-capacity")
    @Label(standard="initial capacity")
    @DefaultValue(text="1")
    @NumericRange(min="0")
    @Documentation(content="The number of physical database connections to create when creating the connection pool.")
    public static final ValueProperty PROP_INITIAL_CAPACITY = new ValueProperty(TYPE, "InitialCapacity");
    @Type(base=Integer.class)
    @XmlBinding(path="max-capacity")
    @Label(standard="maximum capacity")
    @DefaultValue(text="15")
    @NumericRange(min="1")
    @Documentation(content="Maximum number of physical database connections that this connection pool can contain. Different JDBC drivers and database servers may limit the number of possible physical connections.")
    public static final ValueProperty PROP_MAXIMUM_CAPACITY = new ValueProperty(TYPE, "MaximumCapacity");
    @Type(base=Integer.class)
    @XmlBinding(path="capacity-increment")
    @Label(standard="capacity increment")
    @DefaultValue(text="1")
    @NumericRange(min="1")
    @Documentation(content="Increment by which the connection pool capacity is expanded. When there are no more available physical connections to service requests, the connection pool will create this number of additional physical database connections and add them to the connection pool. The connection pool will ensure that it does not exceed the maximum number of physical connections as set by maximum capacity.")
    public static final ValueProperty PROP_CAPACITY_INCREMENT = new ValueProperty(TYPE, "CapacityIncrement");
    @Type(base=Integer.class)
    @XmlBinding(path="highest-num-waiters")
    @Label(standard="maximum waiting threads")
    @DefaultValue(text="max-int")
    @NumericRange(min="0")
    @Documentation(content="The maximum number of threads that can concurrently block waiting to reserve a connection before an exception is thrown to the requestor.")
    public static final ValueProperty PROP_MAXIMUM_WAITING_THREADS = new ValueProperty(TYPE, "MaximumWaitingThreads");
    @Type(base=Integer.class)
    @XmlBinding(path="highest-num-unavailable")
    @Label(standard="maximum unavailable connections")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Documentation(content="The maximum number of connections in the pool that can be made unavailable (to an application) for purposes such as refreshing the connection, for example. Note that in cases like the backend system being unavailable, this specified value could be exceeded due to factors outside the pool\u2019s control. When set to 0 (default), this feature is disabled.")
    public static final ValueProperty PROP_MAXIMUM_UNAVAILABLE_CONNECTIONS = new ValueProperty(TYPE, "MaximumUnavailableConnections");
    @Type(base=Boolean.class)
    @XmlBinding(path="shrinking-enabled")
    @Label(standard="shrink unused capacity back to initial level")
    @Documentation(content="Indicates whether or not the pool can shrink back to its initial capacity when it is detected that connections created during increased traffic are not being used.[pbr/]When shrinking, the number of connections is reduced to the greater of either the initial capacity or the current number of connections in use.")
    public static final ValueProperty PROP_SHRINKING_ENABLED = new ValueProperty(TYPE, "ShrinkingEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="shrink-frequency-seconds")
    @Label(standard="shrink frequency (secs)")
    @Enablement(expr="${ ShrinkingEnabled }")
    @DefaultValue(text="900")
    @NumericRange(min="0")
    @Documentation(content="Number of seconds to wait before shrinking a connection pool that has increased past the initial capacity to meet demand.")
    public static final ValueProperty PROP_SHRINK_FREQUENCY = new ValueProperty(TYPE, "ShrinkFrequency");
    @Type(base=Integer.class)
    @XmlBinding(path="shrink-period-minutes")
    @Label(standard="shrink frequency (mins)")
    @Enablement(expr="${ ShrinkingEnabled }")
    @Deprecated
    @Documentation(content="Number of minutes to wait before shrinking a connection pool that has increased past the initial capacity to meet demand.")
    public static final ValueProperty PROP_SHRINK_FREQUENCY_MINUTES = new ValueProperty(TYPE, "ShrinkFrequencyMinutes");

    public Value<Integer> getInitialCapacity();

    public void setInitialCapacity(String var1);

    public void setInitialCapacity(Integer var1);

    public Value<Integer> getMaximumCapacity();

    public void setMaximumCapacity(String var1);

    public void setMaximumCapacity(Integer var1);

    public Value<Integer> getCapacityIncrement();

    public void setCapacityIncrement(String var1);

    public void setCapacityIncrement(Integer var1);

    public Value<Integer> getMaximumWaitingThreads();

    public void setMaximumWaitingThreads(String var1);

    public void setMaximumWaitingThreads(Integer var1);

    public Value<Integer> getMaximumUnavailableConnections();

    public void setMaximumUnavailableConnections(String var1);

    public void setMaximumUnavailableConnections(Integer var1);

    public Value<Boolean> isShrinkingEnabled();

    public void setShrinkingEnabled(String var1);

    public void setShrinkingEnabled(Boolean var1);

    public Value<Integer> getShrinkFrequency();

    public void setShrinkFrequency(String var1);

    public void setShrinkFrequency(Integer var1);

    public Value<Integer> getShrinkFrequencyMinutes();

    public void setShrinkFrequencyMinutes(String var1);

    public void setShrinkFrequencyMinutes(Integer var1);
}

