/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionPoolSizeProperties;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionPoolXaProperties;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionTestingProperties;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseDriverParameters;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="JDBC connection pool")
public interface IDatabaseConnectionPool
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabaseConnectionPool.class);
    @XmlBinding(path="data-source-jndi-name")
    @Label(standard="JNDI name")
    @Required
    @NoDuplicates
    @Documentation(content="Specifies the name to assign to this connection pool in the application-specific JNDI tree.")
    public static final ValueProperty PROP_JNDI_NAME = new ValueProperty(TYPE, "JndiName");
    @XmlBinding(path="acl-name")
    @Label(standard="ACL name")
    @Deprecated
    @Documentation(content="This setting is deprecated. Help content is not available.")
    public static final ValueProperty PROP_ACL_NAME = new ValueProperty(TYPE, "AclName");
    @Type(base=Integer.class)
    @XmlBinding(path="pool-params/login-delay-seconds")
    @Label(standard="login delay (secs)")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Documentation(content="Defines a login delay (in seconds) for connection requests. This is used to prevent rapid requests for JDBC connections from overwhelming the DBMS server.")
    public static final ValueProperty PROP_LOGIN_DELAY = new ValueProperty(TYPE, "LoginDelay");
    @Type(base=Boolean.class)
    @XmlBinding(path="pool-params/leak-profiling-enabled")
    @Label(standard="enable JDBC connection leak profiling")
    @Documentation(content="Specifies that JDBC connection leak profiling information should be gathered.[pbr/]A connection leak occurs when a connection from the pool is not closed explicitly by calling the close() method on that connection.[pbr/]When connection leak profiling is active, the connection pool will store the stack trace at the time the connection object is allocated from the connection pool and given to the client. When a connection leak is detected (when the connection object is garbage-collected), this stack trace is reported.[pbr/]This feature uses extra resources and will likely slow down connection pool operations, so it is not recommended for production use.")
    public static final ValueProperty PROP_LEAK_PROFILING_ENABLED = new ValueProperty(TYPE, "LeakProfilingEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="pool-params/remove-infected-connections-enabled")
    @Label(standard="remove infected connections")
    @Documentation(content="Applies only to physical database connections.[pbr/]When set to \"true\" (default), the physical connection is not returned to the connection pool after the application closes the logical connection. Instead, the physical connection is closed and recreated.[pbr/]Note that it is recommended that you set this flag to \"true\", as such connections are not managed by Oracle WebLogic Server.[pbr/]When set to \"false\", if you close the logical connection, the physical connection is returned to the connection pool. If you use this setting, ensure that the database connection is suitable for reuse by other applications.[pbr/]This parameter is applicable only if the application gets a connection from the connection pool and then calls the getVendorConnection() method on that object. The getVendorConnection() method returns a vendor-specific connection to the caller of the method, which might leave the connection pool in an inconsistent state. As a result, Oracle WebLogic Server might remove it from the pool assuming it is an infected connection.[pbr/]Enabling this attribute will have an impact on performance as it will essentially disable the pooling of connections. This is because connections will be removed from the pool and replaced with new connections.")
    public static final ValueProperty PROP_REMOVE_INFECTED_CONNECTIONS_ENABLED = new ValueProperty(TYPE, "RemoveInfectedConnectionsEnabled");
    @Type(base=IDatabaseConnectionFactory.class)
    @XmlBinding(path="connection-factory")
    public static final ImpliedElementProperty PROP_CONNECTION_FACTORY = new ImpliedElementProperty(TYPE, "ConnectionFactory");
    @Type(base=IDatabaseConnectionTestingProperties.class)
    @XmlBinding(path="pool-params/connection-check-params")
    public static final ImpliedElementProperty PROP_CONNECTION_TESTING_PROPERTIES = new ImpliedElementProperty(TYPE, "ConnectionTestingProperties");
    @Type(base=IDatabaseConnectionPoolSizeProperties.class)
    @XmlBinding(path="pool-params/size-params")
    public static final ImpliedElementProperty PROP_CONNECTION_POOL_SIZE_PROPERTIES = new ImpliedElementProperty(TYPE, "ConnectionPoolSizeProperties");
    @Type(base=IDatabaseConnectionPoolXaProperties.class)
    @XmlBinding(path="pool-params/xa-params")
    public static final ImpliedElementProperty PROP_CONNECTION_POOL_XA_PROPERTIES = new ImpliedElementProperty(TYPE, "ConnectionPoolXaProperties");
    @Type(base=IDatabaseDriverParameters.class)
    @XmlBinding(path="driver-params")
    public static final ImpliedElementProperty PROP_DRIVER_PARAMETERS = new ImpliedElementProperty(TYPE, "DriverParameters");

    public Value<String> getJndiName();

    public void setJndiName(String var1);

    public Value<String> getAclName();

    public void setAclName(String var1);

    public Value<Integer> getLoginDelay();

    public void setLoginDelay(String var1);

    public void setLoginDelay(Integer var1);

    public Value<Boolean> isLeakProfilingEnabled();

    public void setLeakProfilingEnabled(String var1);

    public void setLeakProfilingEnabled(Boolean var1);

    public Value<Boolean> isRemoveInfectedConnectionsEnabled();

    public void setRemoveInfectedConnectionsEnabled(String var1);

    public void setRemoveInfectedConnectionsEnabled(Boolean var1);

    public IDatabaseConnectionFactory getConnectionFactory();

    public IDatabaseConnectionTestingProperties getConnectionTestingProperties();

    public IDatabaseConnectionPoolSizeProperties getConnectionPoolSizeProperties();

    public IDatabaseConnectionPoolXaProperties getConnectionPoolXaProperties();

    public IDatabaseDriverParameters getDriverParameters();
}

