/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.credential;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.credential.model.ICredentialConfiguration;
import oracle.eclipse.tools.weblogic.credential.model.ICredentialInfo;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.wst.server.core.IRuntime;

public class WeblogicCredentialConfig {
    private static ICredentialConfiguration cfg = null;

    public static ICredentialConfiguration getCredentialConfiguration() {
        if (cfg != null) {
            return cfg;
        }
        try {
            File credentailCfgFile = WeblogicCredentialConfig.getCredentialCfgFile();
            XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(credentailCfgFile));
            cfg = (ICredentialConfiguration)ICredentialConfiguration.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
            return cfg;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void reload() {
        cfg = null;
    }

    private static File getCredentialCfgFile() {
        IPath stateLocation = WlsCorePlugin.getInstance().getStateLocation();
        File credentailCfgFile = new File(String.valueOf(stateLocation.toPortableString()) + "/oracle.eclipse.tools.weblogic.credentials.xml");
        if (!credentailCfgFile.exists()) {
            StringBuilder runtimeList = new StringBuilder();
            for (IRuntime rt : WebLogicServerUtil.getWebLogicRuntimes()) {
                runtimeList.append("<credential name=\"WebLogic " + rt.getRuntimeType().getVersion() + " Demo Trust keystore\" runtime-id=\"" + rt.getId() + "\"/>");
                runtimeList.append("\n");
            }
            try {
                FileUtil.writeTextFile((File)credentailCfgFile, (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<credentials>\n" + runtimeList + " \n</credentials>"));
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return credentailCfgFile;
    }

    public static void updateWeblogicDemoTrustStorePreference(IRuntime rt, boolean remove) {
        ICredentialConfiguration credential = WeblogicCredentialConfig.getCredentialConfiguration();
        try {
            if (cfg == null) {
                return;
            }
            if (remove) {
                for (ICredentialInfo c : credential.getCredentialInfo()) {
                    String v2;
                    String v1 = rt.getId();
                    if (!v1.equals(v2 = (String)c.getRuntimeId().content())) continue;
                    credential.getCredentialInfo().remove((Object)c);
                    break;
                }
            } else {
                ICredentialInfo credInfo = (ICredentialInfo)credential.getCredentialInfo().insert(ICredentialInfo.class);
                credInfo.setName(String.valueOf(rt.getId()) + " Demo Trust keystore");
                credInfo.setRuntimeId(rt.getId());
            }
            credential.resource().save();
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
    }
}

