/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.appmodel.internal;

import oracle.eclipse.tools.weblogic.appmodel.IModule;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJmsConfigRef;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class WebLogicJmsConfigRefLocationValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WebLogicJmsConfigRefLocationValidator.this.refresh();
            }
        };
        ((IWebLogicJmsConfigRef)this.context(IWebLogicJmsConfigRef.class)).attach(this.listener, "../Dependencies[#type=IWebLogicJmsConfigRef]/Location");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        IWebLogicJmsConfigRef element = (IWebLogicJmsConfigRef)value.element().nearest(IWebLogicJmsConfigRef.class);
        Path path = (Path)value.content();
        if (path != null) {
            for (IModuleDependency dep : ((IModule)element.nearest(IModule.class)).getDependencies()) {
                Path p;
                if (!(dep instanceof IWebLogicJmsConfigRef) || dep == element || !path.equals((Object)(p = (Path)((IWebLogicJmsConfigRef)dep).getLocation().content()))) continue;
                String msg = NLS.bind((String)Resources.multipleIdenticalJmsDependencies, (Object)path.toPortableString());
                return Status.createErrorStatus((String)msg);
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString());
            if (resource != null && resource instanceof IFile) {
                IFile file = (IFile)resource;
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentDescription contentDescription = null;
                try {
                    contentDescription = contentTypeManager.getDescriptionFor(file.getContents(), file.getName(), IContentDescription.ALL);
                }
                catch (Exception e) {
                    WlsCorePlugin.logException(e);
                }
                if (contentDescription == null || !contentDescription.getContentType().getId().equals("oracle.eclipse.tools.weblogic.descriptors.JmsConfiguration")) {
                    String msg = NLS.bind((String)Resources.notJmsConfiguration, (Object)path.toPortableString());
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            ((IWebLogicJmsConfigRef)this.context(IWebLogicJmsConfigRef.class)).detach(this.listener, "../Dependencies[#type=IWebLogicJmsConfigRef]/Location");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String multipleIdenticalJmsDependencies;
        public static String notJmsConfiguration;

        static {
            Resources.initializeMessages((String)WebLogicJmsConfigRefLocationValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

