/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.applib.internal;

import java.util.Set;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.applib.AppLibrariesContainer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.facet.EARFacetUtils;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public final class UpdateAppLibrariesContainerOnRenameOperation
extends AbstractDataModelOperation {
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block13: {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    IProject project = this.getRenamedProjectMetadata().getProject();
                    if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)EARFacetUtils.EAR_FACET.getId())) {
                        Set referencedProjects = WtpProjectUtil.findProjectsReferencedByEar((IProject)project);
                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                        IProgressMonitor submon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)9);
                        ProgressMonitorUtil.beginTask((IProgressMonitor)submon, (int)referencedProjects.size());
                        try {
                            String oldName = this.getOriginalProjectMetadata().getProjectName();
                            for (IProject referencedProject : WtpProjectUtil.findProjectsReferencedByEar((IProject)project)) {
                                if (!JavaProjectUtil.isJavaProject((IProject)referencedProject)) {
                                    ProgressMonitorUtil.worked((IProgressMonitor)submon, (int)1);
                                    continue;
                                }
                                IJavaProject jproj = JavaCore.create((IProject)referencedProject);
                                IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
                                int n = iClasspathEntryArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IPath path;
                                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                                    if (AppLibrariesContainer.isAppLibrariesContainer(cpe) && (path = cpe.getPath()).segmentCount() > 1 && path.segment(1).equals(oldName)) {
                                        IPath newPath = new Path(path.segment(0)).append(project.getName());
                                        IClasspathEntry newCpe = JavaCore.newContainerEntry((IPath)newPath);
                                        JavaProjectUtil.replaceClasspathEntry((IJavaProject)jproj, (IClasspathEntry)cpe, (IClasspathEntry)newCpe);
                                    }
                                    ++n2;
                                }
                                ProgressMonitorUtil.worked((IProgressMonitor)submon, (int)1);
                            }
                            break block13;
                        }
                        finally {
                            ProgressMonitorUtil.done((IProgressMonitor)submon);
                        }
                    }
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
                }
                catch (CoreException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
        return Status.OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    private ProjectRefactorMetadata getOriginalProjectMetadata() {
        return (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA");
    }

    protected ProjectRefactorMetadata getRenamedProjectMetadata() {
        return (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.PROJECT_METADATA");
    }
}

