/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.sun.ToolsJARLocator;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.WebLogicServerRuntimeComponentType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public final class WlsRuntimeUtil {
    public static final String WEBLOGIC_HOME_CP_VARIABLE = "WEBLOGIC_HOME";
    private static IWlsAdapterListener wlsAdapter = null;
    private static String WLS_ADAPTER_LISTENER_EXT_POINT = "oracle.eclipse.tools.weblogic.wlsAdapterListener";

    public static IRuntimeComponent getWlsRuntimeComponent(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                return WlsRuntimeUtil.getWlsRuntimeComponent(fproj);
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
        }
        return null;
    }

    public static IRuntimeComponent getWlsRuntimeComponent(IFacetedProject project) {
        IRuntimeComponent rc = WlsRuntimeUtil.getWlsRuntimeComponent(project.getPrimaryRuntime());
        if (rc != null) {
            return rc;
        }
        return null;
    }

    public static IRuntimeComponent getWlsRuntimeComponent(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        if (runtime != null) {
            for (Object rcomp : runtime.getRuntimeComponents()) {
                IRuntimeComponent rc = (IRuntimeComponent)rcomp;
                IRuntimeComponentType rct = rc.getRuntimeComponentType();
                if (rct != WebLogicServerRuntimeComponentType.COMPONENT_TYPE) continue;
                return rc;
            }
        }
        return null;
    }

    public static IRuntimeComponentVersion getWlsRuntimeVersion(IProject project) {
        IRuntimeComponent rc = WlsRuntimeUtil.getWlsRuntimeComponent(project);
        if (rc != null) {
            return rc.getRuntimeComponentVersion();
        }
        return null;
    }

    public static IRuntimeComponentVersion getWlsRuntimeVersion(IFacetedProject project) {
        return WlsRuntimeUtil.getWlsRuntimeVersion(project.getProject());
    }

    public static File getWlsRuntimePath(IProject project) {
        return WlsRuntimeUtil.getWlsRuntimePath(WlsRuntimeUtil.getWlsRuntimeComponent(project));
    }

    public static File getWlsRuntimePath(IFacetedProject project) {
        return WlsRuntimeUtil.getWlsRuntimePath(WlsRuntimeUtil.getWlsRuntimeComponent(project));
    }

    public static File getWlsRuntimePath(org.eclipse.wst.common.project.facet.core.runtime.IRuntime r) {
        return WlsRuntimeUtil.getWlsRuntimePath(WlsRuntimeUtil.getWlsRuntimeComponent(r));
    }

    public static File getWlsRuntimePath(IRuntimeComponent rc) {
        String location;
        if (rc != null && (location = rc.getProperty("location")) != null) {
            return new File(location);
        }
        return null;
    }

    public static IPath createWebLogicVarPath(IPath path) {
        return new Path(WEBLOGIC_HOME_CP_VARIABLE).append(path);
    }

    public static IRuntime createWlsRuntime(File wlhome, String name) throws CoreException {
        return WlsRuntimeUtil.createWlsRuntime(wlhome, name, true);
    }

    public static IRuntime createWlsRuntime(File wlhome, String name, boolean save) throws CoreException {
        IRuntimeComponentVersion rcv = WlsRuntimeComponentType.detectVersion(wlhome);
        if (rcv == null) {
            return null;
        }
        IRuntimeType rtype = WlsRuntimeComponentType.convert(rcv);
        IRuntimeWorkingCopy created = rtype.createRuntime(null, null);
        created.setName(name != null ? name : ServerUtil.createDefaultRuntimeName((IRuntimeType)rtype));
        created.setLocation((IPath)new Path(wlhome.getAbsolutePath()));
        IStatus validationResult = created.validate(null);
        if (validationResult.getSeverity() == 4) {
            throw new CoreException(validationResult);
        }
        if (save) {
            created.save(true, null);
            RuntimeBridgeUtil.bridge((IRuntime)created.getOriginal()).getRuntimeComponents();
            return created.getOriginal();
        }
        return created;
    }

    public static boolean isWlsRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        return WlsRuntimeUtil.getWlsRuntimeComponent(runtime) != null;
    }

    public static boolean isWlsRuntime(IRuntime runtime) {
        return WebLogicServerUtil.isWebLogicRuntime(runtime);
    }

    public static boolean isWlsRuntimeDefined() {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            if (WlsRuntimeUtil.isWlsRuntime(r)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isValidWebLogicHome(File f) {
        return WlsRuntimeComponentType.detectVersion(f) != null;
    }

    public static File getToolsJAR(IRuntimeComponent component) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
        if (component != null && (runtime = component.getRuntime()) != null) {
            IPath javaVMLocation;
            IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)r.getAdapter(IWeblogicServerRuntime.class);
            IPath iPath = javaVMLocation = wsr != null ? wsr.getJavaVmLocation() : null;
            if (javaVMLocation != null) {
                return ToolsJARLocator.findToolsJAR((File)javaVMLocation.toFile());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getMwHome(File wlhome) {
        try {
            Properties prodProp = new Properties();
            File prodPropFile = new File(wlhome, ".product.properties");
            if (!prodPropFile.exists()) {
                return wlhome.getParentFile();
            }
            try (FileInputStream fis = null;){
                fis = new FileInputStream(prodPropFile);
                prodProp.load(fis);
                String mwHome = (String)prodProp.get("MW_HOME");
                if (mwHome != null && new File(mwHome).exists()) {
                    File file2 = new File(mwHome);
                    return file2;
                }
                File file = wlhome.getParentFile();
                return file;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return wlhome.getParentFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wlhome.getParentFile();
    }

    public static IRuntime getRuntime(String runtimeid) {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getId().equals(runtimeid)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    public static IWlsAdapterListener getWlsAdapter() {
        IExtensionRegistry registry;
        IExtensionPoint extPoint;
        IConfigurationElement[] configs;
        if (wlsAdapter == null && (configs = (extPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(WLS_ADAPTER_LISTENER_EXT_POINT)).getConfigurationElements()) != null && configs.length > 0) {
            try {
                Object obj = configs[0].createExecutableExtension("class");
                if (obj instanceof IWlsAdapterListener) {
                    wlsAdapter = (IWlsAdapterListener)obj;
                }
            }
            catch (CoreException coreException) {}
        }
        return wlsAdapter;
    }
}

