/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public final class WlsRuntimeSpy {
    private static final String EXTENSION_POINT_ID = "wlsRuntimeLifecycleListener";
    private static final String EL_LISTENER = "listener";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_TYPES = "eventTypes";
    private static boolean initialized = false;
    private static boolean extensionsLoaded = false;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new IRuntimeLifecycleListener(){

            public void runtimeAdded(IRuntime runtime) {
                this.handle(runtime, EventType.ADDED);
            }

            public void runtimeChanged(IRuntime runtime) {
                this.handle(runtime, EventType.CHANGED);
            }

            public void runtimeRemoved(IRuntime runtime) {
                this.handle(runtime, EventType.REMOVED);
            }

            private void handle(IRuntime runtime, EventType handler) {
                if (WlsRuntimeUtil.isWlsRuntime(runtime)) {
                    WlsRuntimeSpy.loadExtensions();
                    handler.notifyListeners(runtime);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void refreshWlsRuntimes() {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            WlsRuntimeSpy.loadExtensions();
            EventType handler = EventType.ADDED;
            if (WlsRuntimeUtil.isWlsRuntime(rt)) {
                IListener[] copy;
                final IRuntime runtime = rt;
                Set set = handler.listeners;
                synchronized (set) {
                    copy = handler.listeners.toArray(new IListener[handler.listeners.size()]);
                }
                Thread notificationThread = new Thread(){

                    @Override
                    public void run() {
                        IListener[] iListenerArray = copy;
                        int n = copy.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IListener listener = iListenerArray[n2];
                            try {
                                listener.handleEvent(runtime, EventType.REFRESH);
                            }
                            catch (Throwable e) {
                                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                            }
                            ++n2;
                        }
                    }
                };
                notificationThread.start();
            }
            ++n2;
        }
    }

    public static synchronized void addListener(IListener listener, EventType ... types) {
        EventType[] eventTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EventType type = eventTypeArray[n2];
            type.addListener(listener);
            ++n2;
        }
    }

    public static synchronized void removeListener(IListener listener, EventType ... types) {
        EventType[] eventTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EventType type = eventTypeArray[n2];
            type.removeListener(listener);
            ++n2;
        }
    }

    private static synchronized void loadExtensions() {
        if (extensionsLoaded) {
            return;
        }
        extensionsLoaded = true;
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_LISTENER)) continue;
            try {
                String clname = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                IListener listener = (IListener)PluginUtil.instantiate((String)pluginId, (String)clname, IListener.class);
                if (listener == null) {
                    throw new PluginUtil.InvalidExtensionException();
                }
                String eventTypes = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_TYPES);
                String[] stringArray = eventTypes.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    segment = segment.trim();
                    try {
                        String uppercased = segment.toUpperCase();
                        EventType.valueOf(uppercased).addListener(listener);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String msg = Resources.bind((String)Resources.invalidEventType, (Object)segment, (Object)pluginId);
                        LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                    }
                    ++n2;
                }
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    public static enum EventType {
        ADDED,
        CHANGED,
        REMOVED,
        REFRESH;

        private Set<IListener> listeners = new HashSet<IListener>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(IListener listener) {
            Set<IListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener(IListener listener) {
            Set<IListener> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(final IRuntime runtime) {
            IListener[] copy;
            Set<IListener> set = this.listeners;
            synchronized (set) {
                copy = this.listeners.toArray(new IListener[this.listeners.size()]);
            }
            Thread notificationThread = new Thread(){

                @Override
                public void run() {
                    IListener[] iListenerArray = copy;
                    int n = copy.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IListener listener = iListenerArray[n2];
                        try {
                            listener.handleEvent(runtime, EventType.this);
                        }
                        catch (Throwable e) {
                            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                        }
                        ++n2;
                    }
                }
            };
            notificationThread.start();
        }
    }

    public static interface IListener {
        public void handleEvent(IRuntime var1, EventType var2);
    }

    public static final class Resources
    extends NLS {
        public static String invalidEventType;

        static {
            Resources.initializeMessages((String)WlsRuntimeSpy.class.getName(), Resources.class);
        }
    }
}

