/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntimeType;

public final class WlsRuntimeComponentType {
    public static final String ID = "com.bea.weblogic";
    public static final IRuntimeComponentType INSTANCE = RuntimeManager.getRuntimeComponentType((String)"com.bea.weblogic");
    public static final IRuntimeComponentVersion VERSION_9_2 = INSTANCE.getVersion("9.2");
    public static final IRuntimeComponentVersion VERSION_10_0 = INSTANCE.getVersion("10.0");
    public static final IRuntimeComponentVersion VERSION_10_3 = INSTANCE.getVersion("10.3.0");
    public static final IRuntimeComponentVersion VERSION_10_3_1 = INSTANCE.getVersion("10.3.1");
    public static final IRuntimeComponentVersion VERSION_10_3_2 = INSTANCE.getVersion("10.3.2");
    public static final IRuntimeComponentVersion VERSION_10_3_3 = INSTANCE.getVersion("10.3.3");
    public static final IRuntimeComponentVersion VERSION_10_3_4 = INSTANCE.getVersion("10.3.4");
    public static final IRuntimeComponentVersion VERSION_10_3_5 = INSTANCE.getVersion("10.3.5");
    public static final IRuntimeComponentVersion VERSION_10_3_6 = INSTANCE.getVersion("10.3.6");
    public static final IRuntimeComponentVersion VERSION_12_1_1 = INSTANCE.getVersion("12.1.1");
    public static final IRuntimeComponentVersion VERSION_12_1_2 = INSTANCE.getVersion("12.1.2");
    private static Map<IRuntimeType, IRuntimeComponentVersion> TYPE_TO_RCV = new HashMap<IRuntimeType, IRuntimeComponentVersion>();
    private static Map<IRuntimeComponentVersion, IRuntimeType> RCV_TO_TYPE;

    static {
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_9_2, VERSION_9_2);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_0, VERSION_10_0);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3, VERSION_10_3);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_1, VERSION_10_3_1);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_2, VERSION_10_3_2);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_3, VERSION_10_3_3);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_4, VERSION_10_3_4);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_5, VERSION_10_3_5);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_10_3_6, VERSION_10_3_6);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_12_1_1, VERSION_12_1_1);
        TYPE_TO_RCV.put(IWeblogicServerRuntime.RUNTIME_TYPE_12_1_2, VERSION_12_1_2);
        RCV_TO_TYPE = new HashMap<IRuntimeComponentVersion, IRuntimeType>();
        RCV_TO_TYPE.put(VERSION_9_2, IWeblogicServerRuntime.RUNTIME_TYPE_9_2);
        RCV_TO_TYPE.put(VERSION_10_0, IWeblogicServerRuntime.RUNTIME_TYPE_10_0);
        RCV_TO_TYPE.put(VERSION_10_3, IWeblogicServerRuntime.RUNTIME_TYPE_10_3);
        RCV_TO_TYPE.put(VERSION_10_3_1, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_1);
        RCV_TO_TYPE.put(VERSION_10_3_2, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_2);
        RCV_TO_TYPE.put(VERSION_10_3_3, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_3);
        RCV_TO_TYPE.put(VERSION_10_3_4, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_4);
        RCV_TO_TYPE.put(VERSION_10_3_5, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_5);
        RCV_TO_TYPE.put(VERSION_10_3_6, IWeblogicServerRuntime.RUNTIME_TYPE_10_3_6);
        RCV_TO_TYPE.put(VERSION_12_1_1, IWeblogicServerRuntime.RUNTIME_TYPE_12_1_1);
        RCV_TO_TYPE.put(VERSION_12_1_2, IWeblogicServerRuntime.RUNTIME_TYPE_12_1_2);
    }

    public static IRuntimeComponentVersion detectVersion(File wlhome) {
        WebLogicServerVersion v = WebLogicServerVersion.detect(wlhome);
        if (v == null) {
            return null;
        }
        return INSTANCE.getVersion(v.getVersionString());
    }

    public static IRuntimeType convert(IRuntimeComponentVersion rcv) {
        IRuntimeType rtype = RCV_TO_TYPE.get(rcv);
        if (rtype == null) {
            throw new IllegalArgumentException();
        }
        return rtype;
    }

    public static IRuntimeComponentVersion convert(IRuntimeType rtype) {
        IRuntimeComponentVersion rcv = TYPE_TO_RCV.get(rtype);
        if (rcv == null) {
            throw new IllegalArgumentException();
        }
        return rcv;
    }

    private WlsRuntimeComponentType() {
    }
}

