/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class WlsRuntimeClassLoader
extends URLClassLoader {
    private final IRuntimeComponent _component;

    public WlsRuntimeClassLoader(URL[] urls, ClassLoader parent, IRuntimeComponent component) {
        super(urls, parent);
        this._component = component;
    }

    public IRuntimeComponent getRuntimeComponent() {
        return this._component;
    }

    @Override
    public URL[] getURLs() {
        LinkedHashMap<String, URL> expandedURLs = new LinkedHashMap<String, URL>();
        URL[] uRLArray = super.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            expandedURLs.put(url.toString(), url);
            this.recursiveAddManifestClasspath(this.urlToFile(url), expandedURLs);
            ++n2;
        }
        return expandedURLs.values().toArray(new URL[expandedURLs.size()]);
    }

    public URL[] getURLs(Set<String> excludedJars) {
        LinkedHashMap<String, URL> expandedURLs = new LinkedHashMap<String, URL>();
        URL[] uRLArray = super.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            File file = this.urlToFile(url);
            if (!excludedJars.contains(file.getName())) {
                expandedURLs.put(url.toString(), url);
                this.recursiveAddManifestClasspath(this.urlToFile(url), expandedURLs);
            }
            ++n2;
        }
        return expandedURLs.values().toArray(new URL[expandedURLs.size()]);
    }

    private File urlToFile(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            f = new File(url.getPath());
        }
        return f;
    }

    private URL fileToURL(File f) throws MalformedURLException {
        return f.toURL();
    }

    private void recursiveAddManifestClasspath(File f, Map<String, URL> manifestJars) {
        if (!f.isFile()) {
            return;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(f);
            Manifest mf = jar.getManifest();
            if (mf == null) {
                return;
            }
            String classpath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (classpath == null) {
                return;
            }
            try {
                String[] rgPaths;
                File parent = f.getParentFile();
                String[] stringArray = rgPaths = classpath.split(" ");
                int n = rgPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url;
                    String urlStr;
                    File file;
                    String path = stringArray[n2];
                    if (path.length() != 0 && (file = new File(parent, path)).exists() && !manifestJars.containsKey(urlStr = (url = this.fileToURL(file)).toString())) {
                        manifestJars.put(urlStr, url);
                        this.recursiveAddManifestClasspath(file, manifestJars);
                    }
                    ++n2;
                }
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)ioe);
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)e);
                }
            }
        }
    }
}

