/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.classloader.AbstractClassLoaderAdapterFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;

public class WlsRuntimeAdapterFactory
extends AbstractClassLoaderAdapterFactory {
    private final Map<String, String> _types = new HashMap<String, String>();
    private final Map<IRuntimeComponentVersion, Pair<String, String>> _bundleVersions = new HashMap<IRuntimeComponentVersion, Pair<String, String>>();

    protected void mapType(String key, String value) {
        this._types.put(key, value);
    }

    protected void mapBundleVersion(IRuntimeComponentVersion version, String bundleId, String path) {
        assert ("com.bea.weblogic".equals(version.getRuntimeComponentType().getId()));
        this._bundleVersions.put(version, (Pair<String, String>)new Pair((Object)bundleId, (Object)path));
    }

    protected AbstractClassLoaderAdapterFactory.Key getCacheKey(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IRuntimeComponent) {
            IRuntimeComponent component = (IRuntimeComponent)adaptableObject;
            IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)component.getRuntime());
            IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)r.getAdapter(IWeblogicServerRuntime.class);
            IPath path = wsr.getPatchProfileJarPath();
            String location = component.getProperty("location");
            return new AbstractClassLoaderAdapterFactory.Key(adapterType, false, new Object[]{adaptableObject, location, String.valueOf(path)});
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = null;
        if (adaptableObject instanceof IProject) {
            runtime = this.getServerRuntime((IProject)adaptableObject);
        } else if (adaptableObject instanceof ICompilationUnit) {
            runtime = this.getServerRuntime(((ICompilationUnit)adaptableObject).getJavaProject().getProject());
        }
        if (runtime == null || runtime.getProperty("id") == null) {
            return new AbstractClassLoaderAdapterFactory.Key(adapterType, false, new Object[]{adaptableObject});
        }
        IRuntime wstRuntime = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
        IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)wstRuntime.getAdapter(IWeblogicServerRuntime.class);
        String pacthJarPath = wsr != null ? String.valueOf(wsr.getPatchProfileJarPath()) : "";
        IPath rtPath = wstRuntime.getLocation();
        return new AbstractClassLoaderAdapterFactory.Key(adapterType, false, new Object[]{adaptableObject, rtPath != null ? rtPath.toPortableString() : "", pacthJarPath});
    }

    protected IRuntimeComponent getRuntimeComponent(Object adaptableObject) {
        WlsRuntimeClassLoader loader;
        IRuntimeComponent component = null;
        if (adaptableObject instanceof IRuntimeComponent) {
            component = (IRuntimeComponent)adaptableObject;
        } else if (adaptableObject instanceof IProject) {
            WlsRuntimeClassLoader loader2 = this.getWlsRuntimeClassLoader((IProject)adaptableObject);
            if (loader2 != null) {
                component = loader2.getRuntimeComponent();
            }
        } else if (adaptableObject instanceof ICompilationUnit && (loader = this.getWlsRuntimeClassLoader(((ICompilationUnit)adaptableObject).getJavaProject().getProject())) != null) {
            component = loader.getRuntimeComponent();
        }
        return component;
    }

    protected URL[] getClasspathURLsForAdapter(Object adaptableObject) {
        URL[] uRLArray;
        IRuntimeComponent component = this.getRuntimeComponent(adaptableObject);
        if (component == null) {
            return new URL[0];
        }
        assert ("com.bea.weblogic".equals(component.getRuntimeComponentType().getId()));
        Pair<String, String> pair = this._bundleVersions.get(component.getRuntimeComponentVersion());
        if (pair == null) {
            WlsCorePlugin.logError("Server adapater JAR file not found for WebLogic runtime version " + component.getRuntimeComponentVersion());
            return new URL[0];
        }
        URL url = this.getURLForBundlePath((String)pair.getFirst(), (String)pair.getSecond());
        if (url != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = new URL[]{};
        }
        return uRLArray;
    }

    protected ClassLoader getClassLoaderFor(Object adaptableObject) {
        if (adaptableObject instanceof IRuntimeComponent) {
            return (WlsRuntimeClassLoader)((IRuntimeComponent)adaptableObject).getAdapter(WlsRuntimeClassLoader.class);
        }
        if (adaptableObject instanceof IProject) {
            return this.getWlsRuntimeClassLoader((IProject)adaptableObject);
        }
        if (adaptableObject instanceof ICompilationUnit) {
            return this.getWlsRuntimeClassLoader(((ICompilationUnit)adaptableObject).getJavaProject().getProject());
        }
        return null;
    }

    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime getServerRuntime(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            Set runtimes = fproj.getTargetedRuntimes();
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime localTargetRuntime = null;
            Enum localTargetVer = null;
            for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt : runtimes) {
                IWeblogicServerRuntime wsr;
                IRuntime wstRuntime = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
                if (wstRuntime == null || (wsr = (IWeblogicServerRuntime)wstRuntime.getAdapter(IWeblogicServerRuntime.class)) == null) continue;
                WebLogicServerVersion tempVer = WebLogicServerVersion.convert(wstRuntime.getRuntimeType().getVersion());
                if (localTargetVer != null && localTargetVer.compareTo(tempVer) <= 0) continue;
                localTargetRuntime = rt;
                localTargetVer = tempVer;
            }
            return localTargetRuntime;
        }
        catch (CoreException coreException) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)coreException, (String)("unable to determine runtime from project " + project));
            return null;
        }
    }

    protected WlsRuntimeClassLoader getWlsRuntimeClassLoader(IProject project) {
        WlsRuntimeClassLoader wlsLoader = null;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = this.getServerRuntime(project);
        if (runtime == null) {
            return null;
        }
        wlsLoader = (WlsRuntimeClassLoader)runtime.getAdapter(WlsRuntimeClassLoader.class);
        if (wlsLoader == null) {
            LoggingService.logWarning((Plugin)WlsCorePlugin.getInstance(), (String)("Target runtime (" + runtime + ") might not have been defined"));
        }
        return wlsLoader;
    }

    protected String getImplementationType(String interfaceType) {
        return this._types.get(interfaceType);
    }
}

