/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public final class WlsEarUtil {
    public static final List<IProject> findEarProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = ws.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (WtpProjectUtil.isEarProject((IProject)proj)) {
                result.add(proj);
            }
            ++n2;
        }
        return result;
    }

    public static final List<IProject> findReferencingEarProjects(IProject project) {
        ArrayList<IProject> referencing = new ArrayList<IProject>();
        for (IProject ear : WlsEarUtil.findEarProjects()) {
            IVirtualComponent earvc = ComponentCore.createComponent((IProject)ear);
            IVirtualReference[] iVirtualReferenceArray = earvc.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                if (ref.getReferencedComponent() != null && ref.getReferencedComponent().getProject() == project) {
                    referencing.add(ear);
                }
                ++n2;
            }
        }
        return referencing;
    }

    public static boolean isReferencedByEarProject(IProject project) {
        return !WlsEarUtil.findEarProjects().isEmpty();
    }

    public static final boolean isReferencedByWlsEar(IProject project, boolean allowSeveral) {
        return WlsEarUtil.isReferencedByWlsEar(WlsEarUtil.findReferencingEarProjects(project), allowSeveral);
    }

    public static final boolean isReferencedByWlsEar(List<IProject> referencing, boolean allowSeveral) {
        if (referencing.size() == 0 || referencing.size() > 1 && !allowSeveral) {
            return false;
        }
        for (IProject pj : referencing) {
            if (WlsEarFacet.isInstalled(pj)) continue;
            return false;
        }
        return true;
    }

    public static IFolder getEarContentFromEarProject(IProject earProject) {
        IVirtualFolder vfolder;
        IContainer earcontent = null;
        IVirtualComponent vcomp = ComponentCore.createComponent((IProject)earProject);
        if (vcomp != null && (vfolder = vcomp.getRootFolder()) != null) {
            earcontent = vfolder.getUnderlyingFolder();
        }
        if (earcontent instanceof IFolder) {
            return (IFolder)earcontent;
        }
        return null;
    }

    public static IFolder getFirstEarContentForModule(IProject childProject) {
        IFolder earcontent = null;
        if (WlsEarUtil.isReferencedByEarProject(childProject)) {
            IVirtualFolder vfolder;
            IVirtualComponent vcomp = null;
            List<IProject> al = WlsEarUtil.findReferencingEarProjects(childProject);
            if (al != null && al.size() > 0) {
                vcomp = ComponentCore.createComponent((IProject)al.get(0));
            }
            if (vcomp != null && (vfolder = vcomp.getRootFolder()) != null) {
                earcontent = (IFolder)vfolder.getUnderlyingFolder();
            }
        }
        return earcontent;
    }

    private static void addToClasspath(IProject proj, IClasspathEntry cpe) throws CoreException {
        WlsEarUtil.addToClasspath(JavaCore.create((IProject)proj), cpe);
    }

    private static void addToClasspath(IJavaProject jproj, IClasspathEntry cpe) throws CoreException {
        IClasspathEntry[] current;
        IClasspathEntry[] iClasspathEntryArray = current = jproj.getRawClasspath();
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getPath().equals((Object)cpe.getPath())) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = cpe;
        jproj.setRawClasspath(updated, null);
    }
}

