/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.weblogic.DescriptorInfo;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Version;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public enum WebLogicServerVersion {
    VERSION_9_2("9.2", IWeblogicServerRuntime.RUNTIME_TYPE_9_2, ServerCore.findServerType((String)"com.bea.wlw.server92")),
    VERSION_10_0("10.0", IWeblogicServerRuntime.RUNTIME_TYPE_10_0, ServerCore.findServerType((String)"com.bea.wlw.server100")),
    VERSION_10_3_0("10.3.0", "10.3", IWeblogicServerRuntime.RUNTIME_TYPE_10_3, ServerCore.findServerType((String)"com.bea.weblogic103.server")),
    VERSION_10_3_1("10.3.1", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_1, ServerCore.findServerType((String)"com.bea.weblogic1031.server")),
    VERSION_10_3_2("10.3.2", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_2, ServerCore.findServerType((String)"com.bea.weblogic1032.server")),
    VERSION_10_3_3("10.3.3", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_3, ServerCore.findServerType((String)"com.bea.weblogic1033.server")),
    VERSION_10_3_4("10.3.4", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_4, ServerCore.findServerType((String)"com.bea.weblogic1034.server")),
    VERSION_10_3_5("10.3.5", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_5, ServerCore.findServerType((String)"com.bea.weblogic1035.server")),
    VERSION_10_3_6("10.3.6", IWeblogicServerRuntime.RUNTIME_TYPE_10_3_6, ServerCore.findServerType((String)"com.bea.weblogic1036.server")),
    VERSION_12_1_1("12.1.1", IWeblogicServerRuntime.RUNTIME_TYPE_12_1_1, ServerCore.findServerType((String)"com.bea.weblogic1211.server")),
    VERSION_12_1_2("12.1.2", IWeblogicServerRuntime.RUNTIME_TYPE_12_1_2, ServerCore.findServerType((String)"com.bea.weblogic1212.server"));

    private static final String WEBLOGIC_JAR_PATH = "server/lib/weblogic.jar";
    private static final SortedSet<WebLogicServerVersion> EMPTY_VERSIONS_SET;
    private static final int MAX_DETECT_RESULTS_CACHE_SIZE = 100;
    private static final Map<File, DetectCacheEntry> detectResultsCache;
    private final String versionString;
    private final String extFacetVersionString;
    private final IRuntimeType runtimeType;
    private final IServerType serverType;
    private HashMap<String, DescriptorInfo> descriptorMap = new HashMap();

    static {
        EMPTY_VERSIONS_SET = new TreeSet<WebLogicServerVersion>();
        detectResultsCache = new HashMap<File, DetectCacheEntry>();
    }

    private WebLogicServerVersion(String versionString, IRuntimeType runtimeType, IServerType serverType) {
        this(versionString, versionString, runtimeType, serverType);
    }

    private WebLogicServerVersion(String versionString, String extFacetVersionString, IRuntimeType runtimeType, IServerType serverType) {
        this.versionString = versionString;
        this.extFacetVersionString = extFacetVersionString;
        this.runtimeType = runtimeType;
        this.serverType = serverType;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFacetVersionString() {
        return this.extFacetVersionString;
    }

    public IRuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public IServerType getServerType() {
        return this.serverType;
    }

    void addDescriptor(DescriptorInfo info) {
        this.descriptorMap.put(info.type, info);
    }

    public DescriptorInfo findDescriptor(String type) {
        return this.descriptorMap.get(type);
    }

    public static WebLogicServerVersion getNewestVersion() {
        return VERSION_12_1_1;
    }

    public static WebLogicServerVersion convert(Version version) {
        if (version.matches("[9.2-9.3)")) {
            return VERSION_9_2;
        }
        if (version.matches("[10-10.1)")) {
            return VERSION_10_0;
        }
        if (version.matches("[10.3-10.3.1)")) {
            return VERSION_10_3_0;
        }
        if (version.matches("[10.3.1-10.3.2)")) {
            return VERSION_10_3_1;
        }
        if (version.matches("[10.3.2-10.3.3)")) {
            return VERSION_10_3_2;
        }
        if (version.matches("[10.3.3-10.3.4)")) {
            return VERSION_10_3_3;
        }
        if (version.matches("[10.3.4-10.3.5)")) {
            return VERSION_10_3_4;
        }
        if (version.matches("[10.3.5-10.3.6)")) {
            return VERSION_10_3_5;
        }
        if (version.matches("[10.3.6-10.3.7)")) {
            return VERSION_10_3_6;
        }
        if (version.matches("[12.1.1-12.1.2)")) {
            return VERSION_12_1_1;
        }
        if (version.matches("[12.1.2-12.1.3)")) {
            return VERSION_12_1_2;
        }
        return null;
    }

    public static WebLogicServerVersion convert(String str) {
        return WebLogicServerVersion.convert(new Version(str));
    }

    public boolean canSupportJVM(String vmVersion) {
        Version version = new Version(vmVersion);
        long seg1 = version.segment(0);
        long seg2 = version.segment(1);
        if (seg1 == 1L && seg2 >= 7L) {
            return this.compareTo(VERSION_10_3_6) >= 0;
        }
        if (seg1 == 1L && seg2 == 6L) {
            return this.compareTo(VERSION_10_3_0) >= 0 && this.compareTo(VERSION_12_1_1) <= 0;
        }
        if (seg1 == 1L && seg2 == 5L) {
            return this.compareTo(VERSION_9_2) >= 0 && this.compareTo(VERSION_10_3_0) < 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebLogicServerVersion detect(File wlhome) {
        Map<File, DetectCacheEntry> map = detectResultsCache;
        synchronized (map) {
            DetectCacheEntry entry = detectResultsCache.get(wlhome);
            if (entry != null && !entry.isOutOfDate()) {
                entry.resetLastAccessedTime();
                return entry.getVersion();
            }
        }
        File wlJarLocation = new File(wlhome, WEBLOGIC_JAR_PATH);
        WebLogicServerVersion result = null;
        if (wlJarLocation.exists()) {
            String version = null;
            try {
                version = ManifestUtil.readManifestEntry((File)wlJarLocation, (String)"Implementation-Version");
            }
            catch (IOException iOException) {}
            if (version != null) {
                WebLogicServerVersion[] webLogicServerVersionArray = WebLogicServerVersion.values();
                int n = webLogicServerVersionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebLogicServerVersion v = webLogicServerVersionArray[n2];
                    if (version.startsWith(String.valueOf(v.getVersionString()) + ".")) {
                        result = v;
                        break;
                    }
                    ++n2;
                }
            }
        }
        Map<File, DetectCacheEntry> map2 = detectResultsCache;
        synchronized (map2) {
            DetectCacheEntry entry = new DetectCacheEntry(wlhome, result);
            detectResultsCache.put(wlhome, entry);
            if (detectResultsCache.size() > 100) {
                DetectCacheEntry oldestAccessEntry = null;
                for (DetectCacheEntry x : detectResultsCache.values()) {
                    if (oldestAccessEntry != null && x.getLastAccessedTime() >= oldestAccessEntry.getLastAccessedTime()) continue;
                    oldestAccessEntry = x;
                }
                detectResultsCache.remove(oldestAccessEntry.getLocation());
            }
        }
        return result;
    }

    public static WebLogicServerVersion detect(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                return WebLogicServerVersion.detect(fproj);
            }
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        return null;
    }

    public static WebLogicServerVersion detect(IFacetedProject project) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = project.getPrimaryRuntime();
        if (runtime != null) {
            return WebLogicServerVersion.detect(runtime);
        }
        return null;
    }

    public static WebLogicServerVersion detect(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
            WebLogicServerVersion version = WebLogicServerVersion.detect(rc);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    public static WebLogicServerVersion detect(IRuntimeComponent rc) {
        if (rc.getRuntimeComponentType() == WlsRuntimeComponentType.INSTANCE) {
            return WebLogicServerVersion.convert(rc.getRuntimeComponentVersion().getVersionString());
        }
        return null;
    }

    public static WebLogicServerVersion detect(IRuntime runtime) {
        if (runtime != null) {
            return WebLogicServerVersion.detect(runtime.getRuntimeType());
        }
        return null;
    }

    public static WebLogicServerVersion detect(IRuntimeType type) {
        WebLogicServerVersion[] webLogicServerVersionArray = WebLogicServerVersion.values();
        int n = webLogicServerVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WebLogicServerVersion version = webLogicServerVersionArray[n2];
            if (version.getRuntimeType() == type) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public static WebLogicServerVersion detect(IServer server) {
        if (server != null) {
            return WebLogicServerVersion.detect(server.getServerType());
        }
        return null;
    }

    public static WebLogicServerVersion detect(IServerType type) {
        WebLogicServerVersion[] webLogicServerVersionArray = WebLogicServerVersion.values();
        int n = webLogicServerVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WebLogicServerVersion version = webLogicServerVersionArray[n2];
            if (version.getServerType() == type) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public static SortedSet<WebLogicServerVersion> detectAll(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                return WebLogicServerVersion.detectAll(fproj);
            }
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        return EMPTY_VERSIONS_SET;
    }

    public static SortedSet<WebLogicServerVersion> detectAll(IFacetedProject project) {
        SortedSet<WebLogicServerVersion> result = null;
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : project.getTargetedRuntimes()) {
            WebLogicServerVersion version = WebLogicServerVersion.detect(runtime);
            if (version == null) continue;
            if (result == null) {
                result = new TreeSet<WebLogicServerVersion>();
            }
            result.add(version);
        }
        return result != null ? result : EMPTY_VERSIONS_SET;
    }

    public String toString() {
        return this.getVersionString();
    }

    private static final class DetectCacheEntry {
        public final File file;
        public final long lastModifiedWhenCached;
        public long lastAccessed;
        public final WebLogicServerVersion version;

        public DetectCacheEntry(File file, WebLogicServerVersion version) {
            this.file = file;
            this.lastModifiedWhenCached = file.lastModified();
            this.version = version;
            this.lastAccessed = System.currentTimeMillis();
        }

        public boolean isOutOfDate() {
            return this.lastModifiedWhenCached != this.file.lastModified();
        }

        public File getLocation() {
            return this.file;
        }

        public WebLogicServerVersion getVersion() {
            return this.version;
        }

        public long getLastAccessedTime() {
            return this.lastAccessed;
        }

        public void resetLastAccessedTime() {
            this.lastAccessed = System.currentTimeMillis();
        }
    }
}

