/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.descriptors.IFastSwapSettings;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerWorkingCopy;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public final class WebLogicServerUtil {
    private static final String BIN_DIRECTORY = "bin";
    private static final String SET_DOMAIN_ENV_SCRIPT = "setDomainEnv.";
    private static final String LINUX_WL_HOME_SETTING = "WL_HOME=";
    private static final String WINDOWS_WL_HOME_SETTING = "set WL_HOME=";
    private static final String JSF_FACET_ID = "jst.jsf";
    private static Map<String, List<String>> _wlsQueryCache = new HashMap<String, List<String>>();
    public static final String WLS_POLICY_PACKAGE = "weblogic/wsee/policy/runtime/";
    private static final CharSequence RELIABILITY_TEXT = "Reliability";
    private static final CharSequence RELIABLE_MESSAGING_TEXT = "ReliableMessaging";
    private static final CharSequence MTOM_TEXT = "Mtom.xml";
    static final CharSequence WSSP_2007 = "Wssp1.2-2007";
    static final CharSequence WSSC = "Wssp1.2-2007-Wssc";

    public static boolean isWebLogicRuntime(IRuntime runtime) {
        IRuntimeType rt;
        IRuntimeType iRuntimeType = rt = runtime != null ? runtime.getRuntimeType() : null;
        return rt != null && (rt == IWeblogicServerRuntime.RUNTIME_TYPE_9_2 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_0 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_1 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_2 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_3 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_4 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_5 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_6 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_12_1_1 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_12_1_2);
    }

    public static boolean isWebLogicRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        return WlsRuntimeUtil.getWlsRuntimeComponent(runtime) != null;
    }

    public static Set<IRuntime> getWebLogicRuntimes() {
        Set<IRuntime> runtimes = null;
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (WebLogicServerUtil.isWebLogicRuntime(runtime)) {
                if (runtimes == null) {
                    runtimes = new HashSet<IRuntime>();
                }
                runtimes.add(runtime);
            }
            ++n2;
        }
        if (runtimes == null) {
            runtimes = Collections.emptySet();
        }
        return runtimes;
    }

    public static boolean isWebLogicServer(IServer server) {
        IRuntime runtime = server.getRuntime();
        return runtime != null && WebLogicServerUtil.isWebLogicRuntime(runtime);
    }

    public static Set<IServer> getWebLogicServers() {
        Set<IServer> servers = null;
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IRuntime runtime = server.getRuntime();
            if (runtime != null && WlsRuntimeUtil.isWlsRuntime(runtime)) {
                if (servers == null) {
                    servers = new HashSet<IServer>();
                }
                servers.add(server);
            }
            ++n2;
        }
        if (servers == null) {
            servers = Collections.emptySet();
        }
        return servers;
    }

    public static IServerWorkingCopy createWebLogicServer(IRuntime runtime, IPath domainHome, String serverName) throws CoreException {
        IServerType serverType = WebLogicServerUtil.getServerType(runtime.getRuntimeType());
        if (serverType == null) {
            throw new IllegalArgumentException();
        }
        IServerWorkingCopy serverWC = serverType.createServer(serverName, null, runtime, null);
        serverWC.setName(serverName);
        IWeblogicServer wlServerWC = (IWeblogicServer)serverWC.loadAdapter(IWeblogicServer.class, null);
        ((IWeblogicServerWorkingCopy)wlServerWC).setDomainPath(domainHome);
        return serverWC;
    }

    public static IServerWorkingCopy createWebLogicServer(IRuntime runtime, IPath domainHome) throws CoreException {
        String serverName = WebLogicServerUtil.generateServerName(runtime.getRuntimeType(), domainHome);
        return WebLogicServerUtil.createWebLogicServer(runtime, domainHome, serverName);
    }

    public static IServerType getServerType(IRuntimeType runtimeType) {
        assert (runtimeType != null) : "runtimeType parameter to getServerType must not be null";
        IServerType[] iServerTypeArray = ServerCore.getServerTypes();
        int n = iServerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServerType serverType = iServerTypeArray[n2];
            if (serverType.getRuntimeType() != null && serverType.getRuntimeType().equals(runtimeType)) {
                return serverType;
            }
            ++n2;
        }
        return null;
    }

    private static String generateServerName(IRuntimeType runtimeType, IPath domainHome) {
        String serverNamePrefix;
        String serverName = serverNamePrefix = String.valueOf(WebLogicServerUtil.getServerType(runtimeType).getName()) + " [" + domainHome.lastSegment() + "]";
        int i = 2;
        while (WebLogicServerUtil.isNameInUse(serverName)) {
            serverName = String.valueOf(serverNamePrefix) + " " + i;
            ++i;
        }
        return serverName;
    }

    private static boolean isNameInUse(String name) {
        if (name == null) {
            return true;
        }
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getName().equalsIgnoreCase(name)) {
                return true;
            }
            ++n2;
        }
        iRuntimeArray = ServerCore.getServers();
        n = iRuntimeArray.length;
        n2 = 0;
        while (n2 < n) {
            IRuntime server = iRuntimeArray[n2];
            if (server.getName().equalsIgnoreCase(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IPath getWeblogicHomeFromDomainEnvScript(IPath domainPath) throws FileNotFoundException, IOException {
        IPath scriptPath = domainPath.append(BIN_DIRECTORY).append(SET_DOMAIN_ENV_SCRIPT + CorePlugin.getScriptExtension());
        File script = scriptPath.toFile();
        FileInputStream fis = new FileInputStream(script);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));){
            String prefix = WINDOWS_WL_HOME_SETTING;
            if (!CorePlugin.IS_WINDOWS) {
                prefix = LINUX_WL_HOME_SETTING;
            }
            String cur = reader.readLine();
            while (cur != null) {
                if (cur.startsWith(prefix)) {
                    if (cur.length() <= prefix.length()) {
                        return null;
                    }
                    String runtimePath = cur.substring(prefix.length()).trim();
                    if (!CorePlugin.IS_WINDOWS && runtimePath.startsWith("\"") && runtimePath.endsWith("\"")) {
                        runtimePath = runtimePath.substring(1, runtimePath.length() - 1);
                    }
                    Path path = new Path(runtimePath);
                    return path;
                }
                cur = reader.readLine();
            }
        }
        return null;
    }

    public static boolean isTargetedToWeblogicRuntime(IProject project) {
        boolean ret = false;
        if (project != null) {
            try {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
                if (fproj != null && WlsRuntimeUtil.getWlsRuntimeComponent(fproj) != null) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return ret;
    }

    public static boolean isRequireFastSwapFix(IRuntime runtime) {
        IRuntimeType rt = runtime.getRuntimeType();
        return rt != null && (rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_1 || rt == IWeblogicServerRuntime.RUNTIME_TYPE_10_3_2);
    }

    public static boolean isFastSwapEnabled(IProject proj) {
        IFastSwapSettings fastSwap = null;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)proj)) {
            IWebLogicWebModuleDescriptor weblogicWebDescriptor = WebLogicDescriptorFactory.getWebDescriptor(proj);
            if (weblogicWebDescriptor != null) {
                fastSwap = weblogicWebDescriptor.getFastSwapSettings();
                if (((Boolean)fastSwap.isEnabled().content()).booleanValue()) {
                    weblogicWebDescriptor.dispose();
                    return true;
                }
                weblogicWebDescriptor.dispose();
            }
            if (WebLogicServerUtil.isFastSwapEnabledInReferencingEAR(proj)) {
                return true;
            }
        } else {
            IProject[] webProjects;
            IProject[] iProjectArray = webProjects = J2EEProjectUtilities.getReferencingWebProjects((IProject)proj);
            int n = webProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject webProj = iProjectArray[n2];
                if (WebLogicServerUtil.isFastSwapEnabled(webProj)) {
                    return true;
                }
                ++n2;
            }
            if (WebLogicServerUtil.isFastSwapEnabledInReferencingEAR(proj)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFastSwapEnabledInReferencingEAR(IProject proj) {
        IProject[] earProjects;
        IFastSwapSettings fastSwap = null;
        IProject[] iProjectArray = earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)proj);
        int n = earProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject earProj = iProjectArray[n2];
            IWebLogicAppDescriptor appDesc = WebLogicDescriptorFactory.getAppDescriptor(earProj);
            if (appDesc != null) {
                fastSwap = appDesc.getFastSwapSettings();
                if (((Boolean)fastSwap.isEnabled().content()).booleanValue()) {
                    appDesc.dispose();
                    return true;
                }
                appDesc.dispose();
            }
            ++n2;
        }
        return false;
    }

    public static String encrypt(IServer server, IJ2EEDeploymentHelper helper, File domainDir, String password) {
        if (!domainDir.exists()) {
            String msgJsmEncryption = CorePlugin.getString("remoteJmsEncryptionNotSupported", new Object[0]);
            WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
            weblogicServer.addPublishWarnings(1001, msgJsmEncryption);
        } else if (helper != null) {
            return helper.encrypt(domainDir, password);
        }
        return null;
    }

    public static boolean needWorkAroundForJSF20(IServer server) {
        boolean isSplitSource = server.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
        if (!isSplitSource) {
            return false;
        }
        IRuntime runtime = server.getRuntime();
        WebLogicServerVersion v = WebLogicServerVersion.detect(RuntimeBridgeUtil.bridge((IRuntime)runtime));
        if (v.compareTo(WebLogicServerVersion.VERSION_10_3_4) >= 0) {
            return false;
        }
        IModule[] modules = server.getModules();
        if (modules.length == 0) {
            return false;
        }
        int i = 0;
        while (i < modules.length) {
            IModule module = modules[i];
            if (FacetUtil.hasWebFacet(module)) {
                if (WebLogicServerUtil.hasJSF20Facet(module)) {
                    return true;
                }
            } else if (FacetUtil.hasEarFacet(module)) {
                IModule[] iModuleArray = server.getChildModules(new IModule[]{module}, (IProgressMonitor)new NullProgressMonitor());
                int n = iModuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule child = iModuleArray[n2];
                    if (FacetUtil.hasWebFacet(child) && WebLogicServerUtil.hasJSF20Facet(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasJSF20Facet(IModule module) {
        boolean ret = false;
        try {
            IProjectFacetVersion fv;
            String id;
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)module.getProject());
            if (facetProject == null) return ret;
            Iterator iterator = facetProject.getProjectFacets().iterator();
            do {
                if (iterator.hasNext()) continue;
                return ret;
            } while (!(id = (fv = (IProjectFacetVersion)iterator.next()).getProjectFacet().getId()).equals(JSF_FACET_ID) || !fv.getVersionString().equals("2.0"));
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void setSSLKeyStoreAndHostnameVerifier(String trustStorePath, final String hostname) {
        if (trustStorePath != null) {
            System.setProperty("weblogic.security.SSL.trustedCAKeyStore", trustStorePath);
            System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        }
        System.setProperty("weblogic.security.SSL.ignoreHostnameVerification", "true");
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String host, SSLSession sslSession) {
                if (host.equals(hostname)) {
                    return true;
                }
                try {
                    InetAddress wlsAddr = InetAddress.getByName(host);
                    InetAddress verifyAddr = InetAddress.getByName(hostname);
                    if (wlsAddr.equals(verifyAddr)) {
                        return true;
                    }
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
    }

    public static List<String> getWlsPolicies(IRuntime runtime, boolean forJaxWs) {
        block17: {
            String runtimeLoc = runtime.getLocation().toPortableString();
            String weblogicJarLocation = String.valueOf(runtimeLoc) + "/server/lib/weblogic.jar";
            List<String> policyList = _wlsQueryCache.get(weblogicJarLocation);
            if (policyList != null) {
                return policyList;
            }
            policyList = new ArrayList<String>();
            File jar = new File(weblogicJarLocation);
            if (jar.exists()) {
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(weblogicJarLocation);
                        Enumeration<JarEntry> e = jarFile.entries();
                        while (e.hasMoreElements()) {
                            JarEntry jarEntry = e.nextElement();
                            String name = jarEntry.getName();
                            if (!name.startsWith(WLS_POLICY_PACKAGE) || !name.endsWith(".xml") || forJaxWs && (name.contains(RELIABLE_MESSAGING_TEXT) || name.contains(RELIABILITY_TEXT) || name.contains(MTOM_TEXT) || !name.contains(WSSP_2007))) continue;
                            String policy = "policy:" + name.substring(name.lastIndexOf("/") + 1);
                            policyList.add(policy);
                        }
                        _wlsQueryCache.put(weblogicJarLocation, policyList);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException ioe2) {
                                ioe2.printStackTrace();
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        return Collections.emptyList();
    }
}

