/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Manifest;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.PropertyMap;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.common.util.resources.StaticStringResourceBundle;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerModule;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sapphire.Version;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.w3c.dom.Element;

public final class WebLogicServerInstall {
    public static final String LIB_LOCATION_WL_INSTALL_DIR = "WEBLOGIC_INSTALL_DIR";
    public static final String LIB_LOCATION_MODULES_DIR = "MODULES_DIR";
    public static final String LIB_LOCATION_ORACLE_COMMON_MODULES_DIR = "ORACLE_COMMON_MODULES_DIR";
    public static final Map<File, Map<String, WebLogicServerModule>> weblogicModuleCache = new HashMap<File, Map<String, WebLogicServerModule>>();
    private static final String SERVER_LIB_FOLDER = "server/lib";
    private static final String WEBLOGIC_JAR = "weblogic.jar";
    private static final String SYSTEM_CLASSPATH_CONTRIBUTIONS_JAR = "oepe-contributions.jar";
    private final File location;
    private final String patchProfile;
    private final WebLogicServerVersion version;
    private final File middlewareHomeLocation;
    private final File modulesLocation;
    private final File patchesLocation;
    private final SystemLibrariesLocation defaultSysLibsLocation;
    private final List<SystemLibrariesLocation> sysLibsLocationsList;
    private final Map<String, SystemLibrariesLocation> sysLibsLocationsMap;
    private Map<String, WebLogicServerModule> modulesMap;

    public WebLogicServerInstall(File location) {
        this(location, "default");
    }

    public WebLogicServerInstall(File location, String patchProfile) {
        this.location = location;
        this.patchProfile = patchProfile;
        this.version = WebLogicServerVersion.detect(location);
        if (this.version == null) {
            this.middlewareHomeLocation = null;
            this.modulesLocation = null;
            this.patchesLocation = null;
            this.defaultSysLibsLocation = null;
            this.sysLibsLocationsList = null;
            this.sysLibsLocationsMap = null;
            return;
        }
        File productPropertiesFile = this.version == WebLogicServerVersion.VERSION_9_2 ? new File(this.location, "common/lib/platform.properties") : new File(this.location, ".product.properties");
        String beaHomeStr = null;
        if (productPropertiesFile.exists()) {
            PropertyMap contents = new PropertyMap();
            try {
                contents.read(productPropertiesFile);
            }
            catch (IOException iOException) {}
            beaHomeStr = (String)contents.get((Object)"BEAHOME");
        }
        this.middlewareHomeLocation = beaHomeStr != null ? new File(beaHomeStr) : null;
        ArrayList<Object> locations = new ArrayList<Object>();
        this.defaultSysLibsLocation = new SystemLibrariesLocation(Resources.sysLibsLocationLabelWebLogicServerInstallDir, "", LIB_LOCATION_WL_INSTALL_DIR, location);
        locations.add(this.defaultSysLibsLocation);
        File modulesDir = null;
        if (this.version != WebLogicServerVersion.VERSION_9_2 && this.middlewareHomeLocation != null) {
            modulesDir = new File(this.middlewareHomeLocation, "modules");
            if (modulesDir.exists()) {
                SystemLibrariesLocation systemLibrariesLocation = new SystemLibrariesLocation(Resources.sysLibsLocationLabelModulesDir, "", LIB_LOCATION_MODULES_DIR, modulesDir);
                locations.add(systemLibrariesLocation);
            } else {
                modulesDir = this.version == WebLogicServerVersion.VERSION_12_1_2 ? new File(this.middlewareHomeLocation, "/wlserver/modules") : null;
            }
            File file = new File(this.middlewareHomeLocation, "/oracle_common/modules");
            if (file.exists()) {
                SystemLibrariesLocation commonModulesLocation = new SystemLibrariesLocation(Resources.sysLibsLocationLabelCommonModulesDir, "", LIB_LOCATION_ORACLE_COMMON_MODULES_DIR, file);
                locations.add(commonModulesLocation);
            } else {
                Object var7_9 = null;
            }
        }
        this.modulesLocation = modulesDir;
        this.sysLibsLocationsList = Collections.unmodifiableList(locations);
        this.sysLibsLocationsMap = new HashMap<String, SystemLibrariesLocation>();
        for (SystemLibrariesLocation systemLibrariesLocation : locations) {
            this.sysLibsLocationsMap.put(systemLibrariesLocation.getPathVariable(), systemLibrariesLocation);
        }
        Version version = new Version(this.version.getVersionString());
        if (version.matches("[9.2-9.3)")) {
            this.patchesLocation = new File(this.middlewareHomeLocation, "patch_weblogic92");
        } else if (version.matches("[10")) {
            StringBuilder buf = new StringBuilder();
            buf.append("patch_wls");
            buf.append(version.segment(0));
            buf.append(version.segment(1));
            if (version.segment(2) > 0L) {
                buf.append(version.segment(2));
            }
            this.patchesLocation = new File(this.middlewareHomeLocation, buf.toString());
        } else {
            this.patchesLocation = null;
        }
    }

    public static WebLogicServerInstall getWebLogicServerInstall(IProject project) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
        WebLogicServerInstall wlsInstall = null;
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        if (fproj != null && (runtime = fproj.getPrimaryRuntime()) != null) {
            wlsInstall = WebLogicServerInstall.getWebLogicServerInstall(runtime);
        }
        return wlsInstall;
    }

    public static WebLogicServerInstall getWebLogicServerInstall(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
        if (r != null) {
            return WebLogicServerInstall.getWebLogicServerInstall(r);
        }
        return null;
    }

    public static WebLogicServerInstall getWebLogicServerInstall(IRuntime runtime) {
        IPath location;
        IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (wsr != null && (location = runtime.getLocation()) != null) {
            WebLogicServerInstall install = new WebLogicServerInstall(location.toFile(), wsr.getPatchProfile());
            return install;
        }
        return null;
    }

    public boolean isValid() {
        return this.version != null;
    }

    public WebLogicServerVersion getVersion() {
        this.assertValidInstall();
        return this.version;
    }

    public File getLocation() {
        return this.location;
    }

    public File getMiddlewareHomeLocation() {
        return this.middlewareHomeLocation;
    }

    public File getModulesLocation() {
        this.assertValidInstall();
        return this.modulesLocation;
    }

    public File getPatchesLocation() {
        this.assertValidInstall();
        return this.patchesLocation;
    }

    public String getPatchProfile() {
        return this.patchProfile;
    }

    public List<String> getPatchProfiles() {
        File patchesLocation = this.getPatchesLocation();
        File patchProfilesLocation = new File(patchesLocation, "profiles");
        if (patchProfilesLocation.exists()) {
            ArrayList<String> profiles = new ArrayList<String>();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    File dir = pathname.getAbsoluteFile();
                    return dir.canRead() && dir.isDirectory();
                }
            };
            File[] fileArray = patchProfilesLocation.listFiles(filter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File possible = fileArray[n2];
                profiles.add(possible.getName());
                ++n2;
            }
            return profiles;
        }
        return Collections.emptyList();
    }

    public File getPatchProfileJarLocation() {
        if (this.patchProfile != null) {
            return this.getPatchProfileJarLocation(this.patchProfile);
        }
        return null;
    }

    public File getPatchProfileJarLocation(String profile) {
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        File location = this.getPatchesLocation();
        location = new File(location, "profiles");
        location = new File(location, profile);
        location = new File(location, "sys_manifest_classpath");
        return (location = new File(location, "weblogic_patch.jar")).canRead() && location.isFile() ? location : null;
    }

    public List<SystemLibrariesLocation> getSystemLibrariesLocations() {
        this.assertValidInstall();
        return this.sysLibsLocationsList;
    }

    public SystemLibrariesLocation getSystemLibrariesLocation(String pathVar) {
        this.assertValidInstall();
        return this.sysLibsLocationsMap.get(pathVar);
    }

    public SystemLibrariesLocation getDefaultSystemLibrariesLocation() {
        this.assertValidInstall();
        return this.defaultSysLibsLocation;
    }

    public Collection<WebLogicServerModule> getModules() {
        this.loadModulesRegistry();
        return this.modulesMap.values();
    }

    public WebLogicServerModule getModule(String id) {
        this.loadModulesRegistry();
        return this.modulesMap.get(id);
    }

    private File findModulesRegistryFile() {
        File featuresDirectory;
        File modulesRegistryFile = null;
        if (this.modulesLocation != null && this.modulesLocation.exists() && (featuresDirectory = new File(this.modulesLocation, "features")).exists()) {
            String expectedFileNameFragment = "weblogic.server.modules_" + this.version.getVersionString() + ".";
            TreeSet<File> matchingFiles = new TreeSet<File>();
            File[] fileArray = featuresDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    String fileName = file.getName();
                    String extension = FileUtil.getExtension((File)file).toLowerCase();
                    if (extension.equals("xml") && fileName.startsWith(expectedFileNameFragment)) {
                        matchingFiles.add(file);
                    }
                }
                ++n2;
            }
            if (matchingFiles.size() > 0) {
                modulesRegistryFile = (File)matchingFiles.last();
            }
        }
        return modulesRegistryFile;
    }

    private synchronized void loadModulesRegistry() {
        if (this.modulesMap == null) {
            this.modulesMap = new HashMap<String, WebLogicServerModule>();
            File modulesRegistryFile = this.findModulesRegistryFile();
            if (modulesRegistryFile != null) {
                File key = this.modulesLocation;
                if (weblogicModuleCache.get(key) != null) {
                    this.modulesMap = weblogicModuleCache.get(key);
                    return;
                }
                this.parseFeatureXmlFile(modulesRegistryFile);
                Element requires = DomUtil.element((Element)DomUtil.root((File)modulesRegistryFile), (String)"requires");
                if (requires != null) {
                    Element requiresNode = DomUtil.element((Element)requires, (String)"and") != null ? DomUtil.element((Element)requires, (String)"and") : requires;
                    for (Element externalFeatureRef : DomUtil.elements((Element)requiresNode, (String)"feature")) {
                        File externalFeatureRegFile;
                        String fileName = externalFeatureRef.getAttribute("id").trim();
                        if (fileName.length() <= 0 || (externalFeatureRegFile = this.findFeatureXml(modulesRegistryFile.getParentFile(), fileName)) == null) continue;
                        this.parseFeatureXmlFile(externalFeatureRegFile);
                    }
                }
                weblogicModuleCache.put(key, this.modulesMap);
            }
        }
    }

    private void parseFeatureXmlFile(File featureRegFile) {
        for (Element elModule : DomUtil.elements((Element)DomUtil.element((Element)DomUtil.root((File)featureRegFile), (String)"modules"), (String)"module")) {
            File moduleFile;
            WebLogicServerModule module;
            String fileName = elModule.getAttribute("file-name").trim();
            if (fileName.length() <= 0 || (module = this.parseModuleInfo(moduleFile = new File(this.modulesLocation, fileName))) == null) continue;
            this.modulesMap.put(module.getId(), module);
        }
    }

    private File findFeatureXml(File modulesLocation, String fileName) {
        File[] fileArray = modulesLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().indexOf(fileName) >= 0 && f.getName().endsWith(".xml")) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    private VersionInfo getVersionInfo(String fileName) {
        int idEndPos = -1;
        char[] data = fileName.toCharArray();
        int i = 0;
        while (i < data.length) {
            if ((data[i] == '_' || data[i] == '-') && i + 1 <= data.length - 1 && data[i + 1] >= '0' && data[i + 1] <= '9') {
                idEndPos = i;
                break;
            }
            ++i;
        }
        if (idEndPos > 0) {
            String id = fileName.substring(0, idEndPos);
            String s = fileName.substring(idEndPos + 1);
            char[] versoinChars = s.toCharArray();
            int n = 0;
            int i2 = 0;
            while (i2 < versoinChars.length) {
                if (versoinChars[i2] == '.') {
                    if (n >= 3) {
                        versoinChars[i2] = 45;
                    }
                    ++n;
                }
                ++i2;
            }
            VersionInfo ret = new VersionInfo(id, new String(versoinChars));
            return ret;
        }
        return null;
    }

    private WebLogicServerModule parseModuleInfo(File file) {
        String fileName = file.getName();
        VersionInfo verInfo = null;
        if (fileName.length() > 0) {
            int verEndPos = fileName.lastIndexOf(".jar");
            verInfo = this.getVersionInfo(fileName.substring(0, verEndPos));
            if (verInfo == null) {
                File parentFile = file.getParentFile();
                while (!parentFile.getName().equals("modules")) {
                    if (parentFile.getName().indexOf(46) >= 0) break;
                    parentFile = parentFile.getParentFile();
                }
                if ((verInfo = this.getVersionInfo(parentFile.getName())) != null) {
                    verInfo.id = String.valueOf(verInfo.id) + "." + fileName.substring(0, fileName.lastIndexOf(".jar"));
                } else {
                    return null;
                }
            }
            if (verInfo != null) {
                return new WebLogicServerModule(verInfo.getId(), file);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSystemClasspathContributionsProvisioned() {
        try {
            File cpJarFile;
            File serverLibFolder = new File(this.location, SERVER_LIB_FOLDER);
            File weblogicJarFile = new File(serverLibFolder, WEBLOGIC_JAR);
            Iterator iterator = ManifestUtil.readManifestClasspath((File)weblogicJarFile).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(cpJarFile = (File)iterator.next()).getName().equals(SYSTEM_CLASSPATH_CONTRIBUTIONS_JAR));
            return true;
        }
        catch (IOException e) {
            WlsCorePlugin.logException(e);
        }
        return false;
    }

    public List<File> getSystemClasspathContributions() {
        try {
            File serverLibFolder = new File(this.location, SERVER_LIB_FOLDER);
            File weblogicJarFile = new File(serverLibFolder, WEBLOGIC_JAR);
            File systemClasspathContributionsJarFile = null;
            for (File cpJarFile : ManifestUtil.readManifestClasspath((File)weblogicJarFile)) {
                if (!cpJarFile.getName().equals(SYSTEM_CLASSPATH_CONTRIBUTIONS_JAR)) continue;
                systemClasspathContributionsJarFile = cpJarFile;
                break;
            }
            if (systemClasspathContributionsJarFile != null && systemClasspathContributionsJarFile.exists()) {
                return Collections.unmodifiableList(ManifestUtil.readManifestClasspath((File)systemClasspathContributionsJarFile));
            }
        }
        catch (IOException e) {
            WlsCorePlugin.logException(e);
        }
        return Collections.emptyList();
    }

    public void setSystemClasspathContributions(List<File> contributions, IProgressMonitor monitor) throws IOException {
        monitor.beginTask(Resources.changingSystemClasspathContributionsMsg, 1000);
        try {
            try {
                File serverLibFolder = new File(this.location, SERVER_LIB_FOLDER);
                File weblogicJarFile = new File(serverLibFolder, WEBLOGIC_JAR);
                String path = weblogicJarFile.getCanonicalPath();
                File weblogicJarFileCopy = new File(String.valueOf(path) + ".copy");
                FileUtil.copy((File)weblogicJarFile, (File)weblogicJarFileCopy);
                if (!weblogicJarFile.delete()) {
                    weblogicJarFileCopy.delete();
                    throw new IOException(Resources.failedToUpdateWebLogicJar);
                }
                weblogicJarFileCopy.renameTo(weblogicJarFile);
                Manifest weblogicJarManifest = ManifestUtil.readRawManifest((File)weblogicJarFile);
                File systemClasspathContributionsJarFile = null;
                for (File cpJarFile : ManifestUtil.readManifestClasspath((Manifest)weblogicJarManifest, (File)serverLibFolder)) {
                    if (!cpJarFile.getName().equals(SYSTEM_CLASSPATH_CONTRIBUTIONS_JAR)) continue;
                    systemClasspathContributionsJarFile = cpJarFile;
                    break;
                }
                monitor.worked(200);
                if (systemClasspathContributionsJarFile == null) {
                    systemClasspathContributionsJarFile = new File(serverLibFolder, SYSTEM_CLASSPATH_CONTRIBUTIONS_JAR);
                    String weblogicJarManifestClasspath = ManifestUtil.readManifestEntry((Manifest)weblogicJarManifest, (String)"Class-Path");
                    weblogicJarManifestClasspath = "oepe-contributions.jar " + weblogicJarManifestClasspath;
                    weblogicJarManifest.getMainAttributes().putValue("Class-Path", weblogicJarManifestClasspath);
                    byte[] weblogicJarManifestContent = ManifestUtil.toByteArray((Manifest)weblogicJarManifest);
                    ZipUtil.update((File)weblogicJarFile, (String)"META-INF/MANIFEST.MF", (InputStream)new ByteArrayInputStream(weblogicJarManifestContent), (IProgressMonitor)new SubProgressMonitor(monitor, 600, 2));
                } else {
                    monitor.worked(600);
                }
                Manifest systemClasspathContributionsJarManifest = new Manifest();
                ManifestUtil.writeManifestClasspath((Manifest)systemClasspathContributionsJarManifest, (File)serverLibFolder, contributions);
                byte[] systemClasspathContributionsJarManifestContent = ManifestUtil.toByteArray((Manifest)systemClasspathContributionsJarManifest);
                File systemClasspathContributionsJarStagingFolder = new File(String.valueOf(systemClasspathContributionsJarFile.getAbsolutePath()) + ".temp");
                File systemClasspathContributionsJarStagingFile = new File(systemClasspathContributionsJarStagingFolder, "META-INF/MANIFEST.MF");
                FileUtil.delete((File)systemClasspathContributionsJarStagingFolder);
                FileUtil.writeFile((File)systemClasspathContributionsJarStagingFile, (byte[])systemClasspathContributionsJarManifestContent);
                ZipUtil.zip((File)systemClasspathContributionsJarStagingFolder, (File)systemClasspathContributionsJarFile);
                FileUtil.delete((File)systemClasspathContributionsJarStagingFolder);
                monitor.worked(200);
            }
            catch (IOException e) {
                WlsCorePlugin.logException(e);
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void addSystemClasspathContributions(List<File> contributions, IProgressMonitor monitor) throws IOException {
        monitor.beginTask(Resources.changingSystemClasspathContributionsMsg, 1000);
        try {
            ArrayList<File> entries = new ArrayList<File>(this.getSystemClasspathContributions());
            entries.removeAll(contributions);
            entries.addAll(0, contributions);
            monitor.worked(200);
            this.setSystemClasspathContributions(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 800, 2));
        }
        finally {
            monitor.done();
        }
    }

    public String toString() {
        return "WLS Install: " + this.location.getAbsolutePath();
    }

    private void assertValidInstall() {
        if (!this.isValid()) {
            String msg = Resources.bind((String)Resources.invalidInstallMsg, (Object[])new Object[]{this.location.getAbsolutePath()});
            throw new RuntimeException(msg);
        }
    }

    private static final class Resources
    extends StaticStringResourceBundle {
        public static String sysLibsLocationLabelWebLogicServerInstallDir;
        public static String sysLibsLocationLabelModulesDir;
        public static String sysLibsLocationLabelCommonModulesDir;
        public static String invalidInstallMsg;
        public static String changingSystemClasspathContributionsMsg;
        public static String failedToUpdateWebLogicJar;

        static {
            Resources.initializeMessages((String)WebLogicServerInstall.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    static class VersionInfo {
        String id = null;
        String version = null;

        VersionInfo(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

