/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.wlst.IWLSTRunner;
import org.eclipse.wst.server.core.IRuntime;

public class MBeanUtil {
    private static String[] MBEAN_HIRARCHY_ROOT = new String[]{"domainConfig", "serverConfig", "domainRuntime", "serverRuntime", "edit", "jndi", "custom"};

    private MBeanUtil() {
    }

    public static String[] getMBeanHirarchyRoot() {
        return MBEAN_HIRARCHY_ROOT;
    }

    public static synchronized List<String> getChildMBeanNames(WeblogicServer weblogic, String mbeanPath) {
        try {
            IRuntime rt;
            IWLSTRunner runner;
            if (weblogic != null && (runner = WLSTRunnerUtil.findWLSTRunner(rt = weblogic.getServer().getRuntime())) != null) {
                String path = rt.getLocation().toPortableString();
                WLSTRunnerUtil.setWLSTSystemProperties(path);
                List<String> list = runner.getChildMBeanNames(weblogic, mbeanPath);
                return list;
            }
        }
        finally {
            WLSTRunnerUtil.resetWLSTSystemProperties();
        }
        return Collections.emptyList();
    }

    public static synchronized Map<String, String> getMBeanAttributes(WeblogicServer weblogic, String mbeanPath) {
        try {
            IRuntime rt;
            IWLSTRunner runner;
            if (weblogic != null && (runner = WLSTRunnerUtil.findWLSTRunner(rt = weblogic.getServer().getRuntime())) != null && mbeanPath != null) {
                String path = rt.getLocation().toPortableString();
                WLSTRunnerUtil.setWLSTSystemProperties(path);
                Map<String, String> map = runner.getMBeanAttributes(weblogic, mbeanPath);
                return map;
            }
        }
        catch (Exception exception) {
        }
        finally {
            WLSTRunnerUtil.resetWLSTSystemProperties();
        }
        return Collections.emptyMap();
    }

    public static synchronized Map<String, String> getMBeanDescription(WeblogicServer weblogic, String mbeanPath) {
        try {
            if (weblogic == null || mbeanPath == null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            IRuntime rt = weblogic.getServer().getRuntime();
            IWLSTRunner runner = WLSTRunnerUtil.findWLSTRunner(rt);
            if (runner != null && mbeanPath != null) {
                String path = rt.getLocation().toPortableString();
                WLSTRunnerUtil.setWLSTSystemProperties(path);
                Map<String, String> map = runner.getMBeanDescription(weblogic, mbeanPath);
                return map;
            }
        }
        finally {
            WLSTRunnerUtil.resetWLSTSystemProperties();
        }
        return new HashMap<String, String>();
    }
}

