/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.weblogic.IDomainLocator;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class DomainLocatorsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "domainLocators";
    private static final String EL_DOMAIN_LOCATOR = "domain-locator";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String ATTR_CLASS = "class";
    private static List<DomainLocatorDef> extensions = null;

    public static List<File> locateDomains(IRuntime runtime, IProgressMonitor monitor) {
        DomainLocatorsExtensionPoint.initialize();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        SubProgressMonitor firstStageMonitor = new SubProgressMonitor(monitor, 30);
        firstStageMonitor.beginTask("", extensions.size());
        ArrayList<IDomainLocator> locators = new ArrayList<IDomainLocator>();
        for (DomainLocatorDef def : extensions) {
            IDomainLocator locator;
            if (def.isEnabledFor(runtime) && (locator = (IDomainLocator)PluginUtil.instantiate((String)def.pluginId, (String)def.className, IDomainLocator.class)) != null) {
                locators.add(locator);
            }
            firstStageMonitor.worked(1);
            if (!firstStageMonitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        firstStageMonitor.done();
        ArrayList<File> domains = new ArrayList<File>();
        HashSet<File> domainsSet = new HashSet<File>();
        SubProgressMonitor secondStageMonitor = new SubProgressMonitor(monitor, 70);
        secondStageMonitor.beginTask("", locators.size() * 10);
        for (IDomainLocator locator : locators) {
            block12: {
                SubProgressMonitor locatorMonitor = new SubProgressMonitor((IProgressMonitor)secondStageMonitor, 10);
                try {
                    try {
                        for (File f : locator.locateDomains(runtime, (IProgressMonitor)locatorMonitor)) {
                            try {
                                f = f.getCanonicalFile();
                                if (domainsSet.contains(f)) continue;
                                domains.add(f);
                                domainsSet.add(f);
                            }
                            catch (IOException e) {
                                WlsCorePlugin.logException(e);
                            }
                        }
                    }
                    catch (Exception e) {
                        WlsCorePlugin.logException(e);
                        locatorMonitor.done();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    locatorMonitor.done();
                    throw throwable;
                }
                locatorMonitor.done();
            }
            if (!secondStageMonitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        secondStageMonitor.done();
        monitor.done();
        return domains;
    }

    private static synchronized void initialize() {
        if (extensions == null) {
            extensions = DomainLocatorsExtensionPoint.readExtensions();
        }
    }

    private static List<DomainLocatorDef> readExtensions() {
        ArrayList<DomainLocatorDef> locators = new ArrayList<DomainLocatorDef>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_DOMAIN_LOCATOR)) continue;
            try {
                locators.add(DomainLocatorsExtensionPoint.readExtension(element));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        return locators;
    }

    private static DomainLocatorDef readExtension(IConfigurationElement element) throws PluginUtil.InvalidExtensionException {
        String pluginId = element.getContributor().getName();
        String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
        Expression enablementCondition = null;
        IConfigurationElement elEnablement = PluginUtil.findOptionalElement((IConfigurationElement)element, (String)EL_ENABLEMENT);
        try {
            enablementCondition = ExpressionConverter.getDefault().perform(elEnablement);
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            throw new PluginUtil.InvalidExtensionException();
        }
        return new DomainLocatorDef(pluginId, className, enablementCondition);
    }

    private static final class DomainLocatorDef {
        public final String pluginId;
        public final String className;
        public final Expression enablementCondition;

        public DomainLocatorDef(String pluginId, String className, Expression enablementCondition) {
            this.pluginId = pluginId;
            this.className = className;
            this.enablementCondition = enablementCondition;
        }

        public boolean isEnabledFor(IRuntime runtime) {
            if (this.enablementCondition == null) {
                return true;
            }
            EvaluationContext evalContext = new EvaluationContext(null, (Object)runtime);
            evalContext.setAllowPluginActivation(true);
            try {
                EvaluationResult evalResult = this.enablementCondition.evaluate((IEvaluationContext)evalContext);
                return evalResult == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
                return false;
            }
        }
    }
}

