/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.WebMethod;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebMethodExcludeRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebMethod.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof MethodDeclaration)) continue;
            Collection annotationMirrors = declaration.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                AnnotationValue excludeAttribute = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)"exclude");
                if (excludeAttribute == null) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
                TypeDeclaration typeDeclaration = methodDeclaration.getDeclaringType();
                if (typeDeclaration instanceof InterfaceDeclaration && ((Boolean)excludeAttribute.getValue()).booleanValue()) {
                    this.printFixableError(excludeAttribute.getPosition(), JAXWSCoreMessages.WEBMETHOD_EXCLUDE_NOT_ALLOWED_ON_SEI);
                }
                if (!(typeDeclaration instanceof ClassDeclaration) || annotationMirror.getElementValues().size() <= 1 || !Boolean.valueOf(excludeAttribute.getValue().toString()).booleanValue()) continue;
                this.printFixableError(excludeAttribute.getPosition(), JAXWSCoreMessages.WEBMETHOD_EXCLUDE_SPECIFIED_NO_OTHER_ATTRIBUTES_ALLOWED);
            }
        }
    }
}

