/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.rebase;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.GitDateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseInteractivePlan
implements IndexDiffChangedListener,
RefsChangedListener {
    private ArrayList<RebaseInteractivePlanChangeListener> planChangeListeners = new ArrayList();
    private List<PlanElement> todoList;
    private List<PlanElement> doneList;
    private JoinedList<List<PlanElement>, PlanElement> planList;
    private final Repository repository;
    private ListenerHandle refsChangedListener;
    private static final Map<File, RebaseInteractivePlan> planRegistry = new HashMap<File, RebaseInteractivePlan>();
    private static final String REBASE_TODO = "rebase-merge/git-rebase-todo";
    private static final String REBASE_DONE = "rebase-merge/done";

    public static RebaseInteractivePlan getPlan(Repository repo) {
        RebaseInteractivePlan plan = planRegistry.get(repo.getDirectory());
        if (plan == null) {
            plan = new RebaseInteractivePlan(repo);
            planRegistry.put(repo.getDirectory(), plan);
        }
        return plan;
    }

    private RebaseInteractivePlan(Repository repo) {
        this.repository = repo;
        this.reparsePlan();
        this.registerIndexDiffChangeListener();
        this.registerRefChangedListener();
    }

    private void registerIndexDiffChangeListener() {
        IndexDiffCacheEntry entry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(this.repository);
        entry.addIndexDiffChangedListener(this);
    }

    private void unregisterIndexDiffChangeListener() {
        IndexDiffCacheEntry entry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(this.repository);
        entry.removeIndexDiffChangedListener(this);
    }

    private void registerRefChangedListener() {
        this.refsChangedListener = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
    }

    @Override
    public void indexDiffChanged(Repository repo, IndexDiffData indexDiffData) {
        if (this.repository == repo) {
            this.reparsePlan();
        }
    }

    public void onRefsChanged(RefsChangedEvent event) {
        Repository repo = event.getRepository();
        if (this.repository == repo) {
            this.reparsePlan();
        }
    }

    public void dispose() {
        this.reparsePlan();
        this.notifyPlanWasUpdatedFromRepository();
        planRegistry.remove(this.repository.getDirectory());
        this.planList.clear();
        this.planChangeListeners.clear();
        this.unregisterIndexDiffChangeListener();
        this.refsChangedListener.remove();
    }

    public List<PlanElement> getList() {
        return this.planList;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean addRebaseInteractivePlanChangeListener(RebaseInteractivePlanChangeListener listener) {
        if (this.planChangeListeners.contains(listener)) {
            return false;
        }
        return this.planChangeListeners.add(listener);
    }

    public boolean removeRebaseInteractivePlanChangeListener(RebaseInteractivePlanChangeListener listener) {
        return this.planChangeListeners.remove(listener);
    }

    private void notifyPlanElementsOrderChange(PlanElement element, int oldIndex, int newIndex) {
        this.persist();
        for (RebaseInteractivePlanChangeListener listener : this.planChangeListeners) {
            listener.planElementsOrderChanged(this, element, oldIndex, newIndex);
        }
    }

    private void notifyPlanElementActionChange(PlanElement element, ElementAction oldType, ElementAction newType) {
        this.persist();
        for (RebaseInteractivePlanChangeListener listener : this.planChangeListeners) {
            listener.planElementTypeChanged(this, element, oldType, newType);
        }
    }

    private void notifyPlanWasUpdatedFromRepository() {
        for (RebaseInteractivePlanChangeListener listener : this.planChangeListeners) {
            listener.planWasUpdatedFromRepository(this);
        }
    }

    private void reparsePlan() {
        RevWalk walk = new RevWalk(this.repository.newObjectReader());
        try {
            this.doneList = this.parseDone(walk);
            this.todoList = this.parseTodo(walk);
        }
        finally {
            walk.release();
        }
        this.planList = JoinedList.wrap(this.doneList, this.todoList);
        this.notifyPlanWasUpdatedFromRepository();
    }

    private List<PlanElement> parseTodo(RevWalk walk) {
        LinkedList<RebaseTodoLine> rebaseTodoLines;
        try {
            rebaseTodoLines = this.repository.readRebaseTodo(REBASE_TODO, true);
        }
        catch (IOException iOException) {
            rebaseTodoLines = new LinkedList<RebaseTodoLine>();
        }
        List<PlanElement> todoElements = this.createElementList(rebaseTodoLines, walk);
        return todoElements;
    }

    private List<PlanElement> parseDone(RevWalk walk) {
        LinkedList<RebaseTodoLine> rebaseDoneLines;
        try {
            rebaseDoneLines = this.repository.readRebaseTodo(REBASE_DONE, false);
        }
        catch (IOException iOException) {
            rebaseDoneLines = new LinkedList<RebaseTodoLine>();
        }
        List<PlanElement> doneElements = this.createElementList(rebaseDoneLines, walk);
        return doneElements;
    }

    private List<PlanElement> createElementList(List<RebaseTodoLine> rebaseTodoLines, RevWalk walk) {
        ArrayList<PlanElement> planElements = new ArrayList<PlanElement>(rebaseTodoLines.size());
        for (RebaseTodoLine todoLine : rebaseTodoLines) {
            PlanElement element = this.createElement(todoLine, walk);
            planElements.add(element);
        }
        return planElements;
    }

    private PlanElement createElement(RebaseTodoLine todoLine, RevWalk walk) {
        PersonIdent author = null;
        PersonIdent committer = null;
        RevCommit commit = this.loadCommit(todoLine.getCommit(), walk);
        if (commit != null) {
            author = commit.getAuthorIdent();
            committer = commit.getCommitterIdent();
        }
        PlanElement element = new PlanElement(todoLine, author, committer);
        return element;
    }

    private RevCommit loadCommit(AbbreviatedObjectId abbreviatedObjectId, RevWalk walk) {
        if (abbreviatedObjectId != null) {
            try {
                Collection resolved = walk.getObjectReader().resolve(abbreviatedObjectId);
                if (resolved.size() == 1) {
                    RevCommit commit = walk.parseCommit((AnyObjectId)resolved.iterator().next());
                    return commit;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public boolean hasRebaseBeenStartedYet() {
        return this.isRebasingInteractive() && this.doneList.size() > 0;
    }

    public boolean isRebasingInteractive() {
        return this.repository.getRepositoryState() == RepositoryState.REBASING_INTERACTIVE;
    }

    public void moveTodoEntryDown(PlanElement element) {
        new MoveHelper(this.todoList, this).moveTodoEntryDown(element);
    }

    public void moveTodoEntryUp(PlanElement element) {
        new MoveHelper(this.todoList, this).moveTodoEntryUp(element);
    }

    public void moveTodoEntry(PlanElement sourceElement, PlanElement targetElement, boolean before) {
        new MoveHelper(this.todoList, this).moveTodoEntry(sourceElement, targetElement, before);
    }

    public boolean persist() {
        if (!this.isRebasingInteractive()) {
            return false;
        }
        LinkedList<RebaseTodoLine> todoLines = new LinkedList<RebaseTodoLine>();
        for (PlanElement element : this.planList.getSecondList()) {
            todoLines.add(element.getRebaseTodoLine());
        }
        try {
            this.repository.writeRebaseTodoFile(REBASE_TODO, todoLines, false);
        }
        catch (IOException e) {
            Activator.logError(CoreText.RebaseInteractivePlan_WriteRebaseTodoFailed, e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public void parse() throws IOException {
        if (!this.isRebasingInteractive()) {
            return;
        }
        this.reparsePlan();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementAction {
        SKIP,
        EDIT,
        PICK,
        SQUASH,
        FIXUP,
        REWORD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        DONE,
        TODO,
        DONE_CURRENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinedList<L extends List<T>, T>
    extends AbstractList<T> {
        private final L firstList;
        private final L secondList;

        public L getFirstList() {
            return this.firstList;
        }

        public L getSecondList() {
            return this.secondList;
        }

        private JoinedList(L first, L second) {
            Assert.isNotNull(first);
            Assert.isNotNull(second);
            this.firstList = first;
            this.secondList = second;
        }

        public static <L extends List<T>, T> JoinedList<L, T> wrap(L first, L second) {
            return new JoinedList<L, T>(first, second);
        }

        private RelativeIndex<T> mapAbsolutIndex(int index) {
            if (index < this.firstList.size()) {
                return new RelativeIndex(index, this.firstList);
            }
            return new RelativeIndex(index - this.firstList.size(), this.secondList);
        }

        @Override
        public void add(int index, T element) {
            RelativeIndex<T> rel = this.mapAbsolutIndex(index);
            rel.getList().add(rel.getRelativeIndex(), element);
            ++this.modCount;
        }

        @Override
        public T get(int index) {
            RelativeIndex<T> rel = this.mapAbsolutIndex(index);
            return rel.getList().get(rel.getRelativeIndex());
        }

        @Override
        public T remove(int index) {
            RelativeIndex<T> rel = this.mapAbsolutIndex(index);
            ++this.modCount;
            return rel.getList().remove(rel.getRelativeIndex());
        }

        @Override
        public T set(int index, T element) {
            RelativeIndex<T> rel = this.mapAbsolutIndex(index);
            return rel.getList().set(rel.getRelativeIndex(), element);
        }

        @Override
        public int size() {
            return this.firstList.size() + this.secondList.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RelativeIndex<T> {
            private final int relativeIndex;
            private final List<T> list;

            public final int getRelativeIndex() {
                return this.relativeIndex;
            }

            public final List<T> getList() {
                return this.list;
            }

            RelativeIndex(int relativeIndex, List<T> list) {
                this.relativeIndex = relativeIndex;
                this.list = list;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveHelper {
        private List<PlanElement> todoList;
        private RebaseInteractivePlan plan;

        public MoveHelper(List<PlanElement> todoList, RebaseInteractivePlan plan) {
            this.todoList = todoList;
            this.plan = plan;
        }

        private static boolean moveUp(int index, List<?> list) {
            if (index <= 0 || index > list.size()) {
                return false;
            }
            Collections.swap(list, index, index - 1);
            return true;
        }

        private static boolean moveDown(int index, List<?> list) {
            if (index < 0 || index >= list.size() - 1) {
                return false;
            }
            Collections.swap(list, index, index + 1);
            return true;
        }

        public void moveTodoEntryDown(PlanElement element) {
            int oldIndex;
            List<PlanElement> list = this.todoList;
            int initialIndex = list.indexOf(element);
            do {
                oldIndex = list.indexOf(element);
                MoveHelper.moveDown(oldIndex, list);
            } while (list.get(oldIndex).isComment());
            int newIndex = list.indexOf(element);
            if (initialIndex != newIndex) {
                this.plan.notifyPlanElementsOrderChange(element, initialIndex, newIndex);
            }
        }

        public void moveTodoEntryUp(PlanElement element) {
            int oldIndex;
            List<PlanElement> list = this.todoList;
            int initialIndex = list.indexOf(element);
            do {
                oldIndex = list.indexOf(element);
                MoveHelper.moveUp(oldIndex, list);
            } while (list.get(oldIndex).isComment());
            int newIndex = list.indexOf(element);
            if (initialIndex != newIndex) {
                this.plan.notifyPlanElementsOrderChange(element, initialIndex, newIndex);
            }
        }

        private static void move(int sourceIndex, int targetIndex, List<PlanElement> list) {
            if (sourceIndex == targetIndex) {
                return;
            }
            if (sourceIndex < targetIndex) {
                Collections.rotate(list.subList(sourceIndex, targetIndex + 1), -1);
            } else {
                Collections.rotate(list.subList(targetIndex, sourceIndex + 1), 1);
            }
        }

        public void moveTodoEntry(PlanElement sourceElement, PlanElement targetElement, boolean before) {
            if (sourceElement == targetElement) {
                return;
            }
            Assert.isNotNull((Object)sourceElement);
            Assert.isNotNull((Object)targetElement);
            if (ElementType.TODO != sourceElement.getElementType()) {
                throw new IllegalArgumentException();
            }
            List<PlanElement> list = this.todoList;
            int initialSourceIndex = list.indexOf(sourceElement);
            int targetIndex = list.indexOf(targetElement);
            if (targetIndex == -1 || initialSourceIndex == -1) {
                return;
            }
            if (targetIndex == initialSourceIndex) {
                return;
            }
            if (targetIndex > initialSourceIndex && before) {
                --targetIndex;
            }
            if (targetIndex < initialSourceIndex && !before) {
                ++targetIndex;
            }
            MoveHelper.move(initialSourceIndex, targetIndex, list);
            int newIndex = list.indexOf(sourceElement);
            if (initialSourceIndex != newIndex) {
                this.plan.notifyPlanElementsOrderChange(sourceElement, initialSourceIndex, newIndex);
            }
        }
    }

    public class PlanElement {
        private final RebaseTodoLine line;
        private final PersonIdent author;
        private final PersonIdent committer;

        private PlanElement(RebaseTodoLine line, PersonIdent author, PersonIdent committer) {
            if (line == null) {
                throw new IllegalArgumentException();
            }
            this.line = line;
            this.author = author;
            this.committer = committer;
        }

        public ElementType getElementType() {
            if (RebaseInteractivePlan.this.todoList.indexOf(this) != -1) {
                return ElementType.TODO;
            }
            int indexInDone = RebaseInteractivePlan.this.doneList.indexOf(this);
            if (indexInDone != -1) {
                if (indexInDone == RebaseInteractivePlan.this.doneList.size() - 1 && RebaseInteractivePlan.this.isRebasingInteractive()) {
                    return ElementType.DONE_CURRENT;
                }
                return ElementType.DONE;
            }
            throw new IllegalStateException();
        }

        private RebaseTodoLine getRebaseTodoLine() {
            return this.line;
        }

        public AbbreviatedObjectId getCommit() {
            return this.line.getCommit();
        }

        public String getShortMessage() {
            return this.line.getShortMessage();
        }

        public String getAuthor() {
            if (this.author == null) {
                return "";
            }
            return this.author.getName();
        }

        public String getAuthoredDate(GitDateFormatter dateFormatter) {
            if (this.author == null) {
                return "";
            }
            return dateFormatter.formatDate(this.author);
        }

        public String getCommitter() {
            if (this.committer == null) {
                return "";
            }
            return this.committer.getName();
        }

        public String getCommittedDate(GitDateFormatter dateFormatter) {
            if (this.committer == null) {
                return "";
            }
            return dateFormatter.formatDate(this.committer);
        }

        public void setPlanElementAction(ElementAction newAction) {
            if (this.isComment()) {
                if (newAction == null) {
                    return;
                }
                throw new IllegalArgumentException();
            }
            ElementAction oldAction = this.getPlanElementAction();
            if (oldAction == newAction) {
                return;
            }
            try {
                switch (newAction) {
                    case SKIP: {
                        this.line.setAction(RebaseTodoLine.Action.COMMENT);
                        break;
                    }
                    case EDIT: {
                        this.line.setAction(RebaseTodoLine.Action.EDIT);
                        break;
                    }
                    case FIXUP: {
                        this.line.setAction(RebaseTodoLine.Action.FIXUP);
                        break;
                    }
                    case PICK: {
                        this.line.setAction(RebaseTodoLine.Action.PICK);
                        break;
                    }
                    case REWORD: {
                        this.line.setAction(RebaseTodoLine.Action.REWORD);
                        break;
                    }
                    case SQUASH: {
                        this.line.setAction(RebaseTodoLine.Action.SQUASH);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (IllegalTodoFileModification e) {
                throw new IllegalArgumentException(e);
            }
            RebaseInteractivePlan.this.notifyPlanElementActionChange(this, oldAction, newAction);
        }

        public ElementAction getPlanElementAction() {
            if (this.isSkip()) {
                return ElementAction.SKIP;
            }
            if (this.isComment()) {
                return null;
            }
            switch (this.line.getAction()) {
                case EDIT: {
                    return ElementAction.EDIT;
                }
                case FIXUP: {
                    return ElementAction.FIXUP;
                }
                case PICK: {
                    return ElementAction.PICK;
                }
                case SQUASH: {
                    return ElementAction.SQUASH;
                }
                case REWORD: {
                    return ElementAction.REWORD;
                }
            }
            throw new IllegalStateException();
        }

        public boolean isComment() {
            return RebaseTodoLine.Action.COMMENT.equals((Object)this.line.getAction()) && this.line.getCommit() == null;
        }

        public boolean isSkip() {
            return RebaseTodoLine.Action.COMMENT.equals((Object)this.line.getAction()) && this.line.getCommit() != null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlanElement other = (PlanElement)obj;
            if (other.line.getCommit() == null) {
                return this.line.getCommit() == null;
            }
            if (!other.line.getCommit().equals((Object)this.line.getCommit())) {
                return false;
            }
            return other.getPlanElementAction().equals((Object)this.getPlanElementAction());
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static interface RebaseInteractivePlanChangeListener {
        public void planElementsOrderChanged(RebaseInteractivePlan var1, PlanElement var2, int var3, int var4);

        public void planElementTypeChanged(RebaseInteractivePlan var1, PlanElement var2, ElementAction var3, ElementAction var4);

        public void planWasUpdatedFromRepository(RebaseInteractivePlan var1);
    }
}

