/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected Object fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private volatile int fComputeCount;
    private IProgressMonitor fComputeProgressMonitor;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;
    private boolean fLinking = true;

    protected abstract void doSetInput(Object var1);

    protected abstract Object computeInput(Object var1);

    abstract void computeAndSetInput(IWorkbenchPart var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected Object getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
    }

    private void inititalizeColors() {
        Color bgColor;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        registry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = registry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.fBackgroundColorRGB = bgColor.getRGB();
        } else {
            this.fBackgroundColor = bgColor = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(bgColor);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBackgroundColorKey().equals(event.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    protected void setLinkingEnabled(boolean enabled) {
        this.fLinking = enabled;
    }

    protected boolean isLinkingEnabled() {
        return this.fLinking;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();
}

