/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal.wizards;

import java.io.File;
import java.util.Set;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.internal.operation.ICreateWLSTFileOp;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.workspace.ui.CreateWorkspaceFileWizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.templates.PyDocumentTemplateContext;
import org.python.pydev.editor.codecompletion.templates.PyTemplateCompletionProcessor;
import org.python.pydev.editor.templates.PyContextType;
import org.python.pydev.editor.templates.TemplateHelper;
import org.python.pydev.plugin.nature.PythonNature;

public class CreateWLSTScriptWizard
extends CreateWorkspaceFileWizard<ICreateWLSTFileOp> {
    public CreateWLSTScriptWizard() {
        super(ICreateWLSTFileOp.TYPE, DefinitionLoader.sdef(CreateWLSTScriptWizard.class).wizard());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource res;
        IProject project;
        PythonNature nature;
        super.init(workbench, selection);
        Object obj = selection.getFirstElement();
        if (obj instanceof IResource && (nature = PythonNature.getPythonNature((IProject)(project = (res = (IResource)obj).getProject()))) != null) {
            IPythonPathNature pathNature = PythonNature.getPythonPathNature((IProject)project);
            try {
                Set pySourcePath = pathNature.getProjectSourcePathSet(true);
                ICreateWLSTFileOp op = (ICreateWLSTFileOp)this.element();
                for (String wlstSrc : pySourcePath) {
                    if (wlstSrc.endsWith("/classes")) continue;
                    op.setFolder(wlstSrc);
                    return;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected void performPostFinish() {
        super.performPostFinish();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("oracle.eclipse.tools.weblogic.scripting.ui.views.WLSTHelpView", null, 2);
        }
        catch (PartInitException partInitException) {}
        IEditorPart openEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.applyTemplate(openEditor);
        IWorkbenchPage page = openEditor.getEditorSite().getWorkbenchWindow().getActivePage();
        page.saveEditor(openEditor, false);
        page.activate((IWorkbenchPart)openEditor);
    }

    private void applyTemplate(IEditorPart openEditor) {
        if (!(openEditor instanceof PyEdit)) {
            return;
        }
        ICreateWLSTFileOp op = (ICreateWLSTFileOp)this.element();
        String templateName = (String)op.getTemplateName().content();
        if (templateName == null || templateName.trim().length() == 0) {
            return;
        }
        TemplateStore templateStore = TemplateHelper.getTemplateStore();
        if (templateStore != null) {
            TemplatePersistenceData[] templateData = templateStore.getTemplateData(false);
            TemplatePersistenceData selectedTemplate = null;
            TemplatePersistenceData[] templatePersistenceDataArray = templateData;
            int n = templateData.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                TemplatePersistenceData data = templatePersistenceDataArray[n2];
                String contextId = data.getTemplate().getContextTypeId();
                if ("org.python.pydev.editor.templates.python.modules".equals(contextId) && (name = data.getTemplate().getName()).equals(templateName.trim())) {
                    selectedTemplate = data;
                    break;
                }
                ++n2;
            }
            if (selectedTemplate == null) {
                return;
            }
            Template template = selectedTemplate.getTemplate();
            PyEdit pyEdit = (PyEdit)openEditor;
            Region region = new Region(0, 0);
            PyDocumentTemplateContext context = PyTemplateCompletionProcessor.createContext((TemplateContextType)new PyContextType(), (ITextViewer)pyEdit.getPySourceViewer(), (IRegion)region);
            FileEditorInput fi = (FileEditorInput)openEditor.getEditorInput();
            IProject project = fi.getFile().getProject();
            File wlsPath = WlsRuntimeUtil.getWlsRuntimePath((IProject)project);
            if (wlsPath != null) {
                String wlsHome = wlsPath.getAbsolutePath().replace('\\', '/');
                context.setVariable("WL_HOME", wlsHome);
                context.setVariable("BEA_HOME", wlsPath.getParentFile().getAbsolutePath().replace('\\', '/'));
                WebLogicServerVersion wlsVer = WebLogicServerVersion.detect((File)wlsPath);
                if (wlsVer.compareTo((Enum)WebLogicServerVersion.VERSION_12_1_2) >= 0) {
                    context.setVariable("WLS_JAR_PATH", "/common/templates/wls/wls.jar");
                } else {
                    context.setVariable("WLS_JAR_PATH", "/common/templates/domains/wls.jar");
                }
            }
            TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
            templateProposal.apply((ITextViewer)pyEdit.getPySourceViewer(), '\n', 0, 0);
        }
    }
}

