/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.ui.internal.WLSTConsoleViewer;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.wst.server.core.IRuntime;

public class OpenWlstConsoleAction
extends Action {
    private IRuntime fRuntime;

    public OpenWlstConsoleAction(String label, ImageDescriptor image, IRuntime rt) {
        this.setText(label);
        if (image != null) {
            this.setImageDescriptor(image);
        }
        this.fRuntime = rt;
    }

    public void run() {
        try {
            String wlsHomeDir = this.fRuntime.getLocation().toPortableString();
            File mwHome = WlsRuntimeUtil.getMwHome((File)this.fRuntime.getLocation().toFile());
            String wlstScript = String.valueOf(wlsHomeDir) + "/common/bin/wlst." + CorePlugin.getScriptExtension();
            File wlstCmd = new File(wlstScript);
            File workingDirectory = new File(String.valueOf(wlsHomeDir) + "/common/bin/");
            String[] cmdLine = new String[]{wlstScript};
            ArrayList<File> fmwWlstCmds = new ArrayList<File>();
            File[] fileArray = mwHome.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File wlst;
                File f = fileArray[n2];
                if (f.isDirectory() && (wlst = new File(String.valueOf(f.getAbsolutePath()) + "/common/bin/wlst." + CorePlugin.getScriptExtension())).exists()) {
                    fmwWlstCmds.add(wlst.getAbsoluteFile());
                }
                ++n2;
            }
            int n3 = 0;
            if (fmwWlstCmds.size() == 1) {
                wlstCmd = (File)fmwWlstCmds.get(n3);
                workingDirectory = wlstCmd.getParentFile();
            } else if (fmwWlstCmds.size() > 1) {
                String s = this.promptFmwWlstLocations(fmwWlstCmds);
                if (s == null) {
                    return;
                }
                wlstCmd = new File(s);
                workingDirectory = wlstCmd.getParentFile();
            }
            String consoleTitle = " WLST Console: " + wlstCmd.getAbsolutePath();
            wlstScript = String.valueOf(workingDirectory.getAbsolutePath().replace('\\', '/')) + "/wlst." + CorePlugin.getScriptExtension();
            cmdLine = new String[]{wlstScript};
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine).directory(workingDirectory);
            processBuilder.directory(workingDirectory);
            Map<String, String> env = processBuilder.environment();
            WeblogicServerRuntime rt = (WeblogicServerRuntime)this.fRuntime.loadAdapter(WeblogicServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (rt.getDefaultJavaVmLocation() == null) {
                try {
                    String mwHomePath = mwHome.getCanonicalPath();
                    env.put("MW_HOME", new File(mwHomePath).getCanonicalPath().replace('\\', '/'));
                    env.put("JAVA_HOME", rt.getJavaVmLocation().toPortableString());
                }
                catch (IOException iOException) {}
            }
            String demoTrustPath = "%WL_HOME%/server/lib/DemoTrust.jks";
            String keyStoreProp = "-Dweblogic.security.SSL.trustedCAKeyStore=" + demoTrustPath + " -Dweblogic.security.SSL.ignoreHostnameVerification=true";
            env.put("CONFIG_JVM_ARGS", keyStoreProp);
            Process process = processBuilder.start();
            Launch launch = new Launch(null, "run", null);
            launch.setAttribute("org.eclipse.debug.core.capture_output", "true");
            RuntimeProcess p = new RuntimeProcess((ILaunch)launch, process, consoleTitle, new HashMap());
            ProcessConsole console = new ProcessConsole((IProcess)p, (IConsoleColorProvider)new ConsoleColorProvider()){

                public IPageBookViewPage createPage(IConsoleView view) {
                    return new IOConsolePage((TextConsole)this, view){

                        protected TextConsoleViewer createViewer(Composite parent) {
                            return new WLSTConsoleViewer(parent, (TextConsole)this.getConsole());
                        }
                    };
                }
            };
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            console.activate();
        }
        catch (Exception e) {
            ConsolePlugin.log((Throwable)e);
        }
    }

    private String promptFmwWlstLocations(List<File> fmwWlstCmds) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider());
        Object[] list = new String[fmwWlstCmds.size()];
        int n = 0;
        for (File f : fmwWlstCmds) {
            list[n] = f.getAbsolutePath();
            ++n;
        }
        dialog.setElements(list);
        dialog.setTitle("Select WLST command to launch");
        if (dialog.open() != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        return result[0].toString();
    }

    public void runWithEvent(Event event) {
        this.run();
    }
}

