/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.debug.ui.TableEditor;
import org.python.pydev.editorinput.PySourceLocatorPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.utils.ComboFieldEditor;

public class SourceLocatorPrefsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[][] ENTRIES_AND_VALUES = new String[][]{{"Ask for local file.", Integer.toString(0)}, {"Ask for local file/Get from server (read only).", Integer.toString(1)}, {"Get from server (read only).", Integer.toString(2)}};

    public SourceLocatorPrefsPage() {
        super("Source locator", 1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new ComboFieldEditor("ON_SOURCE_NOT_FOUND", "Action when source is not directly found:", ENTRIES_AND_VALUES, p));
        this.addField((FieldEditor)new IntegerFieldEditor("FILE_CONTENTS_TIMEOUT", "Timeout to get file contents (millis):", p));
        this.addField(new TableEditor("SOURCE_LOCATION_PATHS", "Translation paths to use:", p){

            @Override
            protected String createTable(List<String[]> items) {
                return PySourceLocatorPrefs.wordsAsString(items);
            }

            @Override
            protected String[] getNewInputObject() {
                InputDialog d = new InputDialog(this.getShell(), "New entry", "Add the entry in the format path_to_replace,new_path or path,DONTASK.", "", new IInputValidator(){

                    public String isValid(String newText) {
                        String[] splitted = StringUtils.splitAndRemoveEmptyTrimmed((String)newText, (char)',').toArray(new String[0]);
                        if (splitted.length != 2) {
                            return "Input must have 2 paths separated by a comma.";
                        }
                        return PySourceLocatorPrefs.isValid((String[])splitted);
                    }
                });
                int retCode = d.open();
                if (retCode == 0) {
                    return StringUtils.splitAndRemoveEmptyTrimmed((String)d.getValue(), (char)',').toArray(new String[0]);
                }
                return null;
            }

            @Override
            protected List<String[]> parseString(String stringList) {
                return PySourceLocatorPrefs.stringAsWords((String)stringList);
            }

            @Override
            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                Table table = this.getTableControl(parent);
                GridData layoutData = (GridData)table.getLayoutData();
                layoutData.heightHint = 300;
            }
        });
    }

    protected void initializeDefaultPreferences(Preferences prefs) {
    }
}

