/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.debug.ui.actions.PyExceptionListProvider;
import org.python.pydev.shared_core.string.StringMatcher;

public class PyConfigureExceptionDialog
extends SelectionDialog {
    protected DefaultFilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    protected boolean updateInThread = true;
    private Text filterPatternField;
    private Text addNewExceptionField;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private String filterPattern;
    private Object inputElement;
    private FilterJob filterJob;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private Button uncaughtExceptionCheck;
    private Button caughtExceptionCheck;
    private boolean handleCaughtExceptions;
    private boolean handleUncaughtExceptions;
    protected static String SELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_selectLabel;
    protected static String DESELECT_ALL_TITLE = WorkbenchMessages.SelectionDialog_deselectLabel;
    private List<Object> selectedElements;

    public PyConfigureExceptionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell);
        this.setTitle(WorkbenchMessages.ListSelection_title);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(WorkbenchMessages.ListSelection_message);
        }
    }

    protected Label createMessageArea(Composite composite) {
        Label filterLabel = new Label(composite, 0);
        filterLabel.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        filterLabel.setText("Enter a filter (* = any number of characters, ? = any single character)\nor an empty string for no filtering:");
        this.filterPatternField = new Text(composite, 2048);
        this.filterPatternField.setLayoutData((Object)new GridData(4, 2, true, false));
        return filterLabel;
    }

    protected void createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        this.createSelectAll(buttonComposite);
        this.createDeselectAll(buttonComposite);
    }

    private void createSelectAll(Composite buttonComposite) {
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyConfigureExceptionDialog.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
    }

    private void createDeselectAll(Composite buttonComposite) {
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] currentItems;
                PyConfigureExceptionDialog.this.listViewer.setAllChecked(false);
                TableItem[] tableItemArray = currentItems = PyConfigureExceptionDialog.this.listViewer.getTable().getItems();
                int n = currentItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    PyConfigureExceptionDialog.this.removeFromSelectedElements(tableItem.getText());
                    ++n2;
                }
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.createSelectionButtons(composite);
        this.initContent();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        this.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (PyConfigureExceptionDialog.this.getCheckBoxTableViewer().getChecked(element)) {
                    PyConfigureExceptionDialog.this.addToSelectedElements(element);
                }
                return PyConfigureExceptionDialog.this.matchExceptionToShowInList(element);
            }
        });
        this.getCheckBoxTableViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    PyConfigureExceptionDialog.this.addToSelectedElements(event.getElement());
                } else {
                    PyConfigureExceptionDialog.this.removeFromSelectedElements(event.getElement());
                }
            }
        });
        this.createCustomExceptionUI(composite);
        this.createCaughtUncaughtCheck(composite);
        return composite;
    }

    private void createCustomExceptionUI(Composite composite) {
        this.addNewExceptionField = new Text(composite, 2048);
        this.addNewExceptionField.setLayoutData((Object)new GridData(4, 1, true, false));
        Button buttonAdd = new Button(composite, 8);
        buttonAdd.setLayoutData((Object)new GridData(3, 3, true, false));
        buttonAdd.setText("Add Exception");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyConfigureExceptionDialog.this.addCustomException();
            }
        };
        buttonAdd.addSelectionListener((SelectionListener)listener);
    }

    private void addCustomException() {
        String customException = this.addNewExceptionField.getText();
        Object[] currentElements = this.contentProvider.getElements(this.inputElement);
        ArrayList<Object> currentElementsList = new ArrayList<Object>();
        int i = 0;
        while (i < currentElements.length) {
            Object element = currentElements[i];
            currentElementsList.add(element);
            ++i;
        }
        if (customException == "") {
            return;
        }
        if (!currentElementsList.contains(customException)) {
            this.getViewer().add((Object)customException);
            this.addNewExceptionField.setText("");
            ((PyExceptionListProvider)this.contentProvider).addUserConfiguredException(customException);
        } else {
            Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), "Duplicate: This exception already exists");
            DebugUIPlugin.errorDialog((Shell)this.getShell(), (String)DebugUIPlugin.removeAccelerators((String)"Add Custom User Exception"), (String)"Error", (IStatus)status);
        }
    }

    private void createCaughtUncaughtCheck(Composite composite) {
        PyExceptionBreakPointManager instance = PyExceptionBreakPointManager.getInstance();
        String breakOnCaught = instance.getBreakOnCaughtExceptions();
        String breakOnUncaught = instance.getBreakOnUncaughtExceptions();
        this.uncaughtExceptionCheck = new Button(composite, 32);
        this.uncaughtExceptionCheck.setText("Suspend on uncaught exceptions");
        if (breakOnUncaught.length() > 0) {
            this.uncaughtExceptionCheck.setSelection(Boolean.parseBoolean(breakOnUncaught));
        } else {
            this.uncaughtExceptionCheck.setSelection(false);
        }
        this.caughtExceptionCheck = new Button(composite, 32);
        this.caughtExceptionCheck.setText("Suspend on caught exceptions *");
        if (breakOnCaught.length() > 0) {
            this.caughtExceptionCheck.setSelection(Boolean.parseBoolean(breakOnCaught));
        } else {
            this.caughtExceptionCheck.setSelection(false);
        }
        Label label = new Label(composite, 0);
        label.setText("* Will make debugging ~ 2x slower");
    }

    protected void doFilterUpdate(IProgressMonitor monitor) {
        this.setFilter(this.filterPatternField.getText(), monitor, true);
    }

    protected void setFilter(String text, IProgressMonitor monitor, boolean updateFilterMatcher) {
        if (monitor.isCanceled()) {
            return;
        }
        if (updateFilterMatcher) {
            if (this.fFilterMatcher.lastPattern.equals(text)) {
                return;
            }
            this.fFilterMatcher.setFilter(text);
            if (monitor.isCanceled()) {
                return;
            }
        }
        this.getViewer().refresh();
        this.setSelectedElementChecked();
    }

    protected boolean matchExceptionToShowInList(Object element) {
        return this.fFilterMatcher.match(element);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            if (this.selectedElements != null) {
                for (Object selectedElement : this.selectedElements) {
                    if (list.contains(selectedElement)) continue;
                    list.add(selectedElement);
                }
            }
            this.setResult(list);
        }
        this.handleCaughtExceptions = this.caughtExceptionCheck.getSelection();
        this.handleUncaughtExceptions = this.uncaughtExceptionCheck.getSelection();
        super.okPressed();
    }

    public boolean getResultHandleUncaughtExceptions() {
        return this.handleUncaughtExceptions;
    }

    public boolean getResultHandleCaughtExceptions() {
        return this.handleCaughtExceptions;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    protected CheckboxTableViewer getCheckBoxTableViewer() {
        return this.getViewer();
    }

    private void initContent() {
        this.listViewer.setInput(this.inputElement);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (PyConfigureExceptionDialog.this.updateInThread) {
                    if (PyConfigureExceptionDialog.this.filterJob != null) {
                        PyConfigureExceptionDialog.this.filterJob.cancel();
                    }
                    PyConfigureExceptionDialog.this.filterJob = new FilterJob();
                    PyConfigureExceptionDialog.this.filterJob.start();
                } else {
                    PyConfigureExceptionDialog.this.doFilterUpdate((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        this.filterPatternField.setText(this.filterPattern != null ? this.filterPattern : "");
        this.filterPatternField.addListener(24, listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    private void setSelectedElementChecked() {
        if (this.selectedElements != null) {
            for (Object element : this.selectedElements) {
                this.getViewer().setChecked(element, true);
            }
        }
    }

    private void addToSelectedElements(Object element) {
        if (this.selectedElements == null) {
            this.selectedElements = new ArrayList<Object>();
        }
        if (!this.selectedElements.contains(element)) {
            this.selectedElements.add(element);
        }
    }

    private void removeFromSelectedElements(Object element) {
        if (this.selectedElements != null && this.selectedElements.contains(element)) {
            this.selectedElements.remove(element);
        }
    }

    protected class DefaultFilterMatcher {
        public StringMatcher fMatcher;
        public String lastPattern;

        public DefaultFilterMatcher() {
            this.setFilter("");
        }

        public void setFilter(String pattern) {
            this.setFilter(pattern, true, false);
        }

        private void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
            this.lastPattern = pattern;
        }

        public boolean match(Object element) {
            boolean match = this.fMatcher.match(PyConfigureExceptionDialog.this.labelProvider.getText(element));
            return match;
        }
    }

    class FilterJob
    extends Thread {
        IProgressMonitor monitor = new NullProgressMonitor();

        public FilterJob() {
            this.setPriority(1);
            this.setName("PyConfigureExceptionDialog: FilterJob");
        }

        public void run() {
            try {
                FilterJob.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.monitor.isCanceled()) {
                Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!FilterJob.this.monitor.isCanceled() && PyConfigureExceptionDialog.this.filterPatternField != null && !PyConfigureExceptionDialog.this.filterPatternField.isDisposed()) {
                            PyConfigureExceptionDialog.this.doFilterUpdate(FilterJob.this.monitor);
                        }
                    }
                });
            }
        }

        public void cancel() {
            this.monitor.setCanceled(true);
        }
    }
}

