/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;

public class EvaluateConsoleExpressionCommand
extends AbstractDebuggerCommand {
    private boolean isError = false;
    private String locator;
    private int responseCode;
    private String payload;

    public EvaluateConsoleExpressionCommand(AbstractDebugTarget debugger, String locator, ICommandResponseListener responseListener) {
        super(debugger);
        this.locator = locator;
        this.responseListener = responseListener;
    }

    public String getOutgoing() {
        int cmd = 126;
        return EvaluateConsoleExpressionCommand.makeCommand(cmd, this.sequence, this.locator);
    }

    public boolean needResponse() {
        return true;
    }

    public void processOKResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        if (this.responseCode == 126) {
            this.payload = payload;
        } else {
            this.isError = true;
            PydevDebugPlugin.log(4, "Unexpected response to GetTaskletCallStackCommand", null);
        }
    }

    public void processErrorResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        this.payload = payload;
        this.isError = true;
    }

    public String getResponse() throws CoreException {
        if (this.isError) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, this.payload, null));
        }
        return this.payload;
    }
}

