/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.doc.online;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.doc.OracleDocsPlugin;
import oracle.eclipse.tools.common.doc.online.OracleOnlineResource;
import oracle.eclipse.tools.common.util.PluginUtil;
import org.eclipse.core.runtime.IConfigurationElement;

public final class OracleOnlineResources {
    private static final String EXTENSION_POINT_ID = "onlineResources";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_URL = "url";
    private static Map<String, OracleOnlineResource> resourcesById;
    private static Map<OracleOnlineResource.Type, Set<OracleOnlineResource>> resourcesByType;

    public static OracleOnlineResource getOnlineResource(String id) {
        OracleOnlineResources.readExtensions();
        return resourcesById.get(id);
    }

    public static Set<OracleOnlineResource> getOnlineResources(OracleOnlineResource.Type type) {
        Set<Object> result;
        OracleOnlineResources.readExtensions();
        if (type != null) {
            result = resourcesByType.get((Object)type);
        } else {
            result = new HashSet();
            for (Set<OracleOnlineResource> resourcesForType : resourcesByType.values()) {
                result.addAll(resourcesForType);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static synchronized void readExtensions() {
        if (resourcesById == null) {
            resourcesById = new HashMap<String, OracleOnlineResource>();
            resourcesByType = new HashMap<OracleOnlineResource.Type, Set<OracleOnlineResource>>();
            HashMap<String, OracleOnlineResource.Type> elNameToType = new HashMap<String, OracleOnlineResource.Type>();
            OracleOnlineResource.Type[] typeArray = OracleOnlineResource.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OracleOnlineResource.Type type = typeArray[n2];
                resourcesByType.put(type, new HashSet());
                String elName = type.name().toLowerCase().replace('_', '-');
                elNameToType.put(elName, type);
                ++n2;
            }
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.doc", (String)EXTENSION_POINT_ID))) {
                OracleOnlineResource.Type type = (OracleOnlineResource.Type)((Object)elNameToType.get(element.getName()));
                if (type == null) continue;
                try {
                    String id = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_ID);
                    String name = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_NAME);
                    String urlString = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_URL);
                    URL url = new URL(urlString);
                    OracleOnlineResource resource = new OracleOnlineResource(id, type, name, url);
                    resourcesById.put(id, resource);
                    resourcesByType.get((Object)type).add(resource);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {
                }
                catch (MalformedURLException e) {
                    OracleDocsPlugin.log(e);
                }
            }
        }
    }
}

