/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase;

import java.io.Console;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.CommonConstants;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.exception.InvalidArgException;
import oracle.cloudlogic.javaservice.common.clibase.exception.MissingMandatoryArgException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.executor.ConfirmableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.executor.ManagableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.provider.CliExecutorProvider;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements CommonConstants {
    public static final String PROPERTY_FILE_RESOLVE = "PROPERTY_FILE_RESOLVE";
    private String commandName;
    private final Set<String> aliases = new HashSet<String>();
    private String description;
    private CliExecutorProvider<? extends CliExecutor> cliProvider = null;
    protected CliExecutor executor = null;
    private OrderedMap<String, CommandLineArg> args = new OrderedMap();
    private List<String> extraArgs = new ArrayList<String>();
    private CommandLineArg.OptionType extraArgsType;

    public boolean toPrintHelp() {
        return this.getArgs().get("help") != null && "true".equals(this.getArgs().get("help").getOptionValue());
    }

    public boolean toEnableDebug() {
        return this.getArgs().get("debug") != null && "true".equals(this.getArgs().get("debug").getOptionValue());
    }

    public void addCommandAlias(String alias) {
        this.aliases.add(alias);
    }

    public Set<String> getCommandAliases() {
        return this.aliases;
    }

    public void enableDebug() {
        this.setValue("debug", "true", new CommandLineArg.BooleanOptionType());
    }

    public void addArg(CommandLineArg arg) {
        this.args.put(arg.getOptionName(), arg);
    }

    public void setValue(String param, String value) {
        this.setValue(param, value, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
    }

    public void setValue(String param, String value, CommandLineArg.OptionType type) {
        CommandLineArg arg;
        if (this.args == null) {
            this.args = new OrderedMap();
        }
        if ((arg = this.args.get(param)) == null) {
            arg = new CommandLineArg(param, true, type, false, "");
        }
        arg.setOptionValue(value);
        this.addArg(arg);
    }

    public void addArgs(List<CommandLineArg> args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.size(); ++i) {
            this.addArg(args.get(i));
        }
    }

    public void setCommandName(String commandName) {
        String alias;
        this.commandName = commandName;
        if (commandName != null && !commandName.equals(alias = commandName.replaceAll("\\-", ""))) {
            this.addCommandAlias(alias);
        }
    }

    public String toCommandlineArgs() {
        return this.toCommandlineArgs(true, false);
    }

    public String toCommandlineArgs(boolean includeCMD, boolean printPwd) {
        StringBuffer buffer = new StringBuffer(includeCMD ? this.commandName : "");
        if (this.args != null) {
            for (CommandLineArg arg : this.args.values()) {
                if (arg.isHidden()) continue;
                boolean addArg = false;
                if (arg.getOptionValue() == null) {
                    addArg = arg.isMandatory();
                } else {
                    boolean bl = addArg = !arg.getOptionValue().equals(arg.getOptionDefaltValue());
                }
                if (!addArg) continue;
                buffer.append(" -" + arg.getOptionName());
                if (arg.getOptionValue() != null) {
                    if (arg.isPassword()) {
                        if (printPwd) {
                            buffer.append(" \"" + arg.getOptionValue() + "\"");
                            continue;
                        }
                        buffer.append(" " + arg.getOptionValue().replaceAll(".", "*"));
                        continue;
                    }
                    buffer.append(" \"" + arg.getOptionValue() + "\"");
                    continue;
                }
                buffer.append(" \"\"");
            }
        }
        if (this.getExtraArgs() != null) {
            buffer.append(" " + CloudUtil.getSeparatedListOfString(this.getExtraArgs(), "", "", false, " "));
        }
        return buffer.toString();
    }

    @XmlTransient
    public OrderedMap<String, CommandLineArg> getArgs() {
        return this.args;
    }

    @XmlElement(name="command-name")
    public String getCommandName() {
        return this.commandName;
    }

    @XmlElement(name="argument")
    public List<CommandLineArg> getArgument() {
        return new ArrayList<CommandLineArg>(this.args.values());
    }

    public CommandLineArg findWithShortCut(String sc) {
        if (this.args == null || this.args.getList() == null) {
            return null;
        }
        for (NameValuePair<String, CommandLineArg> arg : this.args.getList()) {
            if (arg.getValue().getShortCut() == null || !arg.getValue().getShortCut().equals(sc)) continue;
            return arg.getValue();
        }
        return null;
    }

    public String getDefaultProperty(String command, String arg, Properties defaultProps) {
        String val = defaultProps.getProperty(command + "." + arg);
        if (val != null) {
            return val;
        }
        return defaultProps.getProperty(arg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String[] cArgs, MainBase main) throws Exception {
        if (cArgs == null || cArgs.length == 0) {
            throw new CliException("No args found");
        }
        this.setCommandName(cArgs[0].trim());
        ArrayList<String> unrecognized = new ArrayList<String>();
        if (cArgs.length > 1) {
            boolean optionExcepted = true;
            CommandLineArg arg = null;
            for (int i = 1; i < cArgs.length; ++i) {
                if (optionExcepted) {
                    if (!cArgs[i].startsWith("-")) {
                        if (this.extraArgs == null) throw new InvalidArgException(NLSUtil.localizeMessage("COMMAND_OPTION_NOT_STARTINGWITH_HYPHEN", cArgs[i]));
                        this.extraArgs.add(cArgs[i]);
                        optionExcepted = false;
                    } else {
                        String option = cArgs[i].substring(1, cArgs[i].length());
                        arg = this.getArgs().get(option);
                        if (arg == null) {
                            arg = this.findWithShortCut(option);
                        }
                        if (arg == null) {
                            unrecognized.add(cArgs[i]);
                            if (i + 1 < cArgs.length && !cArgs[i + 1].startsWith("-")) {
                                ++i;
                            }
                            optionExcepted = false;
                        } else if (!arg.isValueRequired()) {
                            if (i + 1 < cArgs.length) {
                                if (cArgs[i + 1].startsWith("-")) {
                                    arg.setOptionValue("true");
                                    optionExcepted = false;
                                } else if (!cArgs[i + 1].equals("true") && !cArgs[i + 1].equals("false")) {
                                    throw new InvalidArgException(NLSUtil.localizeMessage("OPTION_VALUE_INVALID", new Object[]{arg.getOptionName(), cArgs[i + 1]}));
                                }
                            } else {
                                arg.setOptionValue("true");
                                optionExcepted = false;
                            }
                        }
                    }
                } else {
                    arg.setOptionValue(cArgs[i]);
                }
                optionExcepted = !optionExcepted;
            }
            if (!optionExcepted) {
                throw new CliException(NLSUtil.localizeMessage("NLS_OPTION_VALUE_REQUIRED_WHEN_OPTION_SPECIFIED", arg.getOptionName()));
            }
        }
        if (this.toPrintHelp()) return;
        for (String un : unrecognized) {
            Logger.getDEFAULT().printlnWarningI18n("COMMAND_OPTION_INVALID", new Object[]{un, "help", this.getCommandName()});
        }
        Properties defaultProps = null;
        if (!"false".equals(System.getProperty(PROPERTY_FILE_RESOLVE))) {
            defaultProps = main.getDefaultProperties(this);
        }
        if (defaultProps == null) {
            defaultProps = new Properties();
        }
        ArrayList<CommandLineArg> pwds = new ArrayList<CommandLineArg>();
        for (CommandLineArg arg : this.getArgs().values()) {
            if (!(arg.getOptionValue() != null || arg.getOptionType() != null && CommandLineArg.PasswordType.class.isAssignableFrom(arg.getOptionType().getClass()))) {
                arg.setOptionValue(this.getDefaultProperty(this.getCommandName(), arg.getOptionName(), defaultProps));
            }
            if (arg.getOptionValue() == null) {
                arg.setOptionValue(arg.getOptionDefaltValue());
            }
            if (!arg.isMandatory() || arg.getOptionValue() != null) continue;
            if (arg.getReplacementOptionNames() != null && arg.getReplacementOptionNames().size() != 0) {
                String val = null;
                for (String name : arg.getReplacementOptionNames()) {
                    val = this.getArgValue(name);
                    if (val == null) continue;
                }
                if (val != null) continue;
                if (arg.isPassword()) {
                    pwds.add(arg);
                    continue;
                }
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_SUGGEST_HELP", "help");
                throw new MissingMandatoryArgException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", arg.getOptionName()) + " " + NLSUtil.localizeMessage("OPTION_ALTERNATIVES", CloudUtil.getCommaSeparatedListOfString(arg.getReplacementOptionNames())));
            }
            if (arg.isPassword()) {
                pwds.add(arg);
                continue;
            }
            Logger.getDEFAULT().printlnTipI18n("NLS_TIP_SUGGEST_HELP", "help");
            throw new MissingMandatoryArgException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", arg.getOptionName()));
        }
        for (CommandLineArg pwd : pwds) {
            if (pwd.prompt()) continue;
            Logger.getDEFAULT().printlnTipI18n("NLS_TIP_SUGGEST_HELP", "help");
            throw new MissingMandatoryArgException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", pwd.getOptionName()));
        }
    }

    public void verifyArgs() throws CliException {
        for (CommandLineArg arg : this.getArgs().values()) {
            if ("".equals(arg.getOptionValue()) && !arg.isNullStringAllowed()) {
                throw new InvalidArgException(NLSUtil.localizeMessage("NLS_ERR_ZERO_LENGTH_STR_NOT_ALLOWED", arg.getOptionName()));
            }
            if (arg.getOptionValue() == null) {
                arg.setOptionValue(arg.getOptionDefaltValue());
            }
            if (!arg.isMandatory() || arg.getOptionValue() != null) continue;
            if (arg.getReplacementOptionNames() != null && arg.getReplacementOptionNames().size() != 0) {
                String name;
                String val = null;
                Iterator<String> i$ = arg.getReplacementOptionNames().iterator();
                while (i$.hasNext() && (val = this.getArgValue(name = i$.next())) == null) {
                }
                if (val != null) continue;
                if (!this.toPrintHelp()) {
                    Logger.getDEFAULT().printlnTipI18n("NLS_TIP_SUGGEST_HELP", "help");
                }
                throw new MissingMandatoryArgException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", arg.getOptionName()) + " " + NLSUtil.localizeMessage("OPTION_ALTERNATIVES", CloudUtil.getCommaSeparatedListOfString(arg.getReplacementOptionNames())));
            }
            if (!this.toPrintHelp()) {
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_SUGGEST_HELP", "help");
            }
            throw new MissingMandatoryArgException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", arg.getOptionName()));
        }
    }

    public void perform() throws Exception {
        this.perform(false);
    }

    public void perform(boolean onUI) throws Exception {
        this.executor = this.cliProvider.create();
        if (onUI && ManagableExecutor.class.isAssignableFrom(this.executor.getClass())) {
            ((ManagableExecutor)this.executor).prepareToBeManaged();
        }
        this.executor.setCommandLine(this);
        this.executor.validate();
        if (ConfirmableExecutor.class.isAssignableFrom(this.executor.getClass())) {
            ConfirmableExecutor exec = (ConfirmableExecutor)((Object)this.executor);
            String force = exec.getForceArgumentName();
            if (force == null) {
                force = "force";
            }
            if (!this.getValueAsBoolean(force)) {
                String message = exec.getConfirmMessage();
                if (message == null) {
                    message = "[" + this.getDescription() + "]\nAre you sure you want to perform this action?";
                }
                if (!CommandLine.readConfirmation(message = message + "(yes/no):")) {
                    return;
                }
            }
        }
        this.executor.execute();
    }

    public static boolean readConfirmation(String argDesc) {
        Console cons = null;
        cons = System.console();
        if (cons != null) {
            Logger.getDEFAULT().flush();
            Logger.getDEFAULT().print(argDesc);
            Logger.getDEFAULT().flush();
            String yes = cons.readLine();
            if (yes != null) {
                return "yes".equalsIgnoreCase(yes.trim());
            }
        }
        return false;
    }

    public CliExecutor getExecutor() {
        return this.executor;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void emitHelp(MainBase main, boolean emitcommand, String defCommand) {
        this.emitHelp(main, Logger.getDEFAULT().getActual(), false, emitcommand, defCommand);
    }

    public void printUnderline(PrintWriter pr, int length) {
        for (int i = 0; i < length; ++i) {
            pr.print(Grid.HORIZONTAL);
        }
    }

    public void updateShortCut() {
        if (this.args == null || this.args.getList() == null) {
            return;
        }
        ArrayList<String> dups = new ArrayList<String>();
        for (NameValuePair<String, CommandLineArg> arg : this.args.getList()) {
            if (arg.getValue().getShortCut() == null || arg.getValue().getShortCut().trim().equals("")) {
                arg.getValue().setShortCut(arg.getValue().findShortCutToSuggest(this));
            }
            if (arg.getValue().getShortCut() == null) continue;
            if (dups.contains(arg.getValue().getShortCut())) {
                throw new RuntimeException("Duplicate shortcuts on the code:" + arg.getValue().getShortCut());
            }
            dups.add(arg.getValue().getShortCut());
        }
    }

    public void emitHelp(MainBase main, PrintWriter pr, boolean html, boolean emitCommand, String defaultCommand) {
        if (html) {
            pr.println("<a name=\"" + this.getCommandName() + "\"><h3>");
            pr.println("<a href=\"#top\">Top</a><h3>");
        }
        int alignLength = CloudUtil.getKeyMaxLength(this.getArgs());
        if (emitCommand) {
            pr.println("Command:");
            if (!html) {
                this.printUnderline(pr, "Command:".length());
                pr.println();
            }
            if (html) {
                pr.println("</h3></a>");
            }
            if (alignLength < this.getCommandName().length()) {
                alignLength = this.getCommandName().length();
            }
            if (html) {
                pr.println("<pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
            }
            String desc = this.getDescription();
            if (html) {
                desc = desc.replaceAll("\\<", "&lt;");
            }
            pr.println(CloudUtil.convertToHelpText(CloudUtil.padChar(alignLength, ' ', this.getCommandName().trim(), alignLength, true) + " - " + desc + (this.getCommandName().equals(defaultCommand) ? " This is the default command." : "") + (this.aliases.isEmpty() ? "" : "\n\nCommand alias:" + this.aliases.toString()), main.MAX_COLUMN_LENGTH, alignLength + 3));
            if (html) {
                pr.println("</pre>");
            }
            if (html) {
                pr.println("<h4>");
            }
            if (!html) {
                pr.println("\n");
            }
        }
        pr.println("Mandatory argument(s):");
        if (!html) {
            this.printUnderline(pr, "Mandatory argument(s):".length());
            pr.println();
        }
        if (html) {
            pr.println("</h4><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
        }
        for (CommandLineArg arg : this.getArgs().values()) {
            if (arg.isHidden() || !arg.isMandatory()) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        if (html) {
            pr.println("</pre>");
        }
        if (html) {
            pr.println("<h4>");
        }
        if (!html) {
            pr.println("\n");
        }
        pr.println("Optional arguments(s):");
        if (!html) {
            this.printUnderline(pr, "Optional arguments(s):".length());
            pr.println();
        }
        if (html) {
            pr.println("</h4><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
        }
        for (CommandLineArg arg : this.getArgs().values()) {
            if (arg.isHidden() || arg.isMandatory() || arg.isDebugArg() || arg.isAdvancedOption()) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        if (html) {
            pr.println("</pre>");
        }
        if (html) {
            pr.println("<h4>");
        }
        if (!html) {
            pr.println("\n");
        }
        pr.println("Advanced argument(s):");
        if (!html) {
            this.printUnderline(pr, "Advanced argument(s):".length());
            pr.println();
        }
        if (html) {
            pr.println("</h4><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
        }
        for (CommandLineArg arg : this.getArgs().values()) {
            if (arg.isHidden() || !arg.isAdvancedOption()) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        if (html) {
            pr.println("</pre>");
        }
        if (html) {
            pr.println("<h4>");
        }
        if (!html) {
            pr.println("\n");
        }
        pr.println("Diagnostic/Help argument(s):");
        if (!html) {
            this.printUnderline(pr, "Diagnostic/Help argument(s):".length());
            pr.println();
        }
        if (html) {
            pr.println("</h4><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
        }
        for (CommandLineArg arg : this.getArgs().values()) {
            if (!arg.isDebugArg()) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        if (html) {
            pr.println("</pre>");
        }
        pr.flush();
    }

    public void emitToolHelp(MainBase main, PrintWriter pr, boolean html, String defCommand) {
        int alignLength = CloudUtil.getKeyMaxLength(this.getArgs());
        if (alignLength < this.getCommandName().length()) {
            alignLength = this.getCommandName().length();
        }
        pr.println(CloudUtil.convertToHelpText(CloudUtil.padChar(alignLength, ' ', "\n\n\n", alignLength, true) + this.getDescription() + (this.getCommandName().equals(defCommand) ? " This is the default command" : "") + (this.aliases.isEmpty() ? "" : "\n\nCommand alias:" + this.aliases.toString()), main.MAX_COLUMN_LENGTH, alignLength + 3));
        pr.println("\n");
        pr.println("Mandatory:");
        this.printUnderline(pr, "Mandatory:".length());
        pr.println();
        for (CommandLineArg arg : this.getArgs().values()) {
            if (arg.isHidden() || !arg.isMandatory()) continue;
            String desc = arg.getDescription();
            if (arg.getReplacementOptionNames() != null && arg.getReplacementOptionNames().size() != 0) {
                desc = desc + " This is not required when one from " + CloudUtil.getCommaSeparatedListOfString(arg.getReplacementOptionNames()) + " is specified.";
            }
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        pr.println("\n");
        pr.println("Optional:");
        this.printUnderline(pr, "Optional:".length());
        pr.println();
        for (CommandLineArg arg : this.getArgs().values()) {
            if (arg.isHidden() || arg.isMandatory() || arg.isDebugArg() || arg.isAdvancedOption() || arg.getOptionName().equals("output")) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        pr.println("\n");
        pr.println("Advanced:");
        this.printUnderline(pr, "Advanced:".length());
        pr.println();
        for (CommandLineArg arg : this.getArgs().values()) {
            if (!arg.isAdvancedOption()) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        pr.println("\n");
        pr.println("Diagnostic/Help arguments:");
        this.printUnderline(pr, "Diagnostic/Help arguments:".length());
        pr.println();
        for (CommandLineArg arg : this.getArgs().values()) {
            if (!arg.isDebugArg() || arg.getOptionName().equals("help")) continue;
            pr.println(arg.getCLIHelpMessage(alignLength, main.MAX_COLUMN_LENGTH, html));
            pr.println();
        }
        pr.flush();
    }

    public void setExtraArgs(List<String> extraArgs) {
        this.extraArgs = extraArgs;
    }

    public List<String> getExtraArgs() {
        return this.extraArgs;
    }

    public Object simpleClone(boolean includeHidden) throws CloneNotSupportedException {
        CommandLine cl = new CommandLine();
        cl.setCommandName(this.getCommandName());
        cl.setDescription(this.getDescription());
        cl.setCliProvider(this.getCliProvider());
        if (this.getExtraArgs() != null) {
            cl.setExtraArgs(new ArrayList<String>(this.getExtraArgs()));
        }
        for (NameValuePair<String, CommandLineArg> pair : this.getArgs().getList()) {
            if (!includeHidden && pair.getValue().isHidden()) continue;
            cl.addArg(pair.getValue().simpleClone());
        }
        cl.getCommandAliases().addAll(this.getCommandAliases());
        return cl;
    }

    public Object simpleClone() throws CloneNotSupportedException {
        return this.simpleClone(true);
    }

    public void setArgs(OrderedMap<String, CommandLineArg> args) {
        this.args = args;
    }

    public boolean getValueAsBoolean(String name) {
        String val = this.getArgValue(name);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    public <T extends Enum> T getEnumValue(String name, Class<T> en, boolean tolower) throws CliException {
        String val = null;
        val = tolower ? this.getArgValue(name, "").toLowerCase() : this.getArgValue(name, "").toUpperCase();
        try {
            return Enum.valueOf(en, val);
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{name, val, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(en, null, tolower))}));
        }
    }

    public int getAsPositiveInteger(String name) throws CliException {
        String val = this.getArgValue(name);
        try {
            if (val == null) {
                throw new Exception("Not specified:" + name);
            }
            int ret = Integer.parseInt(val);
            if (ret <= 0) {
                throw new Exception("Not a valid value.");
            }
            return ret;
        }
        catch (Exception e) {
            throw new CliException("Please enter valid value for " + name, e);
        }
    }

    public String getArgValue(String argName) {
        return this.getArgValue(argName, null);
    }

    public String getArgValue(String argName, String defaultValue) {
        if (this.args == null) {
            return null;
        }
        CommandLineArg arg = this.args.get(argName);
        if (arg == null) {
            return null;
        }
        String val = arg.getOptionValue();
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public void addHelp() {
        CommandLineArg help = new CommandLineArg("help", false, new CommandLineArg.BooleanOptionType(), true, NLSUtil.localizeMessage("NLS_PARAM_DESCR_HELP"), "help", "false");
        help.setOptionDefaltValue("false");
        this.addArg(help);
    }

    public void addDebugArgs() {
        ArrayList<String> ew = new ArrayList<String>(2);
        ew.add("ERROR");
        ew.add("WARNING");
        List<String> userLogLevels = CloudUtil.getEnumValuesAsList(Logger.LOG_MESSAGE_TYPES.class);
        userLogLevels.removeAll(ew);
        ArrayList<CommandLineArg> debugArgs = new ArrayList<CommandLineArg>();
        debugArgs.add(new CommandLineArg("debug", false, new CommandLineArg.BooleanOptionType(), true, NLSUtil.localizeMessage("PARAM_DESCR_DEBUG"), NLSUtil.localizeMessage("PARAM_MSG_DEBUG"), "false"));
        this.addHelp();
        this.addArgs(debugArgs);
    }

    public void setCliProvider(CliExecutorProvider<? extends CliExecutor> cliProvider) {
        this.cliProvider = cliProvider;
    }

    @XmlTransient
    public CliExecutorProvider<? extends CliExecutor> getCliProvider() {
        return this.cliProvider;
    }

    public void setExtraArgsType(CommandLineArg.OptionType extraArgsType) {
        this.extraArgsType = extraArgsType;
    }

    @XmlTransient
    public CommandLineArg.OptionType getExtraArgsType() {
        return this.extraArgsType;
    }
}

