/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.internal.impl;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloud.micro.api.impl.JobManager;
import oracle.cloud.micro.api.impl.LocalExtensionManagerDefaultImpl;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Metric;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;

public abstract class BaseManager
implements Closeable {
    protected WebLogicDeploymentManager deployManager;
    protected MBeanServerConnection mbeanServerRuntimeConnection;
    protected MBeanServerConnection mbeanDomainRuntimeConnection;
    protected MBeanServerConnection mbeanEditRuntimeConnection;
    private String host;
    private int port;
    protected String user;
    protected String pwd;
    private static ObjectName drService = null;
    private static ObjectName runtimeService = null;
    protected JobManager jobManager = null;
    protected LocalExtensionManager localextension = null;
    private static Map<String, Integer> _STATE_AND_VALUE = null;
    protected Set<String> INTERNAL_APPS = null;
    protected static final Collection<String> INTERNAL_DS = Arrays.asList("mds-owsm");
    private static String METRIC_COMPONENT_JVM = "JVM";
    private static String METRIC_COMPONENT_DS = "Datasource";
    private static String METRIC_COMPONENT_WORK_MANAGER = "WorkManager";
    private static String METRIC_COMPONENT_SERVLET = "Servlet";
    private static String METRIC_COMPONENT_WEB = "Web";

    protected String getHttpUrl() {
        return "http://" + this.host + ":" + this.port;
    }

    @Override
    public void close() {
        if (this.deployManager != null) {
            this.deployManager.release();
        }
        this.mbeanServerRuntimeConnection = null;
        this.mbeanDomainRuntimeConnection = null;
        this.jobManager.shutdownNow();
    }

    public BaseManager(String host, int port, String user, String pwd) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pwd = pwd;
        this.jobManager = new JobManager();
        this.localextension = new LocalExtensionManagerDefaultImpl();
        this.reconnect();
    }

    protected void reconnect() {
        try {
            this.deployManager = SessionHelper.getRemoteDeploymentManager((String)"t3", (String)this.host, (String)String.valueOf(this.port), (String)this.user, (String)this.pwd);
            String jndiroot = "/jndi/";
            String mserver = "weblogic.management.mbeanservers.runtime";
            JMXServiceURL serviceURL = new JMXServiceURL("t3", this.host, this.port, jndiroot + mserver);
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("java.naming.security.principal", this.user);
            h.put("java.naming.security.credentials", this.pwd);
            h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            JMXConnector connector = JMXConnectorFactory.connect(serviceURL, h);
            this.mbeanServerRuntimeConnection = connector.getMBeanServerConnection();
            mserver = "weblogic.management.mbeanservers.domainruntime";
            serviceURL = new JMXServiceURL("t3", this.host, this.port, jndiroot + mserver);
            connector = JMXConnectorFactory.connect(serviceURL, h);
            this.mbeanDomainRuntimeConnection = connector.getMBeanServerConnection();
            mserver = "weblogic.management.mbeanservers.edit";
            serviceURL = new JMXServiceURL("t3", this.host, this.port, jndiroot + mserver);
            connector = JMXConnectorFactory.connect(serviceURL, h);
            this.mbeanEditRuntimeConnection = connector.getMBeanServerConnection();
            System.out.println(this.mbeanEditRuntimeConnection);
            if (drService == null) {
                drService = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            }
            if (runtimeService == null) {
                runtimeService = new ObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
            }
            this.INTERNAL_APPS = this.getInternalAppNames();
            if (this.INTERNAL_APPS == null) {
                this.INTERNAL_APPS = new HashSet<String>();
            }
            this.INTERNAL_APPS.add("DMS Application");
            this.INTERNAL_APPS.add("wsm-pm");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Metric> listAllDataSources() {
        return this.listOrFindDataSource(null);
    }

    public List<Metric> listAllServerWorkManager() {
        return this.listOrFindServerWorkManager(null);
    }

    public List<Metric> listOrFindWebModules(String appName, String moduleUri) {
        try {
            ObjectName[] servers;
            ArrayList<Metric> list = new ArrayList<Metric>();
            for (ObjectName s : servers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(drService, "ServerRuntimes")) {
                ObjectName[] apps;
                String serverName = (String)this.mbeanDomainRuntimeConnection.getAttribute(s, "Name");
                for (ObjectName a : apps = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(s, "ApplicationRuntimes")) {
                    ObjectName[] comps;
                    String applicationName = (String)this.mbeanDomainRuntimeConnection.getAttribute(a, "ApplicationName");
                    if (!applicationName.equals(appName)) continue;
                    for (ObjectName c : comps = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(a, "ComponentRuntimes")) {
                        ObjectName[] workmanagers;
                        String type = (String)this.mbeanDomainRuntimeConnection.getAttribute(c, "Type");
                        if (!"WebAppComponentRuntime".equals(type)) continue;
                        String module = (String)this.mbeanDomainRuntimeConnection.getAttribute(c, "ModuleURI");
                        if (moduleUri != null && !moduleUri.equals(module)) continue;
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_WEB, module, METRIC_COMPONENT_WEB + "OpenSessionsCurrentCount", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(c, "OpenSessionsCurrentCount")).intValue()));
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_WEB, module, METRIC_COMPONENT_WEB + "OpenSessionsHighCount", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(c, "OpenSessionsHighCount")).intValue()));
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_WEB, module, METRIC_COMPONENT_WEB + "SessionsOpenedTotalCount", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(c, "SessionsOpenedTotalCount")).intValue()));
                        ObjectName[] servlets = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(c, "Servlets");
                        int ExecutionTimeHigh = 0;
                        int ExecutionTimeLow = 0;
                        long ExecutionTimeTotal = 0L;
                        int InvocationTotalCount = 0;
                        int servletcount = 0;
                        for (ObjectName slt : servlets) {
                            ++servletcount;
                            ExecutionTimeHigh += ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(slt, "ExecutionTimeHigh")).intValue();
                            ExecutionTimeLow += ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(slt, "ExecutionTimeLow")).intValue();
                            Object total = this.mbeanDomainRuntimeConnection.getAttribute(slt, "ExecutionTimeTotal");
                            ExecutionTimeTotal = Integer.class == total.getClass() ? (ExecutionTimeTotal += (long)((Integer)total).intValue()) : (ExecutionTimeTotal += ((Long)total).longValue());
                            InvocationTotalCount += ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(slt, "InvocationTotalCount")).intValue();
                        }
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_SERVLET, module, METRIC_COMPONENT_SERVLET + "ExecutionTimeHigh", ExecutionTimeHigh));
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_SERVLET, module, METRIC_COMPONENT_SERVLET + "ExecutionTimeLow", ExecutionTimeLow));
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_SERVLET, module, METRIC_COMPONENT_SERVLET + "ExecutionTimeTotal", ExecutionTimeTotal));
                        list.add(this.newMetric(serverName, METRIC_COMPONENT_SERVLET, module, METRIC_COMPONENT_SERVLET + "InvocationTotalCount", InvocationTotalCount));
                        if (InvocationTotalCount != 0) {
                            list.add(this.newMetric(serverName, METRIC_COMPONENT_SERVLET, module, METRIC_COMPONENT_SERVLET + "ExecutionTimeAverage", 1.0 * (double)ExecutionTimeTotal / (double)InvocationTotalCount));
                        }
                        for (ObjectName wm : workmanagers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(c, "WorkManagerRuntimes")) {
                            String wmname = (String)this.mbeanDomainRuntimeConnection.getAttribute(wm, "Name");
                            list.add(this.newMetric(serverName, METRIC_COMPONENT_WORK_MANAGER, wmname, METRIC_COMPONENT_WORK_MANAGER + "CompletedRequests", ((Long)this.mbeanDomainRuntimeConnection.getAttribute(wm, "CompletedRequests")).longValue()));
                            list.add(this.newMetric(serverName, METRIC_COMPONENT_WORK_MANAGER, wmname, METRIC_COMPONENT_WORK_MANAGER + "PendingRequests", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(wm, "PendingRequests")).intValue()));
                        }
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Metric> listOrFindServerWorkManager(String wm) {
        try {
            ObjectName[] servers;
            ArrayList<Metric> list = new ArrayList<Metric>();
            for (ObjectName s : servers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(drService, "ServerRuntimes")) {
                ObjectName[] wms;
                String serverName = (String)this.mbeanDomainRuntimeConnection.getAttribute(s, "Name");
                for (ObjectName a : wms = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(s, "WorkManagerRuntimes")) {
                    String name = (String)this.mbeanDomainRuntimeConnection.getAttribute(a, "Name");
                    if (wm != null && !name.equals(wm)) continue;
                    list.add(this.newMetric(serverName, METRIC_COMPONENT_WORK_MANAGER, name, METRIC_COMPONENT_WORK_MANAGER + "CompletedRequests", ((Long)this.mbeanDomainRuntimeConnection.getAttribute(a, "CompletedRequests")).longValue()));
                    list.add(this.newMetric(serverName, METRIC_COMPONENT_WORK_MANAGER, name, METRIC_COMPONENT_WORK_MANAGER + "PendingRequests", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(a, "PendingRequests")).intValue()));
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Metric> listOrFindDataSource(String specificDs) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        try {
            ObjectName[] servers;
            for (ObjectName s : servers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(drService, "ServerRuntimes")) {
                ObjectName[] dss;
                String server = (String)this.mbeanDomainRuntimeConnection.getAttribute(s, "Name");
                ObjectName jdbcservice = (ObjectName)this.mbeanDomainRuntimeConnection.getAttribute(s, "JDBCServiceRuntime");
                if (jdbcservice == null || (dss = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(jdbcservice, "JDBCDataSourceRuntimeMBeans")) == null || dss.length == 0) continue;
                for (ObjectName ds : dss) {
                    String dname = (String)this.mbeanDomainRuntimeConnection.getAttribute(ds, "Name");
                    if (specificDs != null && !specificDs.equals(dname) || INTERNAL_DS.contains(dname)) continue;
                    list.add(this.newMetric(server, METRIC_COMPONENT_DS, dname, METRIC_COMPONENT_DS + "ActiveConnectionsCurrentCount", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(ds, "ActiveConnectionsCurrentCount")).intValue()));
                    list.add(this.newMetric(server, METRIC_COMPONENT_DS, dname, METRIC_COMPONENT_DS + "ConnectionsTotalCount", ((Integer)this.mbeanDomainRuntimeConnection.getAttribute(ds, "ConnectionsTotalCount")).intValue()));
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Metric> listAllServers() {
        return this.listOrFindServer(null);
    }

    private Metric newMetric(String server, String category, String instance, String name, double val) {
        Metric m = new Metric();
        m.setServer(server);
        m.setCategory(category);
        m.setComponent(instance);
        m.setName(name);
        m.setValue(val);
        if (instance == null) {
            throw new RuntimeException("instance is null:" + category + " :" + name);
        }
        return m;
    }

    public List<Metric> listOrFindServer(String specificServer) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        try {
            ObjectName[] servers;
            for (ObjectName s : servers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(drService, "ServerRuntimes")) {
                String server = (String)this.mbeanDomainRuntimeConnection.getAttribute(s, "Name");
                if (specificServer != null && !specificServer.equals(server)) continue;
                ObjectName jvm = (ObjectName)this.mbeanDomainRuntimeConnection.getAttribute(s, "JVMRuntime");
                String component = null;
                String type = (String)this.mbeanDomainRuntimeConnection.getAttribute(jvm, "Type");
                if ("JRockitRuntime".equals(type)) {
                    double load = (Double)this.mbeanDomainRuntimeConnection.getAttribute(jvm, "JvmProcessorLoad");
                    component = "JRockit";
                    list.add(this.newMetric(server, METRIC_COMPONENT_JVM, component, "JvmProcessorLoad", load));
                } else {
                    component = type;
                    if (component == null) {
                        component = "Unknown-JVM";
                    }
                }
                list.add(this.newMetric(server, METRIC_COMPONENT_JVM, component, METRIC_COMPONENT_JVM + "HeapFreeCurrent", ((Long)this.mbeanDomainRuntimeConnection.getAttribute(jvm, "HeapFreeCurrent")).longValue()));
                list.add(this.newMetric(server, METRIC_COMPONENT_JVM, component, METRIC_COMPONENT_JVM + "HeapSizeMax", ((Long)this.mbeanDomainRuntimeConnection.getAttribute(jvm, "HeapSizeMax")).longValue()));
                list.add(this.newMetric(server, METRIC_COMPONENT_JVM, component, METRIC_COMPONENT_JVM + "HeapSizeCurrent", ((Long)this.mbeanDomainRuntimeConnection.getAttribute(jvm, "HeapSizeCurrent")).longValue()));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Application> listAllApplications(String group, String service) {
        return this.listOrFindApplication(group, service, null);
    }

    public Set<String> getInternalAppNames() {
        HashSet<String> internalApps = new HashSet<String>();
        try {
            Set<ObjectName> emApps = this.mbeanServerRuntimeConnection.queryNames(new ObjectName("EMDomain:type=EMIntegration,EMTargetType=j2ee_application,*"), null);
            for (ObjectName app : emApps) {
                String value;
                Logger.getDEFAULT().printlnDebug(app.getCanonicalName());
                TabularData tData = (TabularData)this.mbeanServerRuntimeConnection.getAttribute(app, "EMInstanceProperties");
                CompositeData cData = tData == null ? null : tData.get(new String[]{"isOracleInternal"});
                String string = value = cData == null ? null : cData.get("value").toString();
                if (value != null && !value.equals("true")) continue;
                String appName = app.getKeyProperty("Application");
                internalApps.add(appName);
            }
        }
        catch (Throwable e) {
            Logger.getDEFAULT().printlnThrowable(e);
            Logger.getDEFAULT().printlnError("Error while getting internal applications list.");
        }
        return internalApps;
    }

    public List<Application> listOrFindApplication(String groupname, String service, String specificApp) {
        try {
            ObjectName[] deployments;
            HashMap<String, Application> map = new HashMap<String, Application>();
            ObjectName domainMBean = (ObjectName)this.mbeanServerRuntimeConnection.getAttribute(runtimeService, "DomainConfiguration");
            for (ObjectName deployment : deployments = (ObjectName[])this.mbeanServerRuntimeConnection.getAttribute(domainMBean, "AppDeployments")) {
                Boolean internal;
                String appName = (String)this.mbeanServerRuntimeConnection.getAttribute(deployment, "Name");
                if (specificApp != null && !specificApp.equals(appName) || (internal = (Boolean)this.mbeanServerRuntimeConnection.getAttribute(deployment, "InternalApp")).booleanValue()) continue;
                String moduleType = (String)this.mbeanServerRuntimeConnection.getAttribute(deployment, "ModuleType");
                String exactAppName = appName;
                int hash = exactAppName.indexOf("#");
                if (hash > 0) {
                    exactAppName = exactAppName.substring(0, hash);
                }
                if (this.INTERNAL_APPS.contains(exactAppName)) {
                    Logger.getDEFAULT().printlnDebug(exactAppName + " is an internal application");
                    continue;
                }
                Application a = new Application();
                a.setGroupName(groupname);
                a.setInstanceName(service);
                a.setApplicationName(appName);
                a.setType(ApplicationType.valueOf((String)moduleType.toUpperCase()));
                map.put(a.getApplicationName(), a);
            }
            ArrayList<Application> list = new ArrayList<Application>(map.values());
            this.updateState(list);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateState(List<Application> list) {
        try {
            String base = this.localextension.getLoadbalancerUrl();
            boolean basegiven = base != null;
            ObjectName domainRuntime = (ObjectName)this.mbeanDomainRuntimeConnection.getAttribute(drService, "DomainRuntime");
            ObjectName AppRuntimeStateRuntime = (ObjectName)this.mbeanDomainRuntimeConnection.getAttribute(domainRuntime, "AppRuntimeStateRuntime");
            ObjectName[] servers = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(drService, "ServerRuntimes");
            for (Application app : list) {
                int state = 1;
                String stateString = "STATE_NEW";
                ArrayList<String> urls = new ArrayList<String>();
                for (ObjectName server : servers) {
                    ObjectName[] apps;
                    if (!basegiven || base == null) {
                        base = (String)this.mbeanDomainRuntimeConnection.invoke(server, "getURL", new Object[]{"http"}, new String[]{String.class.getName()});
                        if (base == null) {
                            base = (String)this.mbeanDomainRuntimeConnection.invoke(server, "getURL", new Object[]{"https"}, new String[]{String.class.getName()});
                        }
                        if (base == null) {
                            base = "";
                        }
                    }
                    for (ObjectName a : apps = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(server, "ApplicationRuntimes")) {
                        ObjectName[] comps;
                        String applicationName = (String)this.mbeanDomainRuntimeConnection.getAttribute(a, "ApplicationName");
                        if (!applicationName.equals(app.getApplicationName())) continue;
                        for (ObjectName c : comps = (ObjectName[])this.mbeanDomainRuntimeConnection.getAttribute(a, "ComponentRuntimes")) {
                            String type = (String)this.mbeanDomainRuntimeConnection.getAttribute(c, "Type");
                            if (!"WebAppComponentRuntime".equals(type)) continue;
                            String contextPath = (String)this.mbeanDomainRuntimeConnection.getAttribute(c, "ContextRoot");
                            String fullurl = base + contextPath;
                            if (urls.contains(fullurl)) continue;
                            urls.add(fullurl);
                        }
                    }
                    String serverName = (String)this.mbeanDomainRuntimeConnection.getAttribute(server, "Name");
                    String stateAtServer = (String)this.mbeanDomainRuntimeConnection.invoke(AppRuntimeStateRuntime, "getCurrentState", new Object[]{app.getApplicationName(), serverName}, new String[]{String.class.getName(), String.class.getName()});
                    Integer stateAtServerInt = _STATE_AND_VALUE.get(stateAtServer);
                    if (stateAtServer == null || stateAtServerInt <= state) continue;
                    state = stateAtServerInt;
                    stateString = stateAtServer;
                }
                app.setState(ApplicationState.valueOf((String)stateString));
                app.setApplicationUrls(urls);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        _STATE_AND_VALUE = new HashMap<String, Integer>();
        _STATE_AND_VALUE.put("STATE_ACTIVE", 7);
        _STATE_AND_VALUE.put("STATE_ADMIN", 6);
        _STATE_AND_VALUE.put("STATE_UPDATE_PENDING", 5);
        _STATE_AND_VALUE.put("STATE_PREPARED", 4);
        _STATE_AND_VALUE.put("STATE_FAILED", 3);
        _STATE_AND_VALUE.put("STATE_RETIRED", 2);
        _STATE_AND_VALUE.put("STATE_NEW", 1);
    }
}

