/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import oracle.cloud.micro.api.impl.AbstractJob;
import oracle.cloud.micro.api.impl.DeployJob;
import oracle.cloud.micro.api.impl.LogWithContent;
import oracle.cloud.micro.api.impl.ReDeployJob;
import oracle.cloud.micro.api.impl.ServiceRestartJob;
import oracle.cloud.micro.api.impl.StartJob;
import oracle.cloud.micro.api.impl.StopJob;
import oracle.cloud.micro.api.impl.UndeployJob;
import oracle.cloud.micro.internal.impl.BaseManager;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.JobQuery;
import oracle.cloud.paas.api.ServiceInstanceLogCriteria;
import oracle.cloud.paas.exception.DuplicateResourceException;
import oracle.cloud.paas.exception.ResourcePermissionException;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.DataSource;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Metric;
import oracle.cloud.paas.model.Server;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceSize;
import oracle.cloud.paas.model.ServiceState;
import oracle.cloud.paas.model.ServiceType;
import oracle.cloud.paas.model.WebModuleInstance;
import oracle.cloud.paas.model.WorkManagerInstance;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.executor.ManagableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ApplicationManagerImpl
extends BaseManager
implements ApplicationManager,
ManagableExecutor {
    private boolean cli = false;

    public ApplicationManagerImpl(String host, int port, String user, String pwd) throws DeploymentManagerCreationException {
        super(host, port, user, pwd);
    }

    @Override
    public void setCommandLine(CommandLine commandLine) {
        throw new RuntimeException("Not allowed...");
    }

    @Override
    public void validate() {
        throw new RuntimeException("Not allowed...");
    }

    @Override
    public void execute() {
        throw new RuntimeException("Not allowed...");
    }

    @Override
    public void prepareToBeManaged() {
        this.cli = true;
        Logger.getDEFAULT().printlnWarning("Application Manager is on CLI mode. No asynchronous operations will be available against local Weblogic Server when invoked from CLI.");
    }

    public Application getApplicationIfExists(String tenantId, String serviceName, String appId) throws UnknownResourceException {
        List<Application> list = this.listOrFindApplication(tenantId, serviceName, appId);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public boolean checkApplicationIfExists(String tenantId, String serviceName, String appId) {
        return this.getApplicationIfExists(tenantId, serviceName, appId) != null;
    }

    public Job deployApplication(String tenantId, String serviceName, String appName, ApplicationType type, InputStream inputStream) {
        return this.deployApplication(tenantId, serviceName, appName, type, inputStream, null);
    }

    public Job redeployApplication(String tenantId, String serviceName, String appname, InputStream inputStream) {
        return this.redeployApplication(tenantId, serviceName, appname, inputStream, null);
    }

    public Job undeployApplication(String tenantId, String serviceName, String appId) {
        Logger.getDEFAULT().printlnDebug("Internal applications:" + this.INTERNAL_APPS);
        if (this.INTERNAL_APPS.contains(appId)) {
            throw new ResourcePermissionException("Application  " + appId + " is reserved.");
        }
        Application existing = this.getApplicationIfExists(tenantId, serviceName, appId);
        if (existing == null) {
            throw new UnknownResourceException("Application '" + appId + "' does not exist.");
        }
        UndeployJob undeploy = new UndeployJob(this.deployManager, tenantId, serviceName, appId, this.jobManager, this.localextension);
        undeploy.execute();
        undeploy.waitUntilStarted();
        if (this.cli) {
            undeploy.waitWhileRunning();
            if (undeploy.getError() != null) {
                throw new RuntimeException("un-deploy operation has failed.", undeploy.getError());
            }
        }
        return undeploy.getJobType();
    }

    public Application describeApplication(String tenantId, String serviceName, String appId) {
        Logger.getDEFAULT().printlnDebug("Internal applications:" + this.INTERNAL_APPS);
        List<Application> list = this.listOrFindApplication(tenantId, serviceName, appId);
        if (list.size() != 1) {
            throw new UnknownResourceException("Application Id:" + appId + " not found");
        }
        return list.get(0);
    }

    public List<Application> listApplications(String tenantId, String serviceName) {
        Logger.getDEFAULT().printlnDebug("Internal applications:" + this.INTERNAL_APPS);
        return this.listAllApplications(tenantId, serviceName);
    }

    public Job startApplication(String tenantId, String serviceName, String appId) {
        return this.startApplication(tenantId, serviceName, appId, null);
    }

    public Job stopApplication(String tenantId, String serviceName, String appId) {
        return this.stopApplication(tenantId, serviceName, appId, null);
    }

    public List<Job> listJobs() {
        return this.jobManager.getAllJobTypes();
    }

    public AbstractJob findOrThrowExceptionJob(String jobId) {
        AbstractJob job = this.jobManager.findJob(jobId);
        if (job == null) {
            throw new UnknownResourceException("Job id:" + jobId + " not found");
        }
        return job;
    }

    public Job describeJob(String jobId) {
        AbstractJob job = this.findOrThrowExceptionJob(jobId);
        return job.getJobType();
    }

    public void fetchJobLog(String jobId, String logName, OutputStream outputStream) {
        block8: {
            try {
                AbstractJob job = this.findOrThrowExceptionJob(jobId);
                Log log = job.getLog();
                if (log != null && log.getName().equals(logName)) {
                    String message;
                    ProgressObject p = job.getProgressObject();
                    boolean msgWritten = false;
                    if (p != null && (message = p.getDeploymentStatus().getMessage()) != null && !message.equals("")) {
                        outputStream.write(message.getBytes());
                        outputStream.flush();
                        msgWritten = true;
                    }
                    if (!msgWritten && job.error != null) {
                        PrintStream pr = new PrintStream(outputStream, true);
                        job.error.printStackTrace(pr);
                        pr.flush();
                        outputStream.flush();
                        pr.close();
                    }
                    break block8;
                }
                ArrayList<String> logs = new ArrayList<String>();
                if (log != null) {
                    logs.add(log.getName());
                }
                for (LogWithContent plog : job.getPreProcessorLogs()) {
                    logs.add(plog.getLog().getName());
                    if (!logName.equals(plog.getLog().getName())) continue;
                    byte[] content = plog.getContent();
                    if (content != null) {
                        outputStream.write(content);
                        outputStream.flush();
                    }
                    return;
                }
                throw new RuntimeException("Unable to find log with name:" + logName + (logs.isEmpty() ? ". No log found yet." : ". Available logs:" + CloudUtil.getCommaSeparatedListOfString(logs)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Job deployApplication(String tenantId, String serviceName, String appName, ApplicationType type, InputStream inputStream, ApplicationState applicationState) {
        if (this.INTERNAL_APPS.contains(appName)) {
            throw new ResourcePermissionException("Application " + appName + " is reserved.");
        }
        Application existing = this.getApplicationIfExists(tenantId, serviceName, appName);
        if (existing != null) {
            throw new DuplicateResourceException("Application already exists; Please consider redeployment");
        }
        if (applicationState == null) {
            applicationState = ApplicationState.STATE_ACTIVE;
        }
        if (applicationState != ApplicationState.STATE_ACTIVE && applicationState != ApplicationState.STATE_ADMIN) {
            throw new ResourcePermissionException("Un-expected desired state:" + applicationState.toString());
        }
        DeployJob deploy = new DeployJob(this.getHttpUrl(), this.user, this.pwd == null ? null : this.pwd.getBytes(), this.deployManager, tenantId, serviceName, appName, type, inputStream, this.jobManager, applicationState == ApplicationState.STATE_ADMIN, this.localextension);
        deploy.execute();
        deploy.waitUntilStarted();
        if (this.cli) {
            deploy.waitWhileRunning();
            if (deploy.getError() != null) {
                throw new RuntimeException("deploy operation has failed.", deploy.getError());
            }
        }
        return deploy.getJobType();
    }

    public Job redeployApplication(String tenantId, String serviceName, String appname, InputStream inputStream, ApplicationState applicationState) {
        Logger.getDEFAULT().printlnDebug("Internal applications:" + this.INTERNAL_APPS);
        if (this.INTERNAL_APPS.contains(appname)) {
            throw new ResourcePermissionException("Application  " + appname + " is reserved.");
        }
        Application existing = this.getApplicationIfExists(tenantId, serviceName, appname);
        if (existing == null) {
            throw new UnknownResourceException("Application does not exist; Please consider deployment");
        }
        if (applicationState == null) {
            applicationState = ApplicationState.STATE_ACTIVE;
        }
        if (applicationState != ApplicationState.STATE_ACTIVE && applicationState != ApplicationState.STATE_ADMIN) {
            throw new ResourcePermissionException("Un-expected desired state:" + applicationState.toString());
        }
        ReDeployJob deploy = new ReDeployJob(this.getHttpUrl(), this.user, this.pwd == null ? null : this.pwd.getBytes(), this.deployManager, tenantId, serviceName, appname, existing.getType(), inputStream, this.jobManager, applicationState == ApplicationState.STATE_ADMIN, this.localextension);
        deploy.execute();
        deploy.waitUntilStarted();
        if (this.cli) {
            deploy.waitWhileRunning();
            if (deploy.getError() != null) {
                throw new RuntimeException("re-deploy operation has failed.", deploy.getError());
            }
        }
        return deploy.getJobType();
    }

    public Job startApplication(String tenantId, String serviceName, String appId, ApplicationState applicationState) {
        if (this.INTERNAL_APPS.contains(appId)) {
            throw new ResourcePermissionException("Application  " + appId + " is reserved.");
        }
        if (!this.checkApplicationIfExists(tenantId, serviceName, appId)) {
            throw new UnknownResourceException("Application does not exist; Please consider deployment");
        }
        if (applicationState == null) {
            applicationState = ApplicationState.STATE_ACTIVE;
        }
        if (applicationState != ApplicationState.STATE_ACTIVE && applicationState != ApplicationState.STATE_ADMIN) {
            throw new ResourcePermissionException("Un-expected desired state:" + applicationState.toString());
        }
        StartJob start = new StartJob(this.deployManager, tenantId, serviceName, appId, this.jobManager, applicationState == ApplicationState.STATE_ADMIN, this.localextension);
        start.execute();
        start.waitUntilStarted();
        if (this.cli) {
            start.waitWhileRunning();
            if (start.getError() != null) {
                throw new RuntimeException("Start operation has failed.", start.getError());
            }
        }
        return start.getJobType();
    }

    public Job stopApplication(String tenantId, String serviceName, String appId, ApplicationState applicationState) {
        if (this.INTERNAL_APPS.contains(appId)) {
            throw new ResourcePermissionException("Application  " + appId + " is reserved.");
        }
        if (!this.checkApplicationIfExists(tenantId, serviceName, appId)) {
            throw new UnknownResourceException("Application does not exist; Please consider deployment");
        }
        if (applicationState == null) {
            applicationState = ApplicationState.STATE_PREPARED;
        }
        if (applicationState != ApplicationState.STATE_PREPARED && applicationState != ApplicationState.STATE_ADMIN) {
            throw new ResourcePermissionException("Un-expected desired state:" + applicationState.toString());
        }
        StopJob stop = new StopJob(this.deployManager, tenantId, serviceName, appId, this.jobManager, applicationState == ApplicationState.STATE_ADMIN, this.localextension);
        stop.execute();
        stop.waitUntilStarted();
        if (this.cli) {
            stop.waitWhileRunning();
            if (stop.getError() != null) {
                throw new RuntimeException("Stop operation has failed.", stop.getError());
            }
        }
        return stop.getJobType();
    }

    public ServiceInstance describeServiceInstance(String group, String serviceinstance) {
        ServiceInstance ser = this.listServiceInstances(group).get(0);
        ser.setGroupName(group);
        ser.setInstanceName(serviceinstance);
        return ser;
    }

    public List<ServiceInstance> listServiceInstances(String group) {
        ServiceInstance instance = new ServiceInstance();
        instance.setGroupName(group);
        instance.setInstanceName("local");
        instance.setSize(ServiceSize.STANDARD);
        instance.setState(ServiceState.ACTIVE);
        List<Metric> dss = this.listAllDataSources();
        ArrayList<String> instances = new ArrayList<String>();
        for (Metric ds : dss) {
            if (instances.contains(ds.getComponent())) continue;
            instances.add(ds.getComponent());
            Association db = new Association();
            db.setTargetInstanceName(ds.getComponent());
            db.setTargetServiceType(ServiceType.DATABASE);
            instance.getAssociations().add(db);
        }
        return Arrays.asList(instance);
    }

    public List<Job> listJobs(String group, String instance) {
        return this.listJobs(group, instance, null);
    }

    public List<Job> listJobs(String group, String instance, String app) {
        if (app == null) {
            return this.listJobs(group, instance, Arrays.asList(app), null);
        }
        return this.listJobs(group, instance, null, null);
    }

    private List<Job> listJobs(String group, String instance, List<String> apps, List<JobStatus> status) {
        List<Job> jobs = this.listJobs();
        ArrayList<Job> ret = new ArrayList<Job>();
        for (Job j : jobs) {
            boolean groupmatch = group == null || group.equals(j.getGroupName());
            boolean instancematch = instance == null || instance.equals(j.getInstanceName());
            boolean appmatch = true;
            if (apps != null && !apps.isEmpty()) {
                appmatch = false;
                for (String app : apps) {
                    if (!app.equals(j.getApplicationName())) continue;
                    appmatch = true;
                    break;
                }
            }
            boolean statusmatch = true;
            if (status != null && !status.isEmpty()) {
                statusmatch = false;
                for (JobStatus st : status) {
                    if (st != j.getStatus()) continue;
                    statusmatch = true;
                    break;
                }
            }
            if (!groupmatch || !instancematch || !appmatch || !statusmatch) continue;
            ret.add(j);
        }
        return ret;
    }

    public List<Server> listServers(String group, String service) {
        throw new RuntimeException("Deprecated!");
    }

    public Server describeServer(String group, String service, String server) {
        throw new RuntimeException("Deprecated!");
    }

    public List<DataSource> listDataSources(String group, String service) {
        throw new RuntimeException("Deprecated!");
    }

    public DataSource describeDataSource(String group, String service, String ds) {
        throw new RuntimeException("Deprecated!");
    }

    public List<Log> listServiceInstanceLogs(String service, String group) {
        return Collections.emptyList();
    }

    public void fetchServiceInstanceLog(String group, String service, String log, OutputStream outputStream) {
        List<Log> list = this.listServiceInstanceLogs(service, group);
        throw new UnknownResourceException("Log:" + log + " not found");
    }

    public List<Log> listJobLogs(String jobId) {
        AbstractJob job = this.findOrThrowExceptionJob(jobId);
        return job.getLogs();
    }

    public List<WebModuleInstance> listWebModuleInstances(String group, String service, String app) {
        throw new RuntimeException("Deprecated!");
    }

    public List<WebModuleInstance> listWebModuleInstances(String group, String service, String app, String moduleuri) {
        throw new RuntimeException("Deprecated!");
    }

    public List<WorkManagerInstance> listWorkManagerInstances(String group, String service, String app) {
        throw new RuntimeException("Deprecated!");
    }

    public List<WorkManagerInstance> listWorkManagerInstances(String group, String service, String app, String workmanagername) {
        throw new RuntimeException("Deprecated!");
    }

    public List<Metric> queryServiceInstanceMetrics(String string, String string1, String string2) {
        return Collections.emptyList();
    }

    public List<Metric> queryServiceInstanceMetrics(String string, String string1, String string2, String string3) {
        return Collections.emptyList();
    }

    public List<Metric> queryApplicationMetrics(String string, String string1, String string2, String string3) {
        return Collections.emptyList();
    }

    public List<Metric> queryApplicationMetrics(String string, String string1, String string2, String string3, String string4) {
        return Collections.emptyList();
    }

    public InputStream queryServiceInstanceLogs(String group, String service, ServiceInstanceLogCriteria serviceInstanceLogCriteria) {
        ByteArrayInputStream bi = new ByteArrayInputStream("<msgs>Not a supported operation.</msgs>".getBytes());
        return bi;
    }

    public List<Job> listJobs(JobQuery jobQuery) {
        Map map = jobQuery.getFilter();
        List<String> apps = CloudUtil.parseString((String)map.get("application"), ",");
        List<String> stats = CloudUtil.parseString((String)map.get("status"), ",");
        ArrayList<JobStatus> statuses = new ArrayList<JobStatus>();
        if (stats != null) {
            for (String s : stats) {
                statuses.add(JobStatus.valueOf((String)s));
            }
        }
        return this.listJobs((String)map.get("domain"), (String)map.get("service"), apps, statuses);
    }

    public List<Metric> queryServiceInstanceMetricsWithMetadata(String domainName, String instanceName, String groupBy) {
        return this.listServiceMetrics(groupBy == null ? null : GROUPBY.valueOf(groupBy.toUpperCase()), null);
    }

    public List<Metric> queryServiceInstanceMetricsWithMetadata(String domainName, String instanceName, String metricName, String groupBy) {
        return this.listServiceMetrics(groupBy == null ? null : GROUPBY.valueOf(groupBy.toUpperCase()), metricName);
    }

    public List<Metric> queryApplicationMetricsWithMetadata(String domainName, String instanceName, String applicationName, String groupBy) {
        return this.listApplicationMetrics(groupBy == null ? null : GROUPBY.valueOf(groupBy.toUpperCase()), applicationName, null);
    }

    public List<Metric> queryApplicationMetricsWithMetadata(String groupName, String instanceName, String applicationName, String metricName, String groupBy) {
        return this.listApplicationMetrics(groupBy == null ? null : GROUPBY.valueOf(groupBy.toUpperCase()), applicationName, metricName);
    }

    private List<Metric> listServiceMetrics(GROUPBY groupby, String metricname) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        list.addAll(this.listAllServers());
        list.addAll(this.listAllDataSources());
        list.addAll(this.listAllServerWorkManager());
        if (metricname != null) {
            ArrayList<Metric> filtered = new ArrayList<Metric>();
            for (Metric m : list) {
                if (!m.getName().equals(metricname)) continue;
                filtered.add(m);
            }
            list.clear();
            list = filtered;
        }
        return ApplicationManagerImpl.filter(groupby, list);
    }

    private List<Metric> listApplicationMetrics(GROUPBY groupby, String app, String metricname) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        list.addAll(this.listOrFindWebModules(app, null));
        if (metricname != null) {
            ArrayList<Metric> filtered = new ArrayList<Metric>();
            for (Metric m : list) {
                if (!m.getName().equals(metricname)) continue;
                filtered.add(m);
            }
            list.clear();
            list = filtered;
        }
        return ApplicationManagerImpl.filter(groupby, list);
    }

    private static List<Metric> filter(GROUPBY groupby, List<Metric> full) {
        boolean sumserver = true;
        boolean sumcomponent = true;
        ArrayList<Metric> list = new ArrayList<Metric>();
        if (groupby == null) {
            sumserver = true;
            sumcomponent = true;
        } else if (GROUPBY.COMPONENT == groupby) {
            sumcomponent = false;
        } else if (GROUPBY.SERVER == groupby) {
            sumserver = false;
        } else {
            sumserver = false;
            sumcomponent = false;
        }
        if (sumserver || sumcomponent) {
            for (Metric m : full) {
                Metric matched = ApplicationManagerImpl.findMetric(list, m, sumserver, sumcomponent);
                if (matched == null) {
                    list.add(m);
                    continue;
                }
                matched.setValue(matched.getValue() + m.getValue());
            }
            for (Metric m : list) {
                if (sumserver) {
                    m.setServer(null);
                }
                if (!sumcomponent) continue;
                m.setComponent(null);
            }
        } else {
            list.addAll(full);
        }
        return list;
    }

    private static Metric findMetric(List<Metric> list, Metric tomatch, boolean sumserver, boolean sumcomp) {
        for (Metric m : list) {
            if (!sumserver && !m.getServer().equals(tomatch.getServer()) || !sumcomp && !m.getComponent().equals(tomatch.getComponent()) || m.getCategory() != null && !m.getCategory().equals(tomatch.getCategory()) || !m.getName().equals(tomatch.getName())) continue;
            return m;
        }
        return null;
    }

    public void release() {
        this.close();
    }

    public Job restartService(String identityDomain, String service, boolean forceRestart, long serverRestartTimeout) {
        ServiceRestartJob restart = new ServiceRestartJob(this.deployManager, identityDomain, service, this.jobManager, this.localextension);
        restart.execute();
        restart.waitUntilStarted();
        if (this.cli) {
            restart.waitWhileRunning();
            if (restart.getError() != null) {
                throw new RuntimeException("servce restart operation has failed.", restart.getError());
            }
        }
        return restart.getJobType();
    }

    public Job restartService(String identityDomain, String service, boolean forceRestart) {
        ServiceRestartJob restart = new ServiceRestartJob(this.deployManager, identityDomain, service, this.jobManager, this.localextension);
        restart.execute();
        restart.waitUntilStarted();
        if (this.cli) {
            restart.waitWhileRunning();
            if (restart.getError() != null) {
                throw new RuntimeException("servce restart operation has failed.", restart.getError());
            }
        }
        return restart.getJobType();
    }

    public static enum GROUPBY {
        SERVER,
        COMPONENT,
        SERVERANDCOMPONENT;

    }
}

