/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.util.List;
import javax.enterprise.deploy.spi.TargetModuleID;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloud.micro.api.impl.AbstractJob;
import oracle.cloud.micro.api.impl.JobManager;
import oracle.cloud.paas.exception.UnknownResourceException;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;

public abstract class ApplicationBaseJob
extends AbstractJob {
    protected WebLogicDeploymentManager deployManager;
    protected String appId;

    public ApplicationBaseJob(WebLogicDeploymentManager deployManager, String group, String service, String appId, JobManager manager, LocalExtensionManager extensionManager) {
        super(group, service, manager, extensionManager);
        this.deployManager = deployManager;
        this.appId = appId;
        this.type.setApplicationName(appId);
    }

    public abstract void doAndSetProgressObject(List<TargetModuleID> var1) throws Exception;

    @Override
    public void perform() throws Exception {
        List<TargetModuleID> list = ApplicationBaseJob.getAllModulesWithAppId(this.appId, this.deployManager, this.localextension);
        if (list.isEmpty()) {
            throw new UnknownResourceException("Application :" + this.appId + "  not found in the specified target(s).");
        }
        this.doAndSetProgressObject(list);
        this.waitUntilProgressObjectDone();
        if (this.progressObject.getDeploymentStatus().isFailed()) {
            throw new Exception("Failed:" + this.progressObject.getDeploymentStatus().getMessage());
        }
    }
}

