/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloud.micro.api.impl.JobManager;
import oracle.cloud.micro.api.impl.LocalExtensionManagerDefaultImpl;
import oracle.cloud.micro.api.impl.LogWithContent;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Log;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTarget;

public abstract class AbstractJob
implements Runnable {
    protected Job type;
    protected Throwable error;
    protected ProgressObject progressObject;
    protected Log log = null;
    private final List<LogWithContent> preProcessorLogs = new ArrayList<LogWithContent>();
    private final List<Log> logs = new ArrayList<Log>();
    private JobManager manager;
    protected LocalExtensionManager localextension = null;

    void setType(Job type) {
        this.type = type;
    }

    public ProgressObject getProgressObject() {
        return this.progressObject;
    }

    public Throwable getError() {
        return this.error;
    }

    public void addLog(LogWithContent log) {
        this.preProcessorLogs.add(log);
        this.updateAction(log.getLog().getName());
        this.getLogs().add(log.getLog());
        this.type.getLogs().add(log.getLog());
    }

    public List<LogWithContent> getPreProcessorLogs() {
        return this.preProcessorLogs;
    }

    public static Target[] getDeployableTargets(WebLogicDeploymentManager deployManager, String forApp, LocalExtensionManager manager) {
        Target[] targets = deployManager.getTargets();
        List<String> giventargets = manager.getDeployTargets(forApp);
        boolean findtarget = giventargets == null || giventargets.isEmpty();
        ArrayList<Target> list = new ArrayList<Target>();
        for (Target t : targets) {
            if (!WebLogicTarget.class.isAssignableFrom(t.getClass())) continue;
            if (findtarget) {
                if (((WebLogicTarget)t).isCluster()) {
                    list.clear();
                    list.add(t);
                    Logger.getDEFAULT().printlnDebug("Using cluster for deployment:" + t.getName());
                    break;
                }
                if (!((WebLogicTarget)t).isServer()) continue;
                list.add(t);
                continue;
            }
            if (!giventargets.contains(t.getName())) continue;
            list.add(t);
        }
        return list.toArray(new Target[0]);
    }

    public AbstractJob(String group, String service, JobManager manager, LocalExtensionManager extensionManager) {
        this.manager = manager;
        if (extensionManager == null) {
            extensionManager = new LocalExtensionManagerDefaultImpl();
        }
        this.localextension = extensionManager;
        manager.initJob(this);
        this.updateStatus(JobStatus.NEW);
        this.type.setGroupName(group);
        this.type.setInstanceName(service);
    }

    public synchronized void updateStatus(JobStatus status) {
        if (status == JobStatus.COMPLETE) {
            this.updateAction(null);
        }
        this.type.setStatus(status);
        this.type.setUpdatedOn(new Date());
    }

    public synchronized void updateAction(String action) {
        this.type.setAction(action);
        this.type.setUpdatedOn(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        AbstractJob abstractJob = this;
        synchronized (abstractJob) {
            this.updateStatus(JobStatus.SUBMITTED);
            this.manager.execute(this);
        }
    }

    public abstract String getJobName();

    public Job getJobType() {
        return this.type;
    }

    public abstract void perform() throws Exception;

    public void preProcess() throws Exception {
    }

    public void postProcess() {
    }

    private void addOperationLog() {
        this.log = new Log();
        this.log.setName(this.type.getOperation());
        this.log.setContentType("text/plain");
        this.log.setLastModified(new Date());
        this.getLogs().add(this.log);
        this.type.getLogs().add(this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.error = null;
        this.type.setStartedOn(new Date());
        this.updateStatus(JobStatus.RUNNING);
        this.type.setOperation(this.getJobName());
        boolean preprocessDone = false;
        try {
            this.preProcess();
            preprocessDone = true;
            preprocessDone = true;
            this.addOperationLog();
            this.updateAction(this.type.getOperation());
            this.perform();
            this.updateStatus(JobStatus.COMPLETE);
        }
        catch (Throwable e) {
            if (this.getLogs().isEmpty()) {
                this.addOperationLog();
            }
            Logger.getDEFAULT().printlnThrowable(e);
            this.error = e;
            this.updateStatus(JobStatus.FAILED);
        }
        finally {
            this.type.setEndedOn(new Date());
            this.manager.jobDone(this);
            if (preprocessDone) {
                this.postProcess();
            }
        }
    }

    public void waitUntilStarted() {
        while (this.type.getStatus().equals((Object)JobStatus.SUBMITTED)) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitWhileRunning() {
        while (this.type.getStatus().equals((Object)JobStatus.RUNNING)) {
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isStillRunning() {
        boolean running = this.progressObject.getDeploymentStatus().isRunning();
        Logger.getDEFAULT().printlnDebug(new Date().toString() + " -> Deployment Status-Running: " + running);
        return running;
    }

    public void waitUntilProgressObjectDone() {
        if (this.progressObject == null) {
            return;
        }
        while (this.isStillRunning()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Logger.getDEFAULT().printlnThrowable(ie);
            }
        }
    }

    public static void writeToFile(File file, InputStream is) {
        try {
            Logger.getDEFAULT().printlnDebug("Writing at:" + file.getAbsolutePath());
            CloudUtil.writeToFile(file, is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<TargetModuleID> getAllModulesWithAppId(String appId, WebLogicDeploymentManager deployManager, LocalExtensionManager localextension) throws Exception {
        ModuleType[] types;
        Logger.getDEFAULT().printlnDebug("Finding modules with id:" + appId);
        ArrayList<TargetModuleID> all = new ArrayList<TargetModuleID>();
        for (ModuleType t : types = new ModuleType[]{ModuleType.CAR, ModuleType.EAR, ModuleType.EJB, ModuleType.RAR, ModuleType.WAR}) {
            TargetModuleID[] array = deployManager.getAvailableModules(t, AbstractJob.getDeployableTargets(deployManager, appId, localextension));
            if (array == null) continue;
            for (TargetModuleID mod : array) {
                if (mod.getParentTargetModuleID() != null || !mod.getModuleID().equals(appId)) continue;
                all.add(mod);
            }
        }
        return all;
    }

    public Log getLog() {
        return this.log;
    }

    public List<Log> getLogs() {
        return this.logs;
    }
}

