/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.view;

import java.util.HashMap;
import oracle.eclipse.tools.cloud.CloudServerLogModelFactory;
import oracle.eclipse.tools.cloud.ICloudServerJobsLogModel;
import oracle.eclipse.tools.cloud.job.CloudServerModelResource;
import oracle.eclipse.tools.cloud.log.IJobsLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.JobsLogQueryCriteriaFactory;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormPart;
import org.eclipse.sapphire.ui.forms.SplitFormPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class JobsLogView
extends ViewPart
implements IPublishListener,
IServerLifecycleListener {
    public static final String ID = "oracle.eclipse.tools.cloud.ui.server.internal.view.JobsView";
    public static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    private ICloudServerJobsLogModel modelElement;
    private IServer server = null;
    private Composite parent;
    private StackLayout layout = null;
    private Composite blank = null;
    private Text filterText = null;
    private Form form = null;
    private FormToolkit toolkit = null;
    public static final ImageDescriptor IMG_REFRESH = org.eclipse.sapphire.ui.forms.swt.SwtUtil.createImageDescriptor(CloudUiPlugin.class, (String)"images/refresh.gif");
    public static final ImageDescriptor IMG_FILTER = org.eclipse.sapphire.ui.forms.swt.SwtUtil.createImageDescriptor(CloudUiPlugin.class, (String)"images/filter_ps.gif");
    private static final String TYPE_FILTER_TEXT = "type filter text";
    private HashMap<IServer, SapphireForm> serverCompMap = new HashMap();
    ISelectionListener serverSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (!(ss.getFirstElement() instanceof IServer)) {
                return;
            }
            IServer server = (IServer)ss.getFirstElement();
            if (server != null) {
                JobsLogView.this.setActiveServer(server);
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ISelectionService svc = this.getSite().getWorkbenchWindow().getSelectionService();
        svc.addPostSelectionListener(SERVERS_VIEW_ID, this.serverSelectionListener);
        svc.addPostSelectionListener("oracle.eclipse.tools.cloud.ui.CloudProfileView", this.serverSelectionListener);
    }

    public void setFocus() {
        this.filterText.setFocus();
    }

    public void createPartControl(Composite composite) {
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.form = this.toolkit.createForm(composite);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.form.setText("Java Cloud Service Jobs Log");
        this.toolkit.decorateFormHeading(this.form);
        Composite comp = this.form.getBody();
        this.addFilterTextControl(comp);
        this.parent = new Composite(comp, 0);
        GridData gd = GridLayoutUtil.gdfill();
        gd.grabExcessVerticalSpace = true;
        this.parent.setLayoutData((Object)gd);
        this.layout = new StackLayout();
        this.parent.setLayout((Layout)this.layout);
        this.blank = new Composite(this.parent, 0);
        this.blank.setBackground(SwtUtil.color((int)1));
        this.layout.topControl = this.blank;
        Action refreshAction = new Action("Refresh"){

            public void run() {
                if (JobsLogView.this.server == null) {
                    IServer[] iServerArray = ServerCore.getServers();
                    int n = iServerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IServer s = iServerArray[n2];
                        if (s.getServerState() != 4) {
                            if (s.getServerType().getId().equals("oracle.cloud.server")) {
                                JobsLogView.this.setActiveServer(s);
                            }
                            return;
                        }
                        ++n2;
                    }
                } else {
                    JobsLogView.this.refresh();
                }
            }
        };
        refreshAction.setImageDescriptor(IMG_REFRESH);
        Action changeCriteriaAction = new Action("Filter"){

            public void run() {
                JobsLogView.this.openFilterDlg();
            }
        };
        changeCriteriaAction.setImageDescriptor(IMG_FILTER);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)refreshAction);
        toolBar.add((IAction)changeCriteriaAction);
    }

    private void addFilterTextControl(Composite comp) {
        this.filterText = new Text(comp, 2048);
        this.filterText.setText(TYPE_FILTER_TEXT);
        GridData layoutData = GridLayoutUtil.gdhfill();
        layoutData.horizontalIndent = 10;
        this.filterText.setLayoutData((Object)layoutData);
        this.filterText.setSelection(0);
        this.filterText.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String text = JobsLogView.this.filterText.getText();
                if (text.equals(JobsLogView.TYPE_FILTER_TEXT)) {
                    JobsLogView.this.filterText.selectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JobsLogView.this.modelElement != null) {
                    String s = JobsLogView.this.filterText.getText();
                    try {
                        JobsLogView.this.modelElement.setFilterText(s);
                        JobsLogView.this.modelElement.refresh();
                        JobsLogView.this.autoSelectRow();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.addClearFitlerIcon();
    }

    private void autoSelectRow() {
        SapphireForm control;
        FormPart fp;
        ListSelectionService selectionService;
        if (this.modelElement.getJobs().size() > 0 && this.layout.topControl instanceof SapphireForm && (selectionService = JobsLogView.findListSelectionService((ISapphirePart)(fp = (FormPart)(control = (SapphireForm)this.layout.topControl).part()))) != null) {
            Element element = this.modelElement.getJobs().get(0);
            selectionService.select(element);
        }
    }

    static ListSelectionService findListSelectionService(ISapphirePart part) {
        ListSelectionService t;
        ListSelectionService svr = (ListSelectionService)part.service(ListSelectionService.class);
        if (svr != null) {
            return svr;
        }
        if (part instanceof FormPart) {
            FormPart fp = (FormPart)part;
            for (SapphirePart cp : fp.children().all()) {
                t = JobsLogView.findListSelectionService((ISapphirePart)cp);
                if (t == null) continue;
                return t;
            }
        }
        if (part instanceof SplitFormPart) {
            SplitFormPart sfp = (SplitFormPart)part;
            for (SapphirePart cp : sfp.children().all()) {
                t = JobsLogView.findListSelectionService((ISapphirePart)cp);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    private void addClearFitlerIcon() {
        ControlDecoration deco = new ControlDecoration((Control)this.filterText, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        deco.setDescriptionText("Clear");
        deco.setImage(image);
        deco.setShowOnlyOnFocus(true);
        deco.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JobsLogView.this.filterText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveServer(IServer server1) {
        if (this.server == server1) {
            return;
        }
        OracleCloudServer cs = (OracleCloudServer)server1.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor());
        if (cs != null) {
            if (server1 instanceof IServerWorkingCopy) {
                server1 = ((IServerWorkingCopy)server1).getOriginal();
            }
            if (this.server != null) {
                this.server.removePublishListener((IPublishListener)this);
            }
            this.server = server1;
            this.form.setText("[" + this.server.getId() + "] Java Cloud Service Jobs Log");
            this.filterText.setText("");
            HashMap<IServer, SapphireForm> hashMap = this.serverCompMap;
            synchronized (hashMap) {
                if (this.serverCompMap.get(this.server) != null) {
                    SapphireForm sapphireControl = this.serverCompMap.get(this.server);
                    this.layout.topControl = sapphireControl;
                    this.modelElement = (ICloudServerJobsLogModel)sapphireControl.element();
                    this.parent.layout();
                    this.addServerListener();
                    return;
                }
                final ICloudServerJobsLogModel logModelElement = CloudServerLogModelFactory.create((IServer)this.server);
                SapphireForm control = new SapphireForm(this.parent, (Element)logModelElement, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).form());
                control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        logModelElement.dispose();
                    }
                });
                GridData gd = GridLayoutUtil.gdfill();
                gd.grabExcessVerticalSpace = true;
                control.setLayoutData((Object)gd);
                control.setBackground(SwtUtil.color((int)6));
                this.serverCompMap.put(this.server, control);
                this.modelElement = logModelElement;
                this.layout.topControl = control;
                this.parent.layout();
                this.addServerListener();
            }
        }
    }

    private void openFilterDlg() {
        IJobsLogQueryCriteria modelElement = JobsLogQueryCriteriaFactory.getInstance();
        SapphireDialog dlg = new SapphireDialog(this.getViewSite().getShell(), (Element)modelElement, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("JobsLogFilterDlg").dialog());
        if (dlg.open() == 0) {
            try {
                modelElement.resource().save();
                this.refresh();
            }
            catch (ResourceStoreException e) {
                CloudUiPlugin.log((Exception)((Object)e));
            }
        }
    }

    private void addServerListener() {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        this.server.addPublishListener((IPublishListener)this);
    }

    public void serverRemoved(IServer server1) {
        if (server1.getId() == this.server.getId()) {
            final SapphireForm form = this.serverCompMap.remove(server1);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    form.dispose();
                    ((JobsLogView)JobsLogView.this).layout.topControl = JobsLogView.this.blank;
                    if (!JobsLogView.this.parent.isDisposed()) {
                        JobsLogView.this.parent.layout();
                    }
                }
            });
        }
    }

    public void serverChanged(IServer server1) {
        if (server1 == this.server) {
            this.refresh();
        }
    }

    public void serverAdded(IServer server) {
    }

    public void publishStarted(IServer server) {
        this.refresh();
    }

    public void publishFinished(IServer server1, IStatus status) {
        if (server1 != this.server) {
            return;
        }
        this.refresh();
    }

    public void refresh() {
        if (this.modelElement != null) {
            Job op = new Job("Refresh Cloud Jobs"){

                public IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Refresh Cloud Jobs", 10);
                    CloudServerModelResource resource = (CloudServerModelResource)JobsLogView.this.modelElement.resource();
                    resource.jcsJobs().fetch(false);
                    monitor.worked(6);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SapphireForm control = (SapphireForm)JobsLogView.this.serverCompMap.get(JobsLogView.this.server);
                            if (control.isDisposed()) {
                                return;
                            }
                            Table logTable = JobsLogView.this.findLogListTable((Composite)control);
                            if (JobsLogView.this.modelElement.disposed()) {
                                return;
                            }
                            if (JobsLogView.this.modelElement.getJobs().size() == 0) {
                                ScrolledForm form = JobsLogView.this.findDetailForm((Composite)control);
                                if (form != null) {
                                    form.setVisible(false);
                                }
                            } else if (logTable != null) {
                                logTable.select(0);
                            }
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            op.setUser(true);
            op.schedule();
        }
    }

    private Table findLogListTable(Composite parent) {
        block6: {
            if (parent != null && !parent.isDisposed()) break block6;
            return null;
        }
        try {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Table t;
                Control c = controlArray[n2];
                if (c instanceof Table) {
                    return (Table)c;
                }
                if (c instanceof Composite && (t = this.findLogListTable((Composite)c)) != null) {
                    return t;
                }
                ++n2;
            }
        }
        catch (SWTException e) {
            e.printStackTrace();
            System.out.println(parent);
        }
        return null;
    }

    private ScrolledForm findDetailForm(Composite parent) {
        block6: {
            if (parent != null && !parent.isDisposed()) break block6;
            return null;
        }
        try {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScrolledForm t;
                Control c = controlArray[n2];
                if (c instanceof ScrolledForm) {
                    return (ScrolledForm)c;
                }
                if (c instanceof Composite && (t = this.findDetailForm((Composite)c)) != null) {
                    return t;
                }
                ++n2;
            }
        }
        catch (SWTException e) {
            e.printStackTrace();
            System.out.println(parent);
        }
        return null;
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
        if (this.server != null) {
            this.server.removePublishListener((IPublishListener)this);
        }
        ISelectionService svc = this.getSite().getWorkbenchWindow().getSelectionService();
        svc.removePostSelectionListener(SERVERS_VIEW_ID, this.serverSelectionListener);
        svc.removePostSelectionListener("oracle.eclipse.tools.cloud.ui.CloudProfileView", this.serverSelectionListener);
        this.toolkit.dispose();
        super.dispose();
    }

    public static JobsLogView getFromActivePerspective() {
        IViewPart view;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        if (PlatformUI.isWorkbenchRunning() && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (view = activePage.findView(ID)) instanceof JobsLogView) {
            return (JobsLogView)view;
        }
        return null;
    }

    public static void updateJobsView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                JobsLogView jobLogView = JobsLogView.getFromActivePerspective();
                if (jobLogView != null) {
                    jobLogView.refresh();
                }
            }
        });
    }
}

