/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.view;

import java.util.HashMap;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.log.AppLogQueryCriteriaFactory;
import oracle.eclipse.tools.cloud.log.IAppLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.IServiceInstanceLogModel;
import oracle.eclipse.tools.cloud.log.ServiceInstanceLogModelFactory;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.view.JobsLogView;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public class InstanceLogView
extends ViewPart {
    public static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static final String ID = "oracle.eclipse.tools.cloud.ui.InstanceLogView";
    private Composite parent;
    private IServer server = null;
    private StackLayout layout = null;
    private Composite blank = null;
    private Form form = null;
    private FormToolkit toolkit = null;
    private Text filterText = null;
    private static final String TYPE_FILTER_TEXT = "type filter text";
    private IServiceInstanceLogModel modelElement = null;
    private HashMap<IServer, SapphireForm> serverCompMap = new HashMap();
    private IServerLifecycleListener serverLifecycleListener = null;
    ISelectionListener serverSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (!(ss.getFirstElement() instanceof IServer)) {
                return;
            }
            IServer server = (IServer)ss.getFirstElement();
            if (server != null) {
                InstanceLogView.this.setActiveServer(server);
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ISelectionService svc = this.getSite().getWorkbenchWindow().getSelectionService();
        svc.addPostSelectionListener(SERVERS_VIEW_ID, this.serverSelectionListener);
        svc.addPostSelectionListener("oracle.eclipse.tools.cloud.ui.CloudProfileView", this.serverSelectionListener);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void dispose() {
        super.dispose();
        ISelectionService svc = this.getSite().getWorkbenchWindow().getSelectionService();
        svc.removePostSelectionListener(SERVERS_VIEW_ID, this.serverSelectionListener);
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        this.serverCompMap.clear();
        this.toolkit.dispose();
    }

    public void createPartControl(Composite comp) {
        this.toolkit = new FormToolkit(comp.getDisplay());
        this.form = this.toolkit.createForm(comp);
        this.form.getBody().setLayout((Layout)SwtUtil.glayout((int)1));
        this.form.setText("Java Cloud Service Instance Log");
        this.toolkit.decorateFormHeading(this.form);
        this.addFilterTextControl();
        this.parent = new Composite(this.form.getBody(), 0);
        this.parent.setLayoutData((Object)SwtUtil.gdfill());
        this.layout = new StackLayout();
        this.parent.setLayout((Layout)this.layout);
        this.blank = new Composite(this.parent, 0);
        this.blank.setBackground(SwtUtil.color((int)1));
        this.layout.topControl = this.blank;
        Action refreshAction = new Action("Refresh"){

            public void run() {
                InstanceLogView.this.refresh();
            }
        };
        refreshAction.setImageDescriptor(JobsLogView.IMG_REFRESH);
        Action changeCriteriaAction = new Action("Filter"){

            public void run() {
                InstanceLogView.this.openFilterDlg();
            }
        };
        changeCriteriaAction.setImageDescriptor(JobsLogView.IMG_FILTER);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)refreshAction);
        toolBar.add((IAction)changeCriteriaAction);
    }

    private void addFilterTextControl() {
        this.filterText = new Text(this.form.getBody(), 2048);
        this.filterText.setText(TYPE_FILTER_TEXT);
        this.filterText.setVisible(false);
        GridData layoutData = SwtUtil.gdhfill();
        layoutData.horizontalIndent = 10;
        this.filterText.setLayoutData((Object)layoutData);
        this.filterText.setSelection(0);
        this.filterText.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String text = InstanceLogView.this.filterText.getText();
                if (text.equals(InstanceLogView.TYPE_FILTER_TEXT)) {
                    InstanceLogView.this.filterText.selectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InstanceLogView.this.modelElement != null) {
                    String s = InstanceLogView.this.filterText.getText();
                    try {
                        InstanceLogView.this.modelElement.setFilterText(s);
                        InstanceLogView.this.autoSelectRow();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.addClearFitlerIcon();
    }

    private void autoSelectRow() {
        SapphireForm control;
        FormPart fp;
        ListSelectionService selectionService;
        if (this.modelElement.getLogs().size() > 0 && (selectionService = JobsLogView.findListSelectionService((ISapphirePart)(fp = (FormPart)(control = (SapphireForm)this.layout.topControl).part()))) != null) {
            Element element = this.modelElement.getLogs().get(0);
            selectionService.select(element);
        }
    }

    private void addClearFitlerIcon() {
        ControlDecoration deco = new ControlDecoration((Control)this.filterText, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        deco.setDescriptionText("Clear");
        deco.setImage(image);
        deco.setShowOnlyOnFocus(true);
        deco.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InstanceLogView.this.filterText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveServer(IServer server1) {
        OracleCloudServer cs = (OracleCloudServer)server1.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor());
        if (cs != null) {
            if (this.form.isDisposed()) {
                return;
            }
            this.server = server1;
            this.form.setText("[" + this.server.getId() + "] Java Cloud Service Instance Log");
            this.filterText.setText("");
            HashMap<IServer, SapphireForm> hashMap = this.serverCompMap;
            synchronized (hashMap) {
                if (this.serverCompMap.get(this.server) != null) {
                    SapphireForm sapphireControl = this.serverCompMap.get(this.server);
                    this.layout.topControl = sapphireControl;
                    this.modelElement = (IServiceInstanceLogModel)sapphireControl.element();
                    this.filterText.setVisible(true);
                    this.parent.layout();
                    this.refresh();
                    return;
                }
                this.modelElement = ServiceInstanceLogModelFactory.create((IServer)this.server);
                this.addServerListener();
                SapphireForm control = new SapphireForm(this.parent, (Element)this.modelElement, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).form());
                control.setLayoutData((Object)GridLayoutUtil.gdfill());
                this.serverCompMap.put(this.server, control);
                this.layout.topControl = control;
                this.filterText.setVisible(true);
                this.parent.layout();
            }
        }
    }

    private void openFilterDlg() {
        if (this.server == null) {
            String message = "No Oracle Cloud instance available.";
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)message);
            return;
        }
        IRuntime rt = this.server.getRuntime();
        try {
            OracleCloudRuntime crt = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, null);
            IAppLogQueryCriteria modelElement = AppLogQueryCriteriaFactory.getInstance((OracleCloudRuntime)crt);
            SapphireDialog dlg = new SapphireDialog(this.getViewSite().getShell(), (Element)modelElement, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("InstanceLogFilterDlg").dialog());
            if (dlg.open() == 0) {
                try {
                    modelElement.resource().save();
                    this.refresh();
                }
                catch (ResourceStoreException e) {
                    CloudUiPlugin.log((Exception)((Object)e));
                }
            }
        }
        catch (Exception e) {
            CloudPlugin.log((Exception)e);
        }
    }

    private void addServerListener() {
        this.serverLifecycleListener = new IServerLifecycleListener(){

            public void serverRemoved(IServer server1) {
                SapphireForm ctrl;
                if (server1.getId() == InstanceLogView.this.server.getId() && ((InstanceLogView)InstanceLogView.this).layout.topControl == (ctrl = (SapphireForm)InstanceLogView.this.serverCompMap.remove(server1))) {
                    ((InstanceLogView)InstanceLogView.this).layout.topControl = InstanceLogView.this.blank;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InstanceLogView.this.filterText.setVisible(false);
                            InstanceLogView.this.parent.layout();
                        }
                    });
                }
            }

            public void serverChanged(IServer server1) {
                if (server1 == InstanceLogView.this.server) {
                    InstanceLogView.this.refresh();
                }
            }

            public void serverAdded(IServer server) {
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }

    public void setFocus() {
        this.filterText.setFocus();
    }

    public void refresh() {
        IServer server1;
        OracleCloudServer cs;
        IServer[] iServerArray;
        if (this.server == null && (iServerArray = ServerCore.getServers()).length != 0 && (cs = (OracleCloudServer)(server1 = iServerArray[0]).loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            this.setActiveServer(server1);
        }
        if (this.server == null) {
            return;
        }
        if (!(this.layout.topControl instanceof SapphireForm)) {
            return;
        }
        UIJob op = new UIJob("Refresh Service Instance Logs"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("Refresh Cloud Service Instance Logs", 10);
                monitor.worked(2);
                ServiceInstanceLogModelFactory.clearAppLogCache((IServer)InstanceLogView.this.server);
                monitor.worked(6);
                if (((InstanceLogView)InstanceLogView.this).layout.topControl instanceof SapphireForm) {
                    SapphireForm control = (SapphireForm)((InstanceLogView)InstanceLogView.this).layout.topControl;
                    Element modelElement = control.element();
                    if (modelElement != null) {
                        modelElement.refresh();
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        op.schedule();
    }
}

