/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.view;

import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.ICloudJob;
import oracle.eclipse.tools.cloud.ICloudServerJobsLogModel;
import oracle.eclipse.tools.cloud.job.CloudServerModelResource;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.view.JobsLogView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class CopyActionHandler
extends SapphireActionHandler {
    public static final String WS_WPF = "wpf";
    public static final String WS_WIN32 = "win32";
    public static final String CR_LF = CopyActionHandler.isWindows() ? "\r\n" : "\n";

    protected boolean computeEnablementState() {
        ISapphirePart part = this.getPart();
        ListSelectionService listSelection = JobsLogView.findListSelectionService(part);
        if (listSelection != null) {
            List list = listSelection.selection();
            return list.size() > 0;
        }
        return false;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        ListSelectionService listSelection = JobsLogView.findListSelectionService(part);
        if (listSelection != null) {
            listSelection.attach((Listener)new FilteredListener<ListSelectionService.ListSelectionChangedEvent>(){

                protected void handleTypedEvent(ListSelectionService.ListSelectionChangedEvent event) {
                    CopyActionHandler.this.setEnabled(CopyActionHandler.this.computeEnablementState());
                }
            });
        }
    }

    protected Object run(Presentation context) {
        ListSelectionService listSelection = JobsLogView.findListSelectionService((ISapphirePart)context.part());
        if (listSelection != null) {
            final List list = listSelection.selection();
            final Display display = ((SwtPresentation)context).display();
            Job t = new Job("Retrieve Cloud job log details..."){

                protected IStatus run(IProgressMonitor monitor) {
                    final StringBuffer logText = new StringBuffer();
                    ICloudServerJobsLogModel root = (ICloudServerJobsLogModel)CopyActionHandler.this.getModelElement();
                    CloudServerModelResource resource = (CloudServerModelResource)root.resource();
                    IServer server = resource.server();
                    IRuntime rt = server.getRuntime();
                    OracleCloudRuntime crt = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, null);
                    for (Element e : list) {
                        if (!(e instanceof ICloudJob)) continue;
                        ICloudJob job = (ICloudJob)e;
                        CopyActionHandler.this.getJobLogs(job, crt, logText);
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String log = logText.toString();
                            if (log != null && log.length() > 0) {
                                Clipboard clip = new Clipboard(display);
                                Object[] data = new Object[]{log};
                                Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
                                clip.setContents(data, dataTypes);
                                clip.dispose();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            t.schedule();
        }
        return null;
    }

    private void getJobLogs(ICloudJob job, OracleCloudRuntime crt, StringBuffer logText) {
        try {
            String jobId = (String)job.getId().content();
            logText.append("Oracle Cloud Job ID=" + jobId + ", Status=" + (String)job.getStatus().content() + ", Application=" + (String)job.getApplication().content() + ", Operation=" + (String)job.getOperation().content() + CR_LF);
            if (((String)job.getStatus().content()).equals("RUNNING")) {
                return;
            }
            INuviaqDeployer deployer = crt.getNuviaqDeployer();
            Map logs = deployer.getJobLogs(jobId);
            for (String log : logs.keySet()) {
                logText.append("[" + log + "]" + CR_LF);
                String text = (String)logs.get(log);
                if (text.indexOf(CR_LF) < 0) {
                    text = text.replace("\n", CR_LF);
                }
                logText.append(String.valueOf(text) + CR_LF);
            }
        }
        catch (Exception e) {
            CloudUiPlugin.log(e);
        }
    }

    public static final boolean isWindows() {
        String ws = SWT.getPlatform();
        return WS_WIN32.equals(ws) || WS_WPF.equals(ws);
    }
}

