/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.credential;

import java.util.List;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.credential.JcsKeystoreResource;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystoreEntry;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteCertificateActionHandler
extends SapphireActionHandler {
    IKeystoreEntry selected = null;

    protected Object run(Presentation context) {
        Element model = context.part().getModelElement();
        IKeystore keystore = (IKeystore)model;
        ListSelectionService listSelection = (ListSelectionService)context.part().service(ListSelectionService.class);
        if (listSelection != null && listSelection.selection().size() > 0) {
            if (!(listSelection.selection().get(0) instanceof IKeystoreEntry)) {
                return null;
            }
            this.selected = (IKeystoreEntry)listSelection.selection().get(0);
            JcsKeystoreResource res = (JcsKeystoreResource)keystore.resource();
            CertificateService cs = res.getCertificateService();
            String alias = (String)this.selected.getName().content();
            if (alias.equals("Fetching...")) {
                return null;
            }
            try {
                String msg = String.format("Are you sure you want to delete certificate '%s' from the trust store?", this.selected.getName().content());
                if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Delete Certificate", (String)msg)) {
                    return Status.CANCEL_STATUS;
                }
                cs.deleteCertificate(alias);
                keystore.getKeystoreEntries().remove((Object)this.selected);
                keystore.getKeystoreEntries().refresh();
                return Status.OK_STATUS;
            }
            catch (ServiceException e) {
                return CloudPlugin.createErrorStatus((String)"Failed to delete certificate", (Exception)((Object)e));
            }
        }
        return null;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        final ListSelectionService listSelection = (ListSelectionService)part.service(ListSelectionService.class);
        if (listSelection != null) {
            listSelection.attach((Listener)new FilteredListener<ListSelectionService.ListSelectionChangedEvent>(){

                protected void handleTypedEvent(ListSelectionService.ListSelectionChangedEvent event) {
                    List list = listSelection.selection();
                    if (list.size() > 0 && list.get(0) instanceof IKeystoreEntry) {
                        DeleteCertificateActionHandler.this.selected = (IKeystoreEntry)list.get(0);
                    }
                }
            });
        }
    }
}

