/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.credential;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.credential.JcsKeystoreResource;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;

public class AddCertificateActionHandler
extends SapphireActionHandler {
    /*
     * Loose catch block
     */
    protected Object run(Presentation context) {
        Element model = context.part().getModelElement();
        IKeystore keystore = (IKeystore)model;
        JcsKeystoreResource res = (JcsKeystoreResource)keystore.resource();
        if (!res.certificateDescriptions.available()) {
            org.eclipse.jface.dialogs.MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Certificate service is not ready.");
            return null;
        }
        CertificateService cs = res.certificateDescriptions.getCertificateService();
        FileDialog dlg = new FileDialog(((SwtPresentation)context).shell());
        dlg.setFilterExtensions(new String[]{"*.cer", "*.jks"});
        String certPath = dlg.open();
        if (certPath == null || certPath.length() < 1) {
            return null;
        }
        File certFile = new File(certPath);
        FileInputStream fis = null;
        fis = new FileInputStream(certFile);
        String alias = certFile.getName();
        if (alias.lastIndexOf(46) > 0) {
            alias = alias.substring(0, alias.lastIndexOf(46));
        }
        cs.addCertificate((InputStream)fis, alias);
        res.certificateDescriptions.fetch(false);
        model.refresh();
        keystore.getKeystoreEntries().refresh();
        IStatus iStatus = Status.OK_STATUS;
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {}
        return iStatus;
        catch (FileNotFoundException e) {
            IStatus iStatus2 = CloudPlugin.createErrorStatus((String)"Certificate file not found", (Exception)e);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            return iStatus2;
        }
        catch (ServiceException e2) {
            IStatus status = CloudPlugin.createErrorStatus((String)e2.getMessage(), (Exception)new Exception(e2.getResponse().getLog()));
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Failed to add certificate", (IStatus)status, (int)4);
            IStatus iStatus3 = status;
            {
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            return iStatus3;
        }
    }
}

