/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.cnf.datasources;

import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.java.JavaServiceDataSource;
import oracle.eclipse.tools.cloud.java.JavaServiceDataSources;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.datasources.DataSourcesContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class CloudDataSourceContentProvider
extends DataSourcesContentProvider {
    private CommonViewer viewer;
    private Listener dataSourceFetcherListener = new FilteredListener<RemoteData.ContentEvent>(){

        protected void handleTypedEvent(RemoteData.ContentEvent event) {
            final JavaServiceDataSources datasources = (JavaServiceDataSources)event.data();
            CloudDataSourceContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudDataSourceContentProvider.this.viewer.refresh((Object)datasources);
                }
            });
        }
    };

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{inputElement};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            IServer server = (IServer)parentElement;
            if (server.getServerState() != 4) {
                if (server.getServerState() != 2 && server.getServerState() != 1) {
                    return new Object[0];
                }
                OracleCloudRuntime crt = (OracleCloudRuntime)server.getRuntime().getAdapter(OracleCloudRuntime.class);
                if (crt != null) {
                    return new Object[]{crt.getDataSourceRoot()};
                }
            }
        } else if (parentElement instanceof JavaServiceDataSources) {
            JavaServiceDataSources datasources = (JavaServiceDataSources)parentElement;
            if (datasources.available()) {
                return ((List)datasources.content()).toArray();
            }
            datasources.attach(this.dataSourceFetcherListener);
            datasources.fetch(true, null);
            return new Object[]{FetchingRemoteDataNode.INSTANCE};
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof JavaServiceDataSource) {
            JavaServiceDataSource m = (JavaServiceDataSource)element;
            return m.getParent();
        }
        if (element instanceof JavaServiceDataSources) {
            JavaServiceDataSources root = (JavaServiceDataSources)element;
            return root.getServer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof JavaServiceDataSources;
    }

    public void dispose() {
        if (this.dataSourceFetcherListener != null) {
            IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
            int n = iRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime rt = iRuntimeArray[n2];
                OracleCloudRuntime crt = (OracleCloudRuntime)rt.getAdapter(OracleCloudRuntime.class);
                if (crt != null) {
                    crt.getDataSourceRoot().detach(this.dataSourceFetcherListener);
                }
                ++n2;
            }
        }
    }
}

