/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.actions;

import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.view.InstanceLogView;
import oracle.eclipse.tools.cloud.ui.server.internal.view.JobsLogView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;

public class ServerActionHandler
extends AbstractHandler {
    private OracleCloudServer cloudServer = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id = event.getCommand().getId();
        if (id.endsWith("openApplicationLogsView")) {
            this.openLogsView(event);
        } else if (id.endsWith("openJobLogsView")) {
            this.openJobsView(event);
        }
        return null;
    }

    private void openLogsView(ExecutionEvent event) {
        if (this.cloudServer != null && this.cloudServer.getServer().getServerState() != 4) {
            try {
                IServer server = this.cloudServer.getServer();
                IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
                IViewPart view = page.showView("oracle.eclipse.tools.cloud.ui.InstanceLogView", null, 2);
                if (view != null && view instanceof InstanceLogView) {
                    InstanceLogView appLogView = (InstanceLogView)view;
                    appLogView.setActiveServer(server);
                    page.activate((IWorkbenchPart)appLogView);
                }
            }
            catch (Exception e) {
                CloudUiPlugin.log(e);
            }
        }
    }

    private void openJobsView(ExecutionEvent event) {
        if (this.cloudServer != null && this.cloudServer.getServer().getServerState() != 4) {
            try {
                IServer server = this.cloudServer.getServer();
                IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
                IViewPart view = page.showView("oracle.eclipse.tools.cloud.ui.server.internal.view.JobsView", null, 2);
                if (view != null && view instanceof JobsLogView) {
                    JobsLogView jobsView = (JobsLogView)view;
                    jobsView.setActiveServer(server);
                    page.activate((IWorkbenchPart)jobsView);
                }
            }
            catch (Exception e) {
                CloudUiPlugin.log(e);
            }
        }
    }

    public void setEnabled(Object obj) {
        Object firstObj;
        IStructuredSelection ts;
        IEvaluationContext evaluationContext;
        Object o;
        super.setEnabled(obj);
        if (obj instanceof IEvaluationContext && (o = (evaluationContext = (IEvaluationContext)obj).getVariable("selection")) instanceof IStructuredSelection && (ts = (IStructuredSelection)o).size() == 1 && (firstObj = ts.getFirstElement()) instanceof IServer) {
            IServer server = (IServer)firstObj;
            this.cloudServer = (OracleCloudServer)server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor());
        }
        this.setBaseEnabled(this.cloudServer != null);
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }
}

