/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.LibraryType;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibraries;
import oracle.eclipse.tools.cloud.ui.server.internal.view.JobsLogView;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModuleConfigDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class InstallShareLibActionHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection ts;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (ts = (StructuredSelection)selection).getFirstElement() instanceof CloudSharedLibraries) {
            final CloudSharedLibraries shareLibRoot = (CloudSharedLibraries)ts.getFirstElement();
            Shell shell = Display.getDefault().getActiveShell();
            CloudLibraryModuleConfigDialog dialog = new CloudLibraryModuleConfigDialog(shell, false);
            if (dialog.open() == 1) {
                return null;
            }
            final boolean[] redeployLib = new boolean[1];
            LibraryModule libmodule = dialog.getLibraryModule();
            if (libmodule != null) {
                try {
                    IServer server = shareLibRoot.server();
                    IRuntime rt = server.getRuntime();
                    OracleCloudRuntime crt = (OracleCloudRuntime)rt.getAdapter(OracleCloudRuntime.class);
                    final INuviaqDeployer deployer = crt.getNuviaqDeployer();
                    File libFile = libmodule.getLocation();
                    final FileInputStream libraryArchive = new FileInputStream(libFile);
                    Version specVer = libmodule.getSpecificationVersion();
                    Version implVer = libmodule.getImplementationVersion();
                    final Library library = new Library(crt.getTenantName(), crt.getServiceName(), libmodule.getName(), specVer != null ? specVer.toString() : null, implVer != null ? implVer.toString() : null, this.getLibType(libmodule.getType()));
                    try {
                        Map map = deployer.listLibraries();
                        for (String key : map.keySet()) {
                            Library lib = (Library)map.get(key);
                            if (!lib.getName().equals(libmodule.getName()) || !ObjectUtil.equal((Object)lib.getSpecVersion(), (Object)(specVer == null ? null : specVer.toString())) || !ObjectUtil.equal((Object)lib.getImplVersion(), (Object)(implVer == null ? null : implVer.toString()))) continue;
                            boolean ret = org.eclipse.jface.dialogs.MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Resources.confirm, (String)Resources.bind((String)Resources.alreadyRegistered, (Object)key));
                            if (!ret) {
                                return null;
                            }
                            redeployLib[0] = true;
                        }
                    }
                    catch (Exception exception) {}
                    String jobName = "Publishing shared library...";
                    Job deployJob = new Job(jobName){

                        protected IStatus run(IProgressMonitor monitor) {
                            block12: {
                                monitor.beginTask(Resources.publishingSharedLibrary, -1);
                                try {
                                    try {
                                        IStatus sts = null;
                                        sts = redeployLib[0] ? deployer.redeployLibrary(library, (InputStream)libraryArchive, monitor) : deployer.installLibrary(library, (InputStream)libraryArchive, monitor);
                                        if (!sts.isOK()) {
                                            throw new InvocationTargetException(sts.getException());
                                        }
                                        shareLibRoot.fetch(false, monitor);
                                        JobsLogView.updateJobsView();
                                    }
                                    catch (Exception exception) {
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Resources.publishLibraryFailed);
                                            }
                                        });
                                        try {
                                            libraryArchive.close();
                                        }
                                        catch (IOException iOException) {}
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        libraryArchive.close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    libraryArchive.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    deployJob.setUser(true);
                    deployJob.schedule();
                    JobsLogView.updateJobsView();
                    return Status.OK_STATUS;
                }
                catch (FileNotFoundException e) {
                    return CloudPlugin.createErrorStatus((String)Resources.libraryFileError, (Exception)e);
                }
                catch (Exception e) {
                    IStatus status = CloudPlugin.createErrorStatus((String)e.getMessage(), (Exception)e);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Resources.error, (String)Resources.libraryInstallError, (IStatus)status, (int)4);
                    return status;
                }
            }
        }
        return null;
    }

    private LibraryType getLibType(LibraryModule.Type type) {
        if (type == LibraryModule.Type.EAR) {
            return LibraryType.EAR;
        }
        if (type == LibraryModule.Type.WAR) {
            return LibraryType.WAR;
        }
        return LibraryType.JAR;
    }

    public class CloudLibraryModuleConfigDialog
    extends LibraryModuleConfigDialog {
        public static final char UNDERSCORE = '_';
        public static final char HYPHEN = '-';
        public static final char PERIOD = '.';

        public CloudLibraryModuleConfigDialog(Shell shell, boolean webOnly) {
            super(shell, null, webOnly);
        }

        protected void updateButtonEnablement() {
            boolean enabled = false;
            LibraryModule libmodule = this.getLibraryModule();
            if (libmodule != null) {
                String name = libmodule.getName();
                if (this.isValid(name)) {
                    enabled = true;
                } else {
                    this.displayMessage(Resources.libraryNameError);
                }
                if (enabled) {
                    boolean validSpec;
                    Version specVer = libmodule.getSpecificationVersion();
                    Version implVer = libmodule.getImplementationVersion();
                    if (specVer == null || implVer == null) {
                        enabled = false;
                        this.displayMessage(Resources.versionError);
                    }
                    if (enabled && specVer != null && !(validSpec = specVer.toString().matches("[0-9]+(\\.[0-9]+)*"))) {
                        enabled = false;
                        this.displayMessage(Resources.bind((String)Resources.validVersionError, (Object)specVer.toString()));
                    }
                    if (enabled && implVer != null && !(validSpec = implVer.toString().matches("[0-9]+(\\.[0-9]+)*"))) {
                        enabled = false;
                        this.displayMessage(Resources.bind((String)Resources.validVersionError, (Object)implVer.toString()));
                    }
                }
            }
            this.setOkButtonEnabled(enabled);
        }

        private boolean isValid(String name) {
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c) && '_' != c && '-' != c && '.' != c) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    private static final class Resources
    extends NLS {
        public static String confirm;
        public static String alreadyRegistered;
        public static String publishingSharedLibrary;
        public static String error;
        public static String libraryFileError;
        public static String libraryInstallError;
        public static String publishLibraryFailed;
        public static String libraryNameError;
        public static String versionError;
        public static String validVersionError;

        static {
            Resources.initializeMessages((String)InstallShareLibActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

