/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal;

import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public abstract class OracleCloudBaseWizardFragment
extends WizardFragment {
    private Element model;
    private IWizardHandle wizard;

    public OracleCloudBaseWizardFragment() {
        this.setComplete(false);
    }

    public final boolean hasComposite() {
        return true;
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.setComplete(false);
    }

    protected abstract String getTitle();

    protected abstract String getDescription();

    protected abstract ImageDescriptor getImageDescriptor();

    protected abstract Element getModel();

    protected abstract String getUserInterfaceDef();

    protected abstract String getInitialFocus();

    public final Composite createComposite(Composite parent, IWizardHandle handle) {
        this.model = this.getModel();
        this.model.attach((Listener)new FilteredListener<PropertyValidationEvent>(){

            protected void handleTypedEvent(PropertyValidationEvent event) {
                OracleCloudBaseWizardFragment.this.refreshStatus();
            }
        }, "*");
        this.wizard = handle;
        this.wizard.setTitle(this.getTitle());
        this.wizard.setDescription(this.getDescription());
        this.wizard.setImageDescriptor(this.getImageDescriptor());
        SapphireForm control = new SapphireForm(parent, this.model, DefinitionLoader.context(CloudUiPlugin.class).sdef("oracle.eclipse.tools.cloud.ui.OracleCloudTools").form(this.getUserInterfaceDef()));
        control.setLayoutData((Object)SwtUtil.gdfill());
        control.part().setFocus(this.getInitialFocus());
        this.refreshStatus();
        return control;
    }

    private void refreshStatus() {
        Status status = this.model.validation();
        if (status.severity() == Status.Severity.ERROR) {
            this.wizard.setMessage(status.message(), 3);
            this.setComplete(false);
        } else if (status.severity() == Status.Severity.WARNING) {
            this.wizard.setMessage(status.message(), 2);
            this.setComplete(true);
        } else {
            this.wizard.setMessage(null, 0);
            this.setComplete(true);
        }
        this.wizard.update();
    }

    protected void setError(String msg) {
        this.wizard.setMessage(msg, 3);
        this.setComplete(msg == null);
    }
}

