/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.modules.CloudJavaEEModule;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibrary;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class OpenInBrowserActionDelegate
implements IViewActionDelegate {
    oracle.eclipse.tools.cloud.ui.dev.action.OpenInBrowserActionDelegate devCloudBrowserAction = new oracle.eclipse.tools.cloud.ui.dev.action.OpenInBrowserActionDelegate();
    Object element = null;
    TreePath path = null;
    IViewPart view = null;

    public void run(IAction action) {
        if (this.element != null) {
            String url = null;
            if (this.element instanceof CloudConnection) {
                CloudConnection conn = (CloudConnection)this.element;
                ICloudProfile profile = conn.profile();
                url = (String)profile.getCloudPortalUrl().content();
            }
            if (this.element instanceof ServiceDesc) {
                ServiceDesc servDesc = (ServiceDesc)this.element;
                ((CloudProfileView)this.view).refresh(servDesc);
                url = servDesc.getUrl();
            }
            if (this.element instanceof IServer) {
                CloudConnection connection;
                ServiceDesc sd;
                IServer server = (IServer)this.element;
                if (this.path != null && (sd = (connection = (CloudConnection)this.path.getSegment(this.path.getSegmentCount() - 2)).services().getServiceDesc(server)) != null) {
                    url = sd.getUrl();
                }
            }
            if (this.element instanceof JavaEEModule) {
                JavaEEModule module = (JavaEEModule)this.element;
                url = this.getPublishedModuleUrl((PublishedModule)module);
            }
            if (this.element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)this.element;
                IModule[] m = ms.getModule();
                IServer s = ms.getServer();
                if (m != null && m.length > 0) {
                    url = OpenInBrowserActionDelegate.getModuleRootURL(s, m);
                }
            }
            if (url == null) {
                this.devCloudBrowserAction.open(this.element);
                return;
            }
            try {
                CloudUiPlugin.openURL(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSelection(Object obj) {
        this.element = obj;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection ts = null;
        ts = (TreeSelection)selection;
        if (ts.size() > 1) {
            action.setEnabled(false);
            return;
        }
        if (ts.getPaths().length > 0) {
            this.path = ts.getPaths()[0];
        }
        this.element = ts.getFirstElement();
        action.setText("Open in Browser");
        if (this.element instanceof CloudConnection) {
            action.setText("Open Cloud Portal");
        } else if (this.element instanceof IServer) {
            action.setText("Open Java Cloud Service Control");
        } else {
            if (this.element instanceof ServiceDesc) {
                ServiceDesc sd = (ServiceDesc)this.element;
                if (sd.getType() == ServiceDesc.TYPE.DB) {
                    action.setText("Open Application Express");
                } else if (sd.getType() == ServiceDesc.TYPE.JCS) {
                    action.setText("Open Java Cloud Service Control");
                }
                action.setEnabled(true);
                return;
            }
            if (this.element instanceof IServerModule) {
                action.setEnabled(true);
                return;
            }
            if (this.element instanceof CloudSharedLibrary) {
                action.setEnabled(false);
                return;
            }
            if (this.element instanceof IServer || this.element instanceof JavaEEModule) {
                action.setEnabled(true);
                return;
            }
            if (this.element instanceof ResourceFacade) {
                action.setEnabled(false);
                return;
            }
            action.setEnabled(this.devCloudBrowserAction.canOpen(this.element));
        }
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    String getPublishedModuleUrl(PublishedModule m) {
        if (m instanceof CloudJavaEEModule) {
            IServer server = m.server();
            IRuntime rt = server.getRuntime();
            OracleCloudRuntime runtime = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            try {
                INuviaqDeployer deployer = runtime.getNuviaqDeployer();
                HashMap map = deployer.describeApplication(runtime.getTenantName(), runtime.getServiceName(), m.label());
                for (Object key : map.keySet()) {
                    List urlList;
                    Object val = map.get(key);
                    if (!key.equals("URLs") || !(val instanceof List) || (urlList = (List)val).size() <= 0) continue;
                    return urlList.get(0).toString();
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static String getModuleRootURL(IServer server, IModule[] m) {
        try {
            IModule root = m[0];
            IModule module = m.length > 1 ? m[1] : m[0];
            IRuntime runtime = server.getRuntime();
            OracleCloudRuntime cloudRuntime = (OracleCloudRuntime)runtime.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            INuviaqDeployer deployer = cloudRuntime.getNuviaqDeployer();
            List urls = Collections.emptyList();
            try {
                HashMap map = deployer.describeApplication(cloudRuntime.getTenantName(), cloudRuntime.getServiceName(), root.getName());
                urls = (List)map.get("URLs");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (urls.size() > 0) {
                J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(module.getProject());
                String webContextRoot = deployable.getContextRoot();
                for (String webUrl : urls) {
                    if (!webUrl.endsWith(webContextRoot)) continue;
                    return webUrl;
                }
                return (String)urls.get(0);
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

