/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.OPCPortalServiceClient;
import oracle.eclipse.tools.cloud.ui.internal.UnsupportedVersionDialog;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class NewCloudProfileWizard
extends SapphireWizard<ICloudProfile>
implements INewWizard {
    ICloudProfile newProfile;

    public NewCloudProfileWizard() {
        this.newProfile = CloudProfileUtils.newProfile();
        this.init((Element)this.newProfile, DefinitionLoader.sdef(NewCloudProfileWizard.class).wizard("NewCloudProfileWizard"));
    }

    public NewCloudProfileWizard(ICloudProfile element) {
        super((Element)element, DefinitionLoader.sdef(NewCloudProfileWizard.class).wizard("NewCloudProfileWizard"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected org.eclipse.sapphire.modeling.Status performFinish(ProgressMonitor monitor) {
        if (!OracleCloudTools.isDebugMode()) {
            monitor.beginTask("Connecting to Oracle Cloud...", 300);
            OPCPortalServiceClient client = new OPCPortalServiceClient((ICloudProfile)this.element());
            org.eclipse.sapphire.modeling.Status sts = client.validate(ProgressMonitorBridge.create((ProgressMonitor)monitor));
            if (!sts.ok()) {
                return sts;
            }
        }
        return super.performFinish(monitor);
    }

    protected void performPostFinish() {
        super.performPostFinish();
        final String newProfileId = (String)((ICloudProfile)this.element()).getId().content();
        UIJob refreshJob = new UIJob("Refresh Cloud connection"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                CloudProfileView cloudView = (CloudProfileView)page.findView("oracle.eclipse.tools.cloud.ui.CloudProfileView");
                if (cloudView != null) {
                    cloudView.refresh();
                    Object[] expanded = cloudView.getCommonViewer().getExpandedElements();
                    Object[] newExpanded = new Object[expanded.length + 1];
                    int i = 0;
                    while (i < expanded.length) {
                        newExpanded[i] = expanded[i];
                        ++i;
                    }
                    newExpanded[expanded.length] = OracleCloudTools.connection((String)newProfileId);
                    cloudView.setExpandedElements(newExpanded);
                } else {
                    try {
                        page.showView("oracle.eclipse.tools.cloud.ui.CloudProfileView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule(500L);
    }

    protected boolean handleFinishFailure(org.eclipse.sapphire.modeling.Status status) {
        if ("Oracle.Cloud.UnsupportedVersion".equals(status.type())) {
            UnsupportedVersionDialog.open((ICloudProfile)this.element());
            return false;
        }
        return super.handleFinishFailure(status);
    }

    public void dispose() {
        super.dispose();
        if (this.newProfile != null) {
            this.newProfile.dispose();
        }
    }
}

