/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class DeactivateServerAction
extends SelectionProviderAction {
    public DeactivateServerAction(TreeViewer viewer, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        IServer[] servers = this.getAcceptedServers(sel);
        if (servers != null && servers.length > 0) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private IServer[] getAcceptedServers(IStructuredSelection sel) {
        ArrayList<IServer> l = new ArrayList<IServer>();
        Iterator i = sel.iterator();
        Object o = null;
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof IServer)) {
                return null;
            }
            if (((IServer)o).isReadOnly()) continue;
            l.add(o);
        }
        return l.toArray(new IServer[l.size()]);
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (!sel.isEmpty()) {
            String message = "Are you sure you want to remove the Java Cloud Server from workspace?";
            if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)message)) {
                return;
            }
            IServer[] selAsServers = this.getAcceptedServers(sel);
            this.deleteServers(selAsServers);
        }
    }

    protected void deleteServers(final IServer[] servers) {
        Thread t = new Thread("Delete servers"){

            @Override
            public void run() {
                Job job = new Job(Messages.deleteServerTask){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (servers.length == 0) {
                            return Status.OK_STATUS;
                        }
                        try {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            int size = servers.length;
                            int i = 0;
                            while (i < size) {
                                servers[i].delete();
                                ++i;
                            }
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                        catch (Exception e) {
                            if (Trace.SEVERE) {
                                Trace.trace((String)"/severe", (String)"Error while deleting resources", (Throwable)e);
                            }
                            return new Status(4, "org.eclipse.wst.server.ui", 0, e.getMessage(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                int size = servers.length;
                ISchedulingRule[] rules = new ISchedulingRule[size + 1];
                int i = 0;
                while (i < size) {
                    rules[i] = servers[i];
                    ++i;
                }
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                rules[size] = ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
                job.setRule(MultiRule.combine((ISchedulingRule[])rules));
                job.setPriority(40);
                job.schedule();
            }
        };
        t.setDaemon(true);
        t.start();
    }
}

