/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.action.ImportProjectActionDelegate;
import oracle.eclipse.tools.cloud.ui.dev.action.OpenHandler;
import oracle.eclipse.tools.cloud.ui.dev.view.DevCloudUiUtil;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemOpenActionHandler;
import oracle.eclipse.tools.cloud.ui.profile.ActivateActionDelegate;
import oracle.eclipse.tools.cloud.ui.profile.OpenInBrowserActionDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;

public class CloudViewerDoubleClickHandler
implements IDoubleClickListener {
    private CommonViewer tableViewer;
    private OpenInBrowserActionDelegate openBrowserAction;

    public CloudViewerDoubleClickHandler(CommonViewer tableViewer, OpenInBrowserActionDelegate openBrowserAction2) {
        this.tableViewer = tableViewer;
        this.openBrowserAction = openBrowserAction2;
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeSelection sel = (TreeSelection)event.getSelection();
        Object element = sel.getFirstElement();
        if (element instanceof ServiceDesc) {
            final ServiceDesc sd = (ServiceDesc)element;
            if (sd.getType() == ServiceDesc.TYPE.DB) {
                this.openBrowserAction.setSelection(element);
                this.openBrowserAction.run(null);
                this.tableViewer.refresh((Object)sd);
            } else if (sd.getType() == ServiceDesc.TYPE.JCS) {
                final IServer serverCreated = ActivateActionDelegate.activate(sd);
                this.tableViewer.refresh((Object)sd.connection());
                UIJob expandNodeJob = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        CloudViewerDoubleClickHandler.this.tableViewer.refresh((Object)serverCreated);
                        CloudViewerDoubleClickHandler.this.tableViewer.setExpandedElements(new Object[]{sd.connection(), serverCreated});
                        return Status.OK_STATUS;
                    }
                };
                expandNodeJob.schedule(1000L);
            } else if (sd.getType() == ServiceDesc.TYPE.DCS) {
                sd.setActivated(true);
                this.tableViewer.refresh((Object)sd.connection());
            }
        } else if (element instanceof CloudProject) {
            CloudProject cp = (CloudProject)element;
            if (!cp.isActivated()) {
                cp.setActivated(true);
                cp.projectServices().fetch(false);
                this.tableViewer.refresh((Object)cp);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)cp));
                this.tableViewer.setExpandedState((Object)cp, true);
            }
        } else if (element instanceof CloudProjectService) {
            CloudProjectService cps = (CloudProjectService)element;
            ServiceType type = cps.getProjectService().getServiceType();
            if (type == ServiceType.WIKI || type == ServiceType.REVIEWS || type == ServiceType.DEPLOYMENT) {
                this.openBrowserAction.setSelection(element);
                this.openBrowserAction.run(null);
            } else {
                if (cps instanceof BuildService) {
                    if (DevCloudCore.findBuildServer((BuildService)((BuildService)cps)) == null) {
                        cps.setActivated(true);
                        DevCloudCore.createBuildServer((CloudProjectService)cps);
                        this.tableViewer.setExpandedState((Object)cps, true);
                    }
                } else if (cps instanceof TaskService) {
                    TaskService ts = (TaskService)cps;
                    ts.setActivated(true);
                }
                this.tableViewer.refresh((Object)cps);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)cps));
            }
        } else if (element instanceof GitRepoNode) {
            GitRepoNode gitRepo = (GitRepoNode)element;
            CloudRepositoryNode gitLocal = gitRepo.getRepositoryNode();
            if (gitLocal == null) {
                try {
                    DevCloudUiUtil.cloneGitRepo(gitRepo);
                }
                catch (Exception e) {
                    CloudUiPlugin.log(e);
                    CloudUiPlugin.promptError("Error cloning Git repository.");
                    return;
                }
            }
        } else if (element instanceof SolutionNode) {
            SolutionNode node = (SolutionNode)element;
            ImportProjectActionDelegate.importProject(node);
            this.tableViewer.refresh((Object)node.getCloudProjSolution());
        } else if (element instanceof BuiltInQuery) {
            BuiltInQuery bq = (BuiltInQuery)element;
            if (!bq.isActivated()) {
                bq.setActivated(true);
                this.tableViewer.refresh((Object)bq.getTaskService());
            }
        } else if (element instanceof ITask) {
            TasksUiInternal.openTaskInBackground((ITask)((ITask)element), (boolean)true);
        } else if (element instanceof IBuildElement) {
            IBuildElement build = (IBuildElement)element;
            OpenHandler.openBuildEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), build);
        } else if (element instanceof JavaServiceFile) {
            JavaServiceFileSystemOpenActionHandler.openCloudFile((JavaServiceFile)element);
        } else if (element instanceof IFile) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)element));
            }
            catch (PartInitException e) {
                CloudUiPlugin.log((Exception)((Object)e));
            }
        }
    }
}

