/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudServices;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

public class CloudProfileViewContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    public static final int TIMEOUT = 60;
    public static Object INITIALIZING = new Object();
    private CommonViewer viewer;
    private Listener cloudConnectionServicesListener;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public Object[] getElements(Object element) {
        List connections;
        if (element == CloudProfileView.ROOT_NODE && !(connections = OracleCloudTools.connections()).isEmpty()) {
            if (this.cloudConnectionServicesListener == null) {
                this.cloudConnectionServicesListener = new FilteredListener<RemoteData.ContentEvent>(){

                    protected void handleTypedEvent(RemoteData.ContentEvent event) {
                        final CloudConnection connection = ((CloudServices)event.data()).connection();
                        CloudProfileViewContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CloudProfileViewContentProvider.this.viewer.refresh((Object)connection);
                            }
                        });
                    }
                };
            }
            for (CloudConnection connection : connections) {
                connection.services().attach(this.cloudConnectionServicesListener);
            }
            return connections.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CloudConnection) {
            CloudConnection cn = (CloudConnection)element;
            CloudServices services = cn.services();
            if (services.available()) {
                Object[] children = ((List)services.content()).toArray();
                int i = 0;
                int n = children.length;
                while (i < n) {
                    IServer server;
                    Object service = children[i];
                    if (service instanceof JavaServiceDesc && (server = ((JavaServiceDesc)service).server()) != null) {
                        children[i] = server;
                    }
                    ++i;
                }
                return children;
            }
            services.fetch(true, null);
            return new Object[]{FetchingRemoteDataNode.INSTANCE};
        }
        if (element instanceof IServer) {
            return null;
        }
        return Collections.emptyList().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof CloudConnection) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        if (element instanceof ServiceDesc) {
            return ((ServiceDesc)element).connection();
        }
        if (element instanceof IServer) {
            return OracleCloudTools.connection((IServer)((IServer)element));
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ServiceDesc) {
            return false;
        }
        return !(element instanceof FetchingRemoteDataNode);
    }

    public void dispose() {
        if (this.cloudConnectionServicesListener != null) {
            for (CloudConnection connection : OracleCloudTools.connections()) {
                connection.services().detach(this.cloudConnectionServicesListener);
            }
            this.cloudConnectionServicesListener = null;
        }
        super.dispose();
    }
}

