/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.ArrayList;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.profile.CloudViewPropertySourceProvider;
import oracle.eclipse.tools.cloud.ui.profile.CloudViewerDoubleClickHandler;
import oracle.eclipse.tools.cloud.ui.profile.CloudViewerSorter;
import oracle.eclipse.tools.cloud.ui.profile.NewCloudProfileWizard;
import oracle.eclipse.tools.cloud.ui.profile.OpenInBrowserActionDelegate;
import oracle.eclipse.tools.common.ui.util.otn.BrowserLauncher;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;

public class CloudProfileView
extends CommonNavigator {
    public static final String ID = "oracle.eclipse.tools.cloud.ui.CloudProfileView";
    private static final String CLOUD_VIEW_CONTEXT = "org.eclipse.ui.cloudViewScope";
    public static final Object ROOT_NODE = new Object();
    protected CommonViewer tableViewer;
    private Control mainPage;
    private Control noServersPage;
    private PageBook book;
    private OpenInBrowserActionDelegate openBrowserAction = new OpenInBrowserActionDelegate();
    private IServerLifecycleListener serverListener = null;
    private IPublishListener publishListener = null;
    private IServerListener serverStateListener = null;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.book = new PageBook(parent, 0);
        super.createPartControl((Composite)this.book);
        this.mainPage = this.getCommonViewer().getControl();
        this.noServersPage = this.createDefaultPage(toolkit);
        this.book.showPage(this.noServersPage);
        CommonViewer viewer = this.getCommonViewer();
        this.openBrowserAction.init((IViewPart)this);
        CloudViewerDoubleClickHandler dbclkHandler = new CloudViewerDoubleClickHandler(viewer, this.openBrowserAction);
        viewer.addDoubleClickListener((IDoubleClickListener)dbclkHandler);
        viewer.setSorter((ViewerSorter)new CloudViewerSorter());
        this.activateContextService();
        this.deferInitialization();
        this.addServerListener();
    }

    public void setFocus() {
        this.activateContextService();
    }

    private void activateContextService() {
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        contextSupport.activateContext(CLOUD_VIEW_CONTEXT);
    }

    public void monitorServer(IServer server) {
        server.addPublishListener(this.publishListener);
        server.addServerListener(this.serverStateListener);
    }

    private void addServerListener() {
        this.serverListener = new IServerLifecycleListener(){

            public void serverRemoved(IServer server) {
                this.refreshCloudView(server);
                server.removePublishListener(CloudProfileView.this.publishListener);
            }

            public void serverChanged(IServer server) {
            }

            public void serverAdded(IServer server) {
                this.refreshCloudView(server);
                if (server.getServerType().getId().equals("oracle.cloud.server")) {
                    CloudProfileView.this.monitorServer(server);
                }
            }

            void refreshCloudView(final IServer server) {
                if (server.getServerType().getId().equals("oracle.cloud.server")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CloudConnection connection = OracleCloudTools.connection((IServer)server);
                            CloudProfileView.this.refresh(connection);
                        }
                    });
                }
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        this.publishListener = new IPublishListener(){

            public void publishStarted(IServer server) {
            }

            public void publishFinished(IServer server, IStatus status) {
                CloudProfileView.this.refresh(server);
            }
        };
        this.serverStateListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                IServer server = event.getServer();
                CloudConnection connection = OracleCloudTools.connection((IServer)server);
                if (connection != null) {
                    ICloudProfile profile = connection.profile();
                    if (server.getServerState() == 2) {
                        profile.setConnectionState(ConnectionState.CONNECTED);
                    } else if (server.getServerState() == 4) {
                        profile.setConnectionState(ConnectionState.DISCONNECTED);
                    }
                    CloudProfileView.this.update(connection);
                }
            }
        };
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getServerType() != null && server.getServerType().getId().equals("oracle.cloud.server")) {
                this.monitorServer(server);
            }
            ++n2;
        }
    }

    public void dispose() {
        super.dispose();
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            server.removePublishListener(this.publishListener);
            server.removeServerListener(this.serverStateListener);
            ++n2;
        }
    }

    private void newDevCloudProfile() {
        NewCloudProfileWizard wzd = new NewCloudProfileWizard();
        WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wzd);
        if (dlg.open() == 0) {
            this.refresh();
            this.setExpandedElements(new Object[]{wzd.element()});
        }
    }

    public CommonViewer getViewer() {
        return this.tableViewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new CloudViewPropertySourceProvider(page));
            return page;
        }
        return super.getAdapter(adapter);
    }

    private Control createDefaultPage(FormToolkit kit) {
        Form form = kit.createForm((Composite)this.book);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        body.setLayout((Layout)layout);
        Link connectLink = new Link(body, 0);
        connectLink.setText("<a>Connect</a>");
        connectLink.setBackground(this.book.getDisplay().getSystemColor(25));
        connectLink.setLayoutData((Object)new GridData(16384, 4, true, false));
        connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudProfileView.this.newDevCloudProfile();
            }
        });
        Link openAccountLink = new Link(body, 0);
        openAccountLink.setText("<a>Open an account</a>");
        openAccountLink.setBackground(this.book.getDisplay().getSystemColor(25));
        openAccountLink.setLayoutData((Object)new GridData(16384, 4, true, false));
        openAccountLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    BrowserLauncher.displayURL((String)"https://cloud.oracle.com");
                }
                catch (Exception e) {
                    CloudUiPlugin.log(e);
                }
            }
        });
        return form;
    }

    public void refresh() {
        if (this.noServersPage.isVisible()) {
            this.tableViewer.setInput(ROOT_NODE);
        }
        this.tableViewer.refresh();
        this.toggleDefultPage();
    }

    public static void updateViews(final Object node) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CommonNavigator serversView;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                CloudProfileView cloudView = (CloudProfileView)page.findView(CloudProfileView.ID);
                if (cloudView != null) {
                    cloudView.refresh(node);
                }
                if ((serversView = (CommonNavigator)page.findView("org.eclipse.wst.server.ui.ServersView")) != null) {
                    serversView.getCommonViewer().refresh(node);
                }
            }
        });
    }

    public void refresh(final Object obj) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CloudProfileView.this.tableViewer.refresh(obj);
            }
        });
    }

    public void update(final Object obj) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CloudProfileView.this.tableViewer.update(obj, null);
            }
        });
    }

    void toggleDefultPage() {
        if (this.tableViewer.getTree().getItemCount() < 1) {
            this.book.showPage(this.noServersPage);
        } else {
            this.book.showPage(this.mainPage);
        }
    }

    private void deferInitialization() {
        this.deferredInitialize();
    }

    protected void deferredInitialize() {
        this.tableViewer = this.getCommonViewer();
        this.tableViewer.setInput(ROOT_NODE);
        if (!OracleCloudTools.connections().isEmpty()) {
            this.book.showPage(this.mainPage);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
    }

    public void setExpandedElements(Object[] objects) {
        Object o;
        Object[] expanded = this.tableViewer.getExpandedElements();
        ArrayList<Object> newList = new ArrayList<Object>();
        Object[] objectArray = expanded;
        int n = expanded.length;
        int n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            if (o != null) {
                newList.add(o);
            }
            ++n2;
        }
        objectArray = objects;
        n = objects.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            if (o != null) {
                newList.add(o);
            }
            ++n2;
        }
        this.tableViewer.setExpandedElements(newList.toArray());
    }

    public static CloudProfileView getFromActivePerspective() {
        IViewPart view;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        if (PlatformUI.isWorkbenchRunning() && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (view = activePage.findView(ID)) instanceof CloudProfileView) {
            return (CloudProfileView)view;
        }
        return null;
    }
}

