/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.List;
import oracle.eclipse.tools.cloud.ActivateJavaServiceOp;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudProjectServices;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.GitRepos;
import oracle.eclipse.tools.cloud.dev.ScmService;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.view.DevCloudUiUtil;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.cloud.ui.profile.DeActivateActionDelegate;
import oracle.eclipse.tools.cloud.ui.profile.NewCloudProfileWizard;
import oracle.eclipse.tools.cloud.ui.profile.OpenInBrowserActionDelegate;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskRepositoryAction;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;

public class ActivateActionDelegate
implements IViewActionDelegate {
    protected static final String ACTIVATE = "Activate";
    protected static final String DEACTIVATE = "Deactivate";
    protected Object element = null;
    protected TreePath path = null;
    protected OpenInBrowserActionDelegate openBrowserAction = new OpenInBrowserActionDelegate();
    protected CloudProfileView cloudView = null;

    public void run(IAction action) {
        if (action.getText().equals(ACTIVATE)) {
            this.doActivate(action);
        } else {
            this.doDeactivate(action);
        }
    }

    public void doActivate(final IAction action) {
        if (this.element != null) {
            GitRepoNode gitRepo;
            CloudRepositoryNode gitLocal;
            if (this.element instanceof JavaServiceDesc) {
                String jcsName = ((ServiceDesc)this.element).getName();
                WorkspaceJob activateServerJob = new WorkspaceJob("Activating Java Cloud Service " + jcsName){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        final IServer serverCreated = ActivateActionDelegate.activate((ServiceDesc)ActivateActionDelegate.this.element);
                        if (serverCreated == null) {
                            return CloudUiPlugin.createErrorStatus("Error activating Java Cloud Service", null);
                        }
                        final CloudConnection connection = (CloudConnection)ActivateActionDelegate.this.path.getFirstSegment();
                        if (serverCreated != null) {
                            UIJob expandNodeJob = new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor arg0) {
                                    action.setText(ActivateActionDelegate.DEACTIVATE);
                                    (this).ActivateActionDelegate.this.cloudView.refresh(connection);
                                    (this).ActivateActionDelegate.this.cloudView.refresh(serverCreated);
                                    (this).ActivateActionDelegate.this.cloudView.setExpandedElements(new Object[]{connection, serverCreated});
                                    (this).ActivateActionDelegate.this.cloudView.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)serverCreated));
                                    return Status.OK_STATUS;
                                }
                            };
                            expandNodeJob.schedule(1000L);
                        }
                        return Status.OK_STATUS;
                    }
                };
                activateServerJob.setUser(true);
                activateServerJob.schedule();
                return;
            }
            if (this.element instanceof DevServiceDesc) {
                DevServiceDesc devSvc = (DevServiceDesc)this.element;
                devSvc.setActivated(true);
                this.cloudView.refresh(devSvc);
            } else if (this.element instanceof CloudProject) {
                CloudProject cp = (CloudProject)this.element;
                cp.setActivated(true);
                cp.projectServices().fetch(false);
                this.cloudView.getViewer().refresh((Object)cp);
                this.cloudView.getViewer().setExpandedState((Object)cp, true);
                action.setText(DEACTIVATE);
            } else if (this.element instanceof BuildService) {
                BuildService cps = (BuildService)this.element;
                cps.setActivated(true);
                this.cloudView.refresh(cps);
                this.cloudView.getViewer().setExpandedState((Object)cps, true);
                action.setText(DEACTIVATE);
            } else if (this.element instanceof TaskService) {
                TaskService ts = (TaskService)this.element;
                ts.setActivated(true);
                List list = ts.getBuiltInQueries();
                BuiltInQuery[] pq = list.toArray(new BuiltInQuery[0]);
                if (pq.length > 0) {
                    action.setText(DEACTIVATE);
                }
                this.cloudView.refresh(ts);
                this.cloudView.getViewer().setExpandedState((Object)ts, true);
            } else if (this.element instanceof BuiltInQuery) {
                BuiltInQuery bq = (BuiltInQuery)this.element;
                bq.setActivated(true);
                this.cloudView.refresh(bq.getTaskService());
            } else if (this.element instanceof GitRepoNode && (gitLocal = DevCloudCore.createRepositoryNode((GitRepoNode)(gitRepo = (GitRepoNode)this.element))) == null) {
                try {
                    boolean ret = DevCloudUiUtil.cloneGitRepo(gitRepo);
                    if (!ret) {
                        return;
                    }
                }
                catch (Exception e) {
                    CloudUiPlugin.log(e);
                    CloudUiPlugin.promptError("Error cloning Git repository.");
                    return;
                }
            }
            action.setText(DEACTIVATE);
        }
    }

    public void doDeactivate(IAction action) {
        if (this.element != null) {
            if (this.element instanceof BuildService) {
                BuildService buildSvc = (BuildService)this.element;
                buildSvc.setActivated(false);
                action.setText(ACTIVATE);
                this.cloudView.refresh(buildSvc);
            } else {
                if (this.element instanceof TaskService) {
                    TaskService ts = (TaskService)this.element;
                    String dcsProjBaseUrl = ts.getProjectService().getUrl();
                    TaskRepository taskRepo = DevCloudCore.findTaskRepository((String)dcsProjBaseUrl);
                    if (taskRepo != null) {
                        ts.setActivated(false);
                        this.deactivateDevCloudProjectService((CloudProjectService)ts);
                        action.setText(ACTIVATE);
                        this.cloudView.refresh(ts);
                    }
                    return;
                }
                if (this.element instanceof BuiltInQuery) {
                    BuiltInQuery bq = (BuiltInQuery)this.element;
                    bq.setActivated(false);
                } else if (this.element instanceof CloudProject) {
                    CloudProject cp = (CloudProject)this.element;
                    cp.setActivated(false);
                    CloudProjectServices cps = cp.projectServices();
                    if (cps.available()) {
                        for (CloudProjectService ps : (List)cps.content()) {
                            if (this.deactivateDevCloudProjectService(ps)) continue;
                            return;
                        }
                    }
                    cps.clear();
                } else if (this.element instanceof DevServiceDesc) {
                    DevServiceDesc devSvc = (DevServiceDesc)this.element;
                    devSvc.setActivated(false);
                    this.cloudView.refresh(devSvc);
                }
            }
            action.setText(ACTIVATE);
        }
    }

    private boolean deactivateDevCloudProjectService(CloudProjectService ps) {
        ps.setActivated(false);
        if (ps instanceof TaskService) {
            TaskService ts = (TaskService)ps;
            String dcsProjBaseUrl = ts.getProjectService().getUrl();
            TaskRepository taskRepo = DevCloudCore.findTaskRepository((String)dcsProjBaseUrl);
            if (taskRepo != null) {
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorInput in;
                    IEditorReference e = iEditorReferenceArray[n2];
                    IEditorPart part = e.getEditor(false);
                    if (part != null && (in = part.getEditorInput()) instanceof TaskEditorInput && part.isDirty() && taskRepo == ((TaskEditorInput)in).getTaskRepository()) {
                        TaskEditorInput input = (TaskEditorInput)in;
                        String msg = String.format("Task %s has been modified. Save changes?", input.getTask().getTaskId());
                        if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Save Task", (String)msg)) {
                            part.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    ++n2;
                }
                DeleteTaskRepositoryAction.run((TaskRepository)taskRepo);
            }
        } else if (ps instanceof ScmService) {
            ScmService scmSvc = (ScmService)ps;
            GitRepos gitRepos = scmSvc.gitRepos();
            if (gitRepos.available()) {
                for (GitRepoNode git : (List)gitRepos.content()) {
                    CloudRepositoryNode gitRepoNode = git.getRepositoryNode();
                    if (DeActivateActionDelegate.deactivateGitRepo(gitRepoNode, this.cloudView)) continue;
                    return false;
                }
            }
        } else {
            boolean cfr_ignored_0 = ps instanceof BuildService;
        }
        return true;
    }

    public static IServer activate(ServiceDesc sd) {
        final IServer[] serverCreated = new IServer[1];
        if (sd.getType() == ServiceDesc.TYPE.JCS) {
            final ActivateJavaServiceOp op = (ActivateJavaServiceOp)ActivateJavaServiceOp.TYPE.instantiate();
            if (op.getJavaLocation().content() != null) {
                serverCreated[0] = CloudProfileUtils.createServer((ServiceDesc)sd);
            } else {
                op.setService(sd);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SapphireWizard wizard = new SapphireWizard((Element)op, DefinitionLoader.sdef(NewCloudProfileWizard.class).wizard("ActivateJavaServiceWizard"));
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                        if (dialog.open() == 0) {
                            serverCreated[0] = (IServer)op.getServerCreated().content();
                        }
                    }
                });
            }
        }
        return serverCreated[0];
    }

    public void setSelection(Object obj) {
        this.element = obj;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection ts = null;
        ts = (TreeSelection)selection;
        if (ts.getPaths().length > 1 || ts.getPaths().length == 0) {
            action.setEnabled(false);
            return;
        }
        this.path = ts.getPaths()[0];
        this.element = ts.getFirstElement();
        if (this.element instanceof JavaServiceDesc) {
            action.setText(ACTIVATE);
            action.setEnabled(true);
        } else if (this.element instanceof BuildService) {
            BuildService cps = (BuildService)this.element;
            if (DevCloudCore.findBuildServer((BuildService)cps) == null) {
                action.setText(ACTIVATE);
            } else {
                action.setText(DEACTIVATE);
            }
        } else if (this.element instanceof TaskService) {
            TaskService cps = (TaskService)this.element;
            if (!cps.isActivated()) {
                action.setText(ACTIVATE);
            } else {
                action.setText(DEACTIVATE);
            }
        } else if (this.element instanceof BuiltInQuery) {
            BuiltInQuery bq = (BuiltInQuery)this.element;
            if (!bq.isActivated()) {
                action.setText(ACTIVATE);
            } else {
                action.setText(DEACTIVATE);
            }
        } else if (this.element instanceof CloudProject) {
            CloudProject cps = (CloudProject)this.element;
            if (!cps.isActivated()) {
                action.setText(ACTIVATE);
            } else {
                action.setText(DEACTIVATE);
            }
        } else if (this.element instanceof GitRepoNode) {
            action.setEnabled(true);
            GitRepoNode git = (GitRepoNode)this.element;
            if (!git.isCloned()) {
                action.setText(ACTIVATE);
            } else {
                action.setText(DEACTIVATE);
            }
        }
    }

    public void init(IViewPart view) {
        if (view instanceof CloudProfileView) {
            this.cloudView = (CloudProfileView)view;
        }
    }

    public static boolean promprConfirmationDialog(String message) {
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)message);
    }
}

