/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.internal;

import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.internal.ShowCompatibilityMatrixActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class UnsupportedVersionDialog
extends Dialog {
    @Text(value="Not Compatible")
    private static LocalizableText title;
    @Text(value="This version of Oracle Cloud Tools is not compatible with {0} data center. Consult <a href=\"compatibility\">the compatibility matrix</a> to find the appropriate version.")
    private static LocalizableText message;
    private final String datacenter;

    static {
        LocalizableText.init(UnsupportedVersionDialog.class);
    }

    public UnsupportedVersionDialog(Shell parentShell, String datacenter) {
        super(parentShell);
        this.datacenter = datacenter;
    }

    public static void open(ICloudProfile profile) {
        Value dc = profile.getDataCenter();
        String datacenter = ((ValueLabelService)dc.service(ValueLabelService.class)).provide((String)dc.content());
        UnsupportedVersionDialog.open(datacenter);
    }

    public static void open(String datacenter) {
        UnsupportedVersionDialog.open(null, datacenter);
    }

    public static void open(Shell parentShell, String datacenter) {
        UnsupportedVersionDialog dialog = new UnsupportedVersionDialog(parentShell, datacenter);
        dialog.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(title.text());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image errorImage = UnsupportedVersionDialog.getErrorImage(composite.getDisplay());
        Label errorImageControl = new Label(composite, 0);
        errorImage.setBackground(errorImageControl.getBackground());
        errorImageControl.setImage(errorImage);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)errorImageControl);
        Link errorMessageControl = new Link(composite, 64);
        errorMessageControl.setText(message.format(new Object[]{this.datacenter}));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)errorMessageControl);
        errorMessageControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShowCompatibilityMatrixActionHandler.run();
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private static Image getErrorImage(final Display display) {
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                image[0] = display.getSystemImage(1);
            }
        });
        return image[0];
    }
}

