/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.internal;

import java.io.File;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.swt.AbsoluteFolderPathBrowseActionHandler;
import org.w3c.dom.Element;

public final class OracleWebLogicLocationBrowseActionHandler
extends AbsoluteFolderPathBrowseActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId("Oracle.WebLogic.Location.Browse");
    }

    protected String browse(Presentation context) {
        File registryFile;
        File initiallySelectedFolder;
        String initiallySelectedPath = super.browse(context);
        if (initiallySelectedPath != null && (initiallySelectedFolder = new File(initiallySelectedPath)).exists() && initiallySelectedFolder.isDirectory() && !new File(initiallySelectedFolder, "server/lib/weblogic.jar").exists() && (registryFile = new File(initiallySelectedPath, "registry.xml")).exists()) {
            try {
                Element root = DomUtil.root((File)registryFile);
                Element elHost = DomUtil.element((Element)root, (String)"host");
                if (elHost != null) {
                    for (Element elProduct : DomUtil.elements((Element)elHost, (String)"product")) {
                        for (Element elRelease : DomUtil.elements((Element)elProduct, (String)"release")) {
                            for (Element elComponent : DomUtil.elements((Element)elRelease, (String)"component")) {
                                String install;
                                String componentName = elComponent.getAttribute("name");
                                if (!componentName.equals("WebLogic Server") || WebLogicServerVersion.detect((File)new File(install = elComponent.getAttribute("InstallDir"))) == null) continue;
                                return install;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        return initiallySelectedPath;
    }
}

