/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.java.ConflictResolver;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class PromptingJavaServiceFileSystemConflictResolver
extends ConflictResolver {
    @Text(value="Question")
    private static LocalizableText overwriteDialogTitle;
    @Text(value="Resource \"{0}\" already exists. Do you wish to overwrite?")
    private static LocalizableText overwriteDialogMessage;
    private final Mode mode;
    private final List<Path> overwritten = new ArrayList<Path>();
    private boolean overwriteAllFollowing = false;
    private boolean skipAllFollowing = false;
    private boolean aborted = false;

    static {
        LocalizableText.init(PromptingJavaServiceFileSystemConflictResolver.class);
    }

    public PromptingJavaServiceFileSystemConflictResolver() {
        this(Mode.MULTI);
    }

    public PromptingJavaServiceFileSystemConflictResolver(Mode mode) {
        this.mode = mode;
    }

    public ConflictResolver.Resolution resolve(final Path path) {
        ConflictResolver.Resolution resolution;
        block19: {
            int result;
            block18: {
                String[] stringArray;
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                    final MutableReference resolution2 = new MutableReference();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            resolution2.set((Object)PromptingJavaServiceFileSystemConflictResolver.this.resolve(path));
                        }
                    });
                    return (ConflictResolver.Resolution)resolution2.get();
                }
                if (this.overwriteAllFollowing) {
                    return ConflictResolver.Resolution.OVERWRITE;
                }
                if (this.skipAllFollowing) {
                    return ConflictResolver.Resolution.SKIP;
                }
                for (Path overwritten : this.overwritten) {
                    if (!overwritten.isPrefixOf(path)) continue;
                    return ConflictResolver.Resolution.OVERWRITE;
                }
                Shell shell = display.getActiveShell();
                String string = overwriteDialogTitle.text();
                String string2 = overwriteDialogMessage.format(new Object[]{path.toOSString()});
                if (this.mode == Mode.SINGLE) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = IDialogConstants.YES_LABEL;
                    stringArray = stringArray2;
                    stringArray2[1] = IDialogConstants.NO_LABEL;
                } else {
                    String[] stringArray3 = new String[5];
                    stringArray3[0] = IDialogConstants.YES_LABEL;
                    stringArray3[1] = IDialogConstants.YES_TO_ALL_LABEL;
                    stringArray3[2] = IDialogConstants.NO_LABEL;
                    stringArray3[3] = IDialogConstants.NO_TO_ALL_LABEL;
                    stringArray = stringArray3;
                    stringArray3[4] = IDialogConstants.CANCEL_LABEL;
                }
                MessageDialog dialog = new MessageDialog(shell, string, null, string2, 3, stringArray, 0);
                result = dialog.open();
                if (this.mode != Mode.SINGLE) break block18;
                switch (result) {
                    case 0: {
                        resolution = ConflictResolver.Resolution.OVERWRITE;
                        this.overwritten.add(path);
                        break block19;
                    }
                    case 1: {
                        resolution = ConflictResolver.Resolution.SKIP;
                        break block19;
                    }
                    case -1: {
                        resolution = ConflictResolver.Resolution.ABORT;
                        this.aborted = true;
                        break block19;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (result) {
                case 0: {
                    resolution = ConflictResolver.Resolution.OVERWRITE;
                    this.overwritten.add(path);
                    break;
                }
                case 1: {
                    resolution = ConflictResolver.Resolution.OVERWRITE;
                    this.overwriteAllFollowing = true;
                    break;
                }
                case 2: {
                    resolution = ConflictResolver.Resolution.SKIP;
                    break;
                }
                case 3: {
                    resolution = ConflictResolver.Resolution.SKIP;
                    this.skipAllFollowing = true;
                    break;
                }
                case -1: 
                case 4: {
                    resolution = ConflictResolver.Resolution.ABORT;
                    this.aborted = true;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return resolution;
    }

    public boolean aborted() {
        return this.aborted;
    }

    public static enum Mode {
        SINGLE,
        MULTI;

    }
}

